/* Program to dump a font resource to a file named "fontname.size".
   Usage: fontdump {fontname|fontid} size. */

#include <stdio.h>
#include <ctype.h>

#include <Types.h>
#include <Resources.h>
#include <Fonts.h>
#include <Memory.h>

char *progname;

main(argc, argv)
	int argc;
	char **argv;
{
	int size;
	progname= argv[0];
	if (argc != 3) {
		fprintf(stderr,
			"usage: %s {fontname|fontid} size\n", progname);
		exit(2);
	}
	size= atoi(argv[2]);
	if (size < 1 || size > 127) {
		fprintf(stderr, "%s: %s: bad size\n", progname, argv[2]);
		exit(2);
	}
	dumpfont(argv[1], size);
	exit(0);
}

dumpfont(fontname, size)
	char *fontname;
	int size;
{
	char namebuf[256];
	short fontid;
	
	/* Assume there's no need to call InitFonts,
	   since we're running under MPW. */
	
	/* Get the font id corresponding to the font name,
	   or the font name corresponding to the fond id. */
	
	GetFNum(fontname, &fontid);
	if (fontid == 0) {
		/* Font not fond -- try interpreting name as number */
		fontid= isdigit(fontname[0]) ? atoi(fontname) : -1;
		if (fontid < 0 || fontid > 255) {
			fprintf(stderr, "%s: %s: bad font name/id\n",
				progname, fontname);
			exit(2);
		}
		GetFontName(fontid, namebuf);
		if (namebuf[0] == '\0') {
			fprintf(stderr, "%s: %d: no such font id\n",
				progname, fontid);
			exit(2);
		}
		fontname= namebuf;
	}
	
	printf("fontname=%s, fontid=%d\n", fontname, fontid);
	
	/* Check that the requested size is available. */
	
	if (!RealFont(fontid, size)) {
		fprintf(stderr, "%s: %s: size %d not available\n",
			progname, fontname, size);
		exit(2);
	}
	
	/* OK, chances are we can get the resource for our font.
	   Go for it! */
	
	writefont(fontname, fontid, size);
}

writefont(fontname, fontid, size)
	char *fontname;
	int fontid;
	int size;
{
	Handle h;
	char filename[256];
	FILE *fp;
	int nbytes;
	
	/* Get the resource handle from the resource mgr.
	   Assume SetResLoad(TRUE), which is normal.
	   This might fail if there isn't enough memory.
	   Note the computation of the resource id
	   from font id and size. */
	
	h= GetResource('FONT', fontid*128 + size);
	if (h == NULL) {
		fprintf(stderr,
			"%s: can't get resource for font %s, size %d\n",
			progname, fontname, size);
		exit(1);
	}
	
	/* The font must be written to a file named "fontname.size".
	   Open this file for writing. */
	
	sprintf(filename, "%s.%d", fontname, size);
	fp= fopen(filename, "w");
	if (fp == NULL) {
		fprintf(stderr, "%s: %s: can't create file\n",
			progname, filename);
		exit(1);
	}
	
	/* Write the contents of the resource handle. */
	
	nbytes= GetHandleSize(h);
	if (fwrite(*h, 1, nbytes, fp) != nbytes) {
		fprintf(stderr, "%s: %s: fwrite (%d bytes) failed\n",
			progname, filename, nbytes);
		fclose(fp);
		exit(1);
	}
	
	fclose(fp);
}
