(Message inbox:58)
Return-Path: xpert-request@athena.mit.edu
Received: by EXPO.LCS.MIT.EDU; Fri, 13 May 88 05:23:04 EDT
Received: by ATHENA.MIT.EDU (5.45/4.7) id AA25647; Fri, 13 May 88 04:01:33 EST
Received: by BLOOM-BEACON.MIT.EDU with sendmail-5.45/4.7 
	id <AA14795@BLOOM-BEACON.MIT.EDU>; Fri, 13 May 88 04:48:07 EDT
Received: from USENET by bloom-beacon with netnews
	for xpert@athena.mit.edu (xpert@athena.mit.edu)
	(contact usenet@bloom-beacon if you have questions)
Date: 12 May 88 11:04:08 GMT
From: dana@bellcore.bellcore.com  (Dana A. Chee)
Organization: Bellcore, Morristown, NJ  USA
Subject: Re: need to convert X10 font to X11
Message-Id: <DANA.GNUS18@dino.bellcore.com>
References: <243@laic.UUCP>
Sender: xpert-request@athena.mit.edu
To: xpert@athena.mit.edu

For those who still are able to run the X10 server, below is a program
which will convert an X10 font to an X11 one.

(Remove signature from end).
--------------  x11font.c -----------
/* 
 * x11font.c --
 *
 *	Given the name of an X10 font and optionally a range of
 *	characters, this program will retrieve the font's characters
 *	from the X10 server and output an X11 font file in Adobe
 *	format.  The program only runs on B&W displays.
 *
 * Copyright 1987 Regents of the University of California
 * All rights reserved.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header: protoPub.c,v 1.3 87/01/04 17:28:56 andrew Exp $ SPRITE (Berkeley)";
#endif not lint


#include <stdio.h>
#include <X/Xlib.h>
#include <ctype.h>

main(argc, argv)
    int argc;
    char **argv;
{
    Window w;
    FontInfo *fontPtr;
    int i, maxWidth, first, last, bitsSize, baseline;
    short *bits;

    /*
     * There must be a single command-line argument:  name of font.
     */

    if (argc == 4) {
	first = atoi(argv[2]);
	last = atoi(argv[3]);
    } else {
	first = 0;
	last = 127;
	if (argc != 2) {
	    fprintf(stderr,
		    "Bad arguments:  x11font fontName [firstChar lastChar]\n");
	    exit(1);
	}
    }

    if (XOpenDisplay((char *) NULL) == NULL) {
	fprintf(stderr, "X11font couldn't open display.  Is X10 running?\n");
	fprintf(stderr, "Is your DISPLAY environment variable set?\n");
	exit(1);
    }
    if (DisplayCells() != 2) {
	fprintf(stderr, "X11font can only run on black-and-white displays.\n");
	exit(1);
    }
    fontPtr = XOpenFont(argv[1]);
    if (fontPtr == NULL) {
	fprintf(stderr, "X11font couldn't open font \"%s\".\n", argv[1]);
	exit(1);
    }
    if (first < fontPtr->firstchar) {
	first = fontPtr->firstchar;
    }
    if (last > fontPtr->lastchar) {
	last = fontPtr->lastchar;
    }
    if (fontPtr->fixedwidth) {
	maxWidth = fontPtr->width;
	} else {
	maxWidth = 0 ;
	for (i = first; i < last; i++) {
	    if (fontPtr->widths[i - fontPtr->firstchar] > maxWidth) {
		maxWidth = fontPtr->widths[i - fontPtr->firstchar];
	    }
	}
    }
    bitsSize = XYPixmapSize(maxWidth, fontPtr->height, 1);
    bits = (short *) malloc(bitsSize);
    baseline = fontPtr->baseline;
    if (baseline < 0) {
	baseline = -baseline;
    }
    if ((fontPtr->height - baseline) < baseline) {
	baseline = fontPtr->height - baseline;
    }
    w = XCreateWindow(RootWindow, 0, 0, maxWidth +20, fontPtr->height + 20, 2,
	    BlackPixmap, WhitePixmap);
    XMapWindow(w);

    /*
     * Output header information for the font.
     */

    printf("STARTFONT 2.1\n");
    printf("COMMENT The X10 name for this font was \"%s\"\n", argv[1]);
    printf("FONT %s\n", argv[1]);
    printf("SIZE 11 75 75\n");
    printf("FONTBOUNDINGBOX %d %d 0 0\n", maxWidth, fontPtr->height);
    printf("STARTPROPERTIES 2\n");
    printf("FONT_DESCENT %d\n", baseline);
    printf("FONT_ASCENT %d\n", fontPtr->height - baseline);
    printf("ENDPROPERTIES\n");
    printf("CHARS %d\n", last+1-first);

    for (i = first; i <= last; i++) {
	char string[2];
	short *curBits;
	int x, y, width;
	string[0] = i;
	string[1] = 0;

	if (fontPtr->fixedwidth) {
	    width = fontPtr->width;
	} else {
	    width = fontPtr->widths[i - fontPtr->firstchar];
	}

	/*
	 * Output header information for the character.
	 */

	if (isascii(i) && isprint(i) && (i != ' ')) {
	    printf("STARTCHAR %c\n", i);
	} else {
	    printf("STARTCHAR C%03o\n", i);
	}
	printf("ENCODING %d\n", i);
	printf("SWIDTH 1 0\n");
	printf("DWIDTH %d 0\n", width);
	printf("BBX %d %d 0 %d\n", width, fontPtr->height, -baseline);
	printf("BITMAP\n");

	/*
	 * Draw the character on the screen, then retrieve the bits
	 * into local memory.
	 */

	for (x = 0; x < bitsSize/2; x++) {
	    bits[x] = 0;
	}
	if (width > 0) {
	    XClear(w);
	    XText(w, 10, 10, string, 1, fontPtr->id, BlackPixel, WhitePixel);
	    XPixmapGetXY(w, 10, 10, width, fontPtr->height, bits);
	}
	for (y = 0, curBits = bits; y < fontPtr->height; y++) {
	    if (width == 0) {
		printf("0\n");
		continue;
	    }
	    for (x = 0; x < width; x += 16, curBits++) {
		int tmp, numBits, z;

		/*
		 * The bits are in the wrong order.  Flip them.
		 */

		numBits = width - x;
		if (numBits > 16) {
		    numBits = 16;
		}
		for (z = 0, tmp = 0; z < numBits; z++) {
		    if ((*curBits & (1<<z)) == 0) {
			tmp |= 1 << (15-z);
			/* printf("X"); */
		    }/* else {
			printf(" ");
		    } */
		}

		printf("%02x", (tmp >> 8) & 0xff);
		if (numBits > 8) {
		    printf("%02x", tmp & 0xff);
		}
	    }
	    printf("\n");
	}
	printf("ENDCHAR\n");
    }
    printf("ENDFONT\n");
}
--
			Dana Chee
			Bellcore
			MRE 2Q-250
			(201) 829-4488
			dana@bellcore.com
