/*
    File:   polyfill.c
    By:     Don Hatch
  
    For:    Yaq (Yet Another Qix)

    Cute randomized recursive seed fill routine,
    until bug in the real one gets fixed
  
    Just a little note to remind whom-ever:
  
	The coordinate values (x and y) used in polyfill() are NOT the actual
	coordinate values of the board.  Instead, they are twice the size of
	the board and represent the quadrants within a cell.
*/

#include    "qix.h"


/* Filled areas look-up tables */
int fill_table[2][2] = {	/* Filled state bits */
    {CL_PNT_UL, CL_PNT_LL},
    {CL_PNT_UR, CL_PNT_LR}
};
int edge_table[4][2][2] = {	/* Edge state bits */
    {			/* Look left */
	{0, 0},
	{CL_LN_UP, CL_LN_DN}
    },
    {			/* Look right */
	{CL_LN_UP, CL_LN_DN},
	{0, 0}
    },
    {			/* Look up */
	{0, CL_LN_LF},
	{0, CL_LN_RT}
    },
    {			/* Look down */
	{CL_LN_LF, 0},
	{CL_LN_RT, 0}
    }
};

/* Macro for testing and changing the current (x,y) points state */

#define pttest(x,y)	(board[(x)/2][(y)/2] & fill_table[(x)&1][(y)&1])


#define lntest(x,y,d) (board[(x)/2][(y)/2] & edge_table[d-LEFT][(x)&1][(y)&1])

#define ptclr(x,y) \
    (board[(x)/2][(y)/2] &= ~fill_table[(x)&1][(y)&1]), region_score++;

#ifndef DEBUG
#define ptset(x,y) \
    (board[(x)/2][(y)/2] |= fill_table[(x)&1][(y)&1]), region_score++;

#else

ptset(x,y)
register int x,y;
{
    extern region_score;
    board[x/2][y/2] |= fill_table[x&1][y&1], region_score++;
    if (debug)
	/* pw_put(draw_win, convert_x(x/2), convert_y(y/2)-3, 1); */
    box(convert_x(x/2)-3 + ((x&1)*4), convert_y(y/2)-3 + ((y&1)*4),
        convert_x(x/2)-3 + ((x&1)*4)+2, convert_y(y/2)-3 + ((y&1)*4)+2,PIX_SRC);
}
#endif DEBUG

static region_score;
static depth = 0;

int seedfill1(), seedfill2(), seedfill3(), seedfill4();
int (*seedfills[])() = {seedfill1, seedfill2, seedfill3, seedfill4};
#define seedfill (seedfills[(rand()>>5) % 4])

/* polyfill(x, y) - Flood the enclosed region found to surround (x,y) */
polyfill(x, y)
register int x, y;
{
    region_score = 0;
    seedfill(x,y);
    return region_score;
}
static
seedfill1(x, y)
register int x, y;
{
    ++depth;
    if (depth == toodeep) {
	printf("Too deep! stack depth exceeded %d\n",toodeep);
	depth--;
	return;
    }
    if (pttest(x, y)) {
	depth--;
	return;
    }
    /* Fill in initial point */
    ptset(x, y);
    if (!lntest(x, y, LEFT))
	seedfill(x - 1, y);
    if (!lntest(x, y, DOWN))
	seedfill(x, y + 1);
    if (!lntest(x, y, RIGHT))
	seedfill(x + 1, y);
    if (!lntest(x, y, UP))
	seedfill(x, y - 1);
    depth--;
}

static
seedfill2(x, y)
register int x, y;
{
    ++depth;
    if (depth == toodeep) {
	printf("Too deep! stack depth exceeded %d\n",toodeep);
	depth--;
	return;
    }
    if (pttest(x, y)) {
	depth--;
	return;
    }
    /* Fill in initial point */
    ptset(x, y);
    if (!lntest(x, y, RIGHT))
	seedfill(x + 1, y);
    if (!lntest(x, y, UP))
	seedfill(x, y - 1);
    if (!lntest(x, y, LEFT))
	seedfill(x - 1, y);
    if (!lntest(x, y, DOWN))
	seedfill(x, y + 1);
    depth--;
}

static
seedfill3(x, y)
register int x, y;
{
    ++depth;
    if (depth == toodeep) {
	printf("Too deep! stack depth exceeded %d\n",toodeep);
	depth--;
	return;
    }
    if (pttest(x, y)) {
	depth--;
	return;
    }
    /* Fill in initial point */
    ptset(x, y);
    if (!lntest(x, y, UP))
	seedfill(x, y - 1);
    if (!lntest(x, y, LEFT))
	seedfill(x - 1, y);
    if (!lntest(x, y, DOWN))
	seedfill(x, y + 1);
    if (!lntest(x, y, RIGHT))
	seedfill(x + 1, y);
    depth--;
}

static
seedfill4(x, y)
register int x, y;
{
    ++depth;
    if (depth == toodeep) {
	printf("Too deep! stack depth exceeded %d\n",toodeep);
	depth--;
	return;
    }
    if (pttest(x, y)) {
	depth--;
	return;
    }
    /* Fill in initial point */
    ptset(x, y);
    if (!lntest(x, y, DOWN))
	seedfill(x, y + 1);
    if (!lntest(x, y, UP))
	seedfill(x, y - 1);
    if (!lntest(x, y, RIGHT))
	seedfill(x + 1, y);
    if (!lntest(x, y, LEFT))
	seedfill(x - 1, y);
    depth--;
}
