
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/enter.c,v 3.1 88/09/20 00:44:01 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#ifndef ibm032
#include <sys/ipc.h>
#include <sys/shm.h>
#endif ibm032
#include <errno.h>
#include <pwd.h>
#include <ctype.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

/* Enter the game */

long random();
char	*shipclass= "ship";
int remapgalaxy;
int noshipclass;

enter(tno, disp, pno)
int tno;
char	*disp;
int pno;
{
    struct passwd	*pwent, *getpwuid();
    char	 	*pseudo;
    char	 	*customship;
    char		buf[80];

    if ((pwent = getpwuid(getuid())) == NULL)
	(void) strncpy(me->p_login, "Bozo", sizeof (me->p_login));
    else
	(void) strncpy(me->p_login, pwent->pw_name, sizeof (me->p_login));

    if ( dpy )  /* if dpy is NULL then we are the robot */
        pseudo = XGetDefault(dpy, "xtrek", "name");
    else
	pseudo = NULL;

    if (pseudo == NULL)
	(void) strncpy(me->p_name, me->p_login, sizeof (me->p_name));
    else
	(void) strncpy(me->p_name, pseudo, sizeof (me->p_name));
    me->p_no = pno;
    me->p_updates = 0;
    me->p_flags = PFSHIELD;
    (void) strncpy(me->p_monitor, disp, sizeof (me->p_monitor));
    me->p_dir = 0;
    me->p_desdir = 0;
    me->p_speed = 0;
    me->p_desspeed = 0;
    me->p_subspeed = 0;
    me->p_team = (1 << tno);
    me->p_x = planets[tno * 10].pl_x + (random() % 10000) - 5000;
    me->p_y = planets[tno * 10].pl_y + (random() % 10000) - 5000;
    me->p_ntorp = 0;
    me->p_damage = 0;
    me->p_subdamage = 0;
    me->p_etemp = 0;
    me->p_etime = 0;
    me->p_wtemp = 0;
    me->p_wtime = 0;
    me->p_subshield = 0;
    me->p_swar = 0;
    me->p_hostile = (FED|ROM|KLI|ORI);
    me->p_hostile &= ~me->p_team;
    me->p_kills = 0.0;
    me->p_armies = 0;

    sprintf(buf, "%c%x", teamlet[me->p_team], me->p_no);
    strncpy(me->p_mapchars, buf, 2);

    if ( dpy )  /* if dpy is NULL then we are the robot */
        customship = XGetDefault(dpy, "xtrek", shipclass);
    else
	customship = "";

    if (status->configurable == NOT_CONFIGURABLE && customship && *customship) {
	fprintf(stderr,"This game does not allow configurable ships (e.g. %s)\n",
		customship);
	customship = "";
    }
    getship(myship,customship);

    mystats->st_entries++;
    me->p_shield = myship->s_maxshields;
    me->p_fuel = myship->s_maxfuel;
    delay = 0;
}

openmem()
{
    extern int errno;
    int	shmemKey = PKEY;
    int	shmid;
    struct memory	*sharedMemory;

    errno = 0;
#ifndef ibm032
    shmid = shmget(shmemKey, 0, 0);
    if (shmid < 0) {
	if (errno != ENOENT) {
	    perror("shmget");
	    exit(1);
	}
	startdaemon();
	sleep(2);
	shmid = shmget(shmemKey, 0, 0);
	if (shmid < 0) {
	    fprintf(stderr, "Daemon not running\n");
	    exit (1);
	}
    }
    sharedMemory = (struct memory *) shmat(shmid, 0, 0);
    if (sharedMemory == (struct memory *) -1) {
	perror("shared memory");
	exit (1);
    }
#else
    sharedMemory = (struct memory *)0xef100100;
    if ( ( *(int *) 0xef100000 ) != 0x4a454646 )
	{
	fprintf(stderr, "Starting Daemon\n");
	startdaemon();
	sleep(2);
        if ( ( *(long *) 0xef100000 ) != 0x4a454646 )
	    {
	    fprintf(stderr, "Daemon not running\n");
	    exit (1);
	    }
	}

#ifdef DEBUG
    else
	{
    	if (remapgalaxy)
	    fprintf(stderr, "Sorry, can't remap - ");
	fprintf(stderr, "Daemon already running\n");
	}
#endif DEBUG
#endif ibm032
	    
    players = sharedMemory->players;
    torps = sharedMemory->torps;
    status = sharedMemory->status;
    planets = sharedMemory->planets;
    phasers = sharedMemory->phasers;
    mctl = sharedMemory->mctl;
    messages = sharedMemory->messages;
}

findslot()
{
    register int i;

    for (i = 0; i < MAXPLAYER; i++) {
	if (players[i].p_status == PFREE) {	/* We have a free slot */
	    players[i].p_status = POUTFIT;	/* possible race code */
	    break;
	}
    }
    if (i == MAXPLAYER) {
	fprintf(stderr, "No more room in game\n");
	exit (0);
    }
    bzero(&players[i].p_stats, sizeof(struct stats));  /* Slight problem for
							  copilot */
    return(i);
}
