/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/newwin.c,v 3.1 88/09/20 00:44:27 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "bitmaps.h"

#define SIZEOF(a)	(sizeof (a) / sizeof (*(a)))

#define BOXSIDE		(WINSIDE / 5)
#define TILESIDE	16
#define STATSIZE	(messagesize * 2 + borderSize)

static XFontStruct	*bigFont;
extern int xtIOError();
    
newwin(hostmon, progname)
char *hostmon, *progname;
{
    XWMHints hints;
    XSetWindowAttributes attr;
    Pixmap icon_pixmap;

    if ((dpy = XOpenDisplay(hostmon)) == NULL) {
	perror(hostmon);
	exit(1);
    }

    XSetIOErrorHandler(xtIOError);

    screen = DefaultScreen(dpy);
    cmap = DefaultColormap(dpy, screen);
    root = RootWindow(dpy, screen);
    visual = DefaultVisual(dpy, screen);
    mono = DisplayCells(dpy, screen) <= 2;

    getResources(progname);

    messagesize = FONTHEIGHT(dfontinfo) + MESSAGEBD * 2;

    savebitmaps();

/*

    baseWin = XCreateSimpleWindow(dpy, root, 0, YOFF, WINSIDE * 2 + 2 * borderSize,
	WINSIDE + 2 * borderSize + 2 * messagesize, borderSize, 0, backColor);
    XSetWindowBorderPixmap( dpy, baseWin, gTile );
*/

    attr.background_pixel = backColor;
    attr.border_pixmap = gTile;
    attr.cursor = crosshair;

    baseWin = XCreateWindow(dpy, root, startX, startY, WINSIDE * 2 + borderSize,
	WINSIDE + 2 * borderSize + 2 * messagesize, borderSize, 
	DefaultDepth(dpy, screen), InputOutput, visual,
	CWBackPixel|CWBorderPixmap|CWCursor, &attr );
	

    icon_pixmap = XCreatePixmapFromBitmapData( dpy, root, icon_bits,
	icon_width, icon_height, WhitePixel(dpy, screen), 
	BlackPixel(dpy, screen), DefaultDepth(dpy, screen) );
    attr.background_pixmap = icon_pixmap;
    attr.border_pixmap = gTile;
    attr.cursor = crosshair;

    iconWin = XCreateWindow(dpy, root, 0, 0, icon_width, icon_height, borderSize, 
	DefaultDepth(dpy, screen), InputOutput, visual,
	CWBackPixmap|CWBorderPixmap|CWCursor, &attr );

/*
    iconWin = XCreateSimpleWindow(dpy, root, 0, 0, icon_width, icon_height,
	borderSize, 0, backColor );
*/

    hints.flags = IconWindowHint;
    hints.icon_window = iconWin;
    XSetWMHints( dpy, baseWin, &hints );
    XStoreName( dpy, baseWin, "XTrek" );

    w = XCreateSimpleWindow(dpy, baseWin, -borderSize, -borderSize, WINSIDE, WINSIDE, 
	borderSize, borderColor, backColor);
    mapw = XCreateSimpleWindow(dpy, baseWin, WINSIDE, -borderSize, WINSIDE,
	WINSIDE, borderSize, borderColor, backColor);
    tstatw = XCreateSimpleWindow(dpy, baseWin, -borderSize, WINSIDE, WINSIDE,
	STATSIZE, borderSize, borderColor, backColor);
    warnw = XCreateSimpleWindow(dpy, baseWin, WINSIDE, WINSIDE,
	WINSIDE, messagesize, borderSize, borderColor, backColor);
    messagew = XCreateSimpleWindow(dpy, baseWin, WINSIDE,
	WINSIDE + borderSize + messagesize,
	WINSIDE, messagesize, borderSize, borderColor, backColor);
    planetw = XCreateSimpleWindow(dpy, root, 5, 5, 47 * FONTWIDTH(dfontinfo),
	(MAXPLANETS + 3) * FONTHEIGHT(dfontinfo), 2, borderColor, backColor);
    playerw = XCreateSimpleWindow(dpy, root, 5, 5, 66 * FONTWIDTH(dfontinfo),
	(MAXPLAYER + 1) * FONTHEIGHT(dfontinfo) + 2 * MESSAGEBD, 2, 
	borderColor, backColor);
    helpWin = XCreateSimpleWindow(dpy, root,
	0, startY + WINSIDE + 2 * borderSize + 2 * messagesize,
	WINSIDE * 2 + 1 * borderSize, 10 * FONTHEIGHT(dfontinfo),
	borderSize, borderColor, backColor);

    XSetTransientForHint( dpy, helpWin, baseWin );
    XSetTransientForHint( dpy, playerw, baseWin );
    XSetTransientForHint( dpy, planetw, baseWin );

/* These windows will be used for setting one's warlike stats */

#define WARHEIGHT (FONTHEIGHT(dfontinfo) * 2)
#define WARWIDTH (FONTWIDTH(dfontinfo) * 20)
#define WARBORDER 2
    war = XCreateSimpleWindow(dpy, baseWin, WINSIDE+ 10, -borderSize + 10, WARWIDTH,
	WARHEIGHT * 6, WARBORDER, borderColor, backColor);
    warf = XCreateSimpleWindow(dpy, war, 0, 0 * WARHEIGHT, WARWIDTH,
	 WARHEIGHT, WARBORDER, borderColor, backColor);
    warr = XCreateSimpleWindow(dpy, war, 0, 1 * WARHEIGHT, WARWIDTH,
	 WARHEIGHT, WARBORDER, borderColor, backColor);
    wark = XCreateSimpleWindow(dpy, war, 0, 2 * WARHEIGHT, WARWIDTH,
	 WARHEIGHT, WARBORDER, borderColor, backColor);
    waro = XCreateSimpleWindow(dpy, war, 0, 3 * WARHEIGHT, WARWIDTH,
	 WARHEIGHT, WARBORDER, borderColor, backColor);
    wargo = XCreateSimpleWindow(dpy, war, 0, 4 * WARHEIGHT, WARWIDTH,
	 WARHEIGHT, WARBORDER, borderColor, backColor);
    warno = XCreateSimpleWindow(dpy, war, 0, 5 * WARHEIGHT, WARWIDTH,
	 WARHEIGHT, WARBORDER, borderColor, backColor);

    XMapWindow(dpy, warf);
    XMapWindow(dpy, warr);
    XMapWindow(dpy, wark);
    XMapWindow(dpy, waro);
    XMapWindow(dpy, wargo);
    XMapWindow(dpy, warno);

    XSync(dpy, 0);
}

/*
 * this is separate from newwin.  It should; be called *after*
 * openmem.  If not, expose events will be eaten by the forked
 * process (daemon).
 */
mapAll()
{
    initinput();
    XMapWindow(dpy, mapw);
    XMapWindow(dpy, tstatw);
    XMapWindow(dpy, warnw);
    XMapWindow(dpy, messagew);
    XMapWindow(dpy, w);
    XMapWindow(dpy, baseWin);
    XSync(dpy, 0);
}

savebitmaps()
{
    Pixmap cur, curm;
    register int i;
    XColor curf, curb;
    cur = CreateBitmap(dpy, root, crossbits, crossw, crossh);
    curm = CreateBitmap(dpy, root, crossmask_bits, crossw, crossh);
    curf.pixel = myColor;
    curb.pixel = backColor;
    XQueryColor(dpy, cmap, &curf);
    XQueryColor(dpy, cmap, &curb);
    crosshair = XCreatePixmapCursor(dpy, cur, curm, &curf, &curb, 8, 8);
}

/* This routine throws up an entry window for the player. */

entrywindow() 
{
    int team;
    long	startTime;
    Window fwin, rwin, kwin, owin, qwin;
    XEvent event;
    int numfed, numrom, numkli, numori, numtmp;

    /* The following allows quick choosing of teams */
    if ((me->p_team & FED) && !mustexit) {
	fwin = XCreateSimpleWindow(dpy, w, 0 * BOXSIDE, WINSIDE - BOXSIDE, 
	    BOXSIDE, BOXSIDE, 1, shipCol[1], backColor);
	XSelectInput(dpy, fwin, KeyPressMask|ButtonPressMask|ButtonReleaseMask|
	    ExposureMask);
	XMapWindow(dpy, fwin);
    }
    else {
	fwin = XCreateSimpleWindow(dpy, w, 0 * BOXSIDE, WINSIDE - BOXSIDE, 
	    BOXSIDE, BOXSIDE, 1, shipCol[1], 0);
	XSetWindowBackgroundPixmap(dpy, fwin, stippleTile);
	XSelectInput(dpy, fwin, ExposureMask);
	XMapWindow(dpy, fwin);
    }
    if ((me->p_team & ROM) && !mustexit) {
	rwin = XCreateSimpleWindow(dpy, w, 1 * BOXSIDE, WINSIDE - BOXSIDE, 
	    BOXSIDE, BOXSIDE, 1, shipCol[2], backColor);
	XSelectInput(dpy, rwin, KeyPressMask|ButtonPressMask|ButtonReleaseMask|
	    ExposureMask);
	XMapWindow(dpy, rwin);
    }
    else {
	rwin = XCreateSimpleWindow(dpy, w, 1 * BOXSIDE, WINSIDE - BOXSIDE, 
	    BOXSIDE, BOXSIDE, 1, shipCol[2], 0);
	XSelectInput(dpy, rwin, ExposureMask);
	XSetWindowBackgroundPixmap(dpy, rwin, stippleTile);
	XMapWindow(dpy, rwin);
    }
    if ((me->p_team & KLI) && !mustexit) {
	kwin = XCreateSimpleWindow(dpy, w, 2 * BOXSIDE, WINSIDE - BOXSIDE, 
	    BOXSIDE, BOXSIDE, 1, shipCol[3], backColor);
	XSelectInput(dpy, kwin, KeyPressMask|ButtonPressMask|ButtonReleaseMask|
	    ExposureMask);
	XMapWindow(dpy, kwin);
    }
    else {
	kwin = XCreateSimpleWindow(dpy, w, 2 * BOXSIDE, WINSIDE - BOXSIDE, 
	    BOXSIDE, BOXSIDE, 1, shipCol[3], 0);
	XSetWindowBackgroundPixmap(dpy, kwin, stippleTile);
	XSelectInput(dpy, kwin, ExposureMask);
	XMapWindow(dpy, kwin);
    }
    if ((me->p_team & ORI) && !mustexit) {
	owin = XCreateSimpleWindow(dpy, w, 3 * BOXSIDE, WINSIDE - BOXSIDE, 
	    BOXSIDE, BOXSIDE, 1, shipCol[4], backColor);
	XSelectInput(dpy, owin, KeyPressMask|ButtonPressMask|ButtonReleaseMask|
	    ExposureMask);
	XMapWindow(dpy, owin);
    }
    else {
	owin = XCreateSimpleWindow(dpy, w, 3 * BOXSIDE, WINSIDE - BOXSIDE, 
	    BOXSIDE, BOXSIDE, 1, shipCol[4], 0);
	XSetWindowBackgroundPixmap(dpy, owin, stippleTile);
	XSelectInput(dpy, owin, ExposureMask);
	XMapWindow(dpy, owin);
    }
    qwin = XCreateSimpleWindow(dpy, w, 4 * BOXSIDE, WINSIDE - BOXSIDE, 
	BOXSIDE, BOXSIDE, 1, textColor, backColor);
    XSelectInput(dpy, qwin, KeyPressMask|ButtonPressMask|ExposureMask);
    XMapWindow(dpy, qwin);

    team = -1;
    startTime = time(0);
    makeClock(qwin);
    numfed = numrom = numkli = numori = -1;
    do {
	    me->p_ghostbuster = 0;
	    while (!XPending(dpy)) {
		int		mask, elapsed;
		struct timeval	tv;

		me->p_ghostbuster = 0;
		tv.tv_sec = 1;
		tv.tv_usec = 0;
		mask = 1 << dpyno();
		select(dpyno() + 1, &mask, 0, 0, &tv);
		elapsed = time(0) - startTime;
		if (elapsed > AUTOQUIT) {
		    printf("Auto-Quit.\n");
		    team = 4;
		    break;
		}
		showTimeLeft(elapsed, AUTOQUIT);
		if ( numfed != ( numtmp = numShips(FED) ) ) {
		    redrawFed(fwin);
		    numfed = numtmp;
		}
		if ( numrom != ( numtmp = numShips(ROM) ) ) {
		    redrawRom(rwin);
		    numrom = numtmp;
		}
		if ( numkli != ( numtmp = numShips(KLI) ) ) {
		    redrawKli(kwin);
		    numkli = numtmp;
		}
		if ( numori != ( numtmp = numShips(ORI) ) ) {
		    redrawOri(owin);
		    numori = numtmp;
		}
	    }
	    if (team == 4)
		break;

	    XNextEvent(dpy, &event);
	    switch ((int) event.type) {
		case KeyPress:
		case ButtonPress:
		    {
		    XKeyEvent *ev = (XKeyEvent *)(&event);
		    if (ev->window == fwin)
			team = 0;
		    else if (ev->window == rwin)
			team = 1;
		    else if (ev->window == kwin)
			team = 2;
		    else if (ev->window == owin)
			team = 3;
		    else if (ev->window == qwin)
			team = 4;
		    break;
		    }
		case Expose:
		    {
		    XExposeEvent *ev = (XExposeEvent *)(&event);
		    if (ev->window == fwin)
			redrawFed(fwin);
		    else if (ev->window == rwin)
			redrawRom(rwin);
		    else if (ev->window == kwin)
			redrawKli(kwin);
		    else if (ev->window == owin)
			redrawOri(owin);
		    else if (ev->window == qwin)
			redrawQuit(qwin);
		    else if (ev->window == tstatw)
			redrawTstats();
		    else if (ev->window == iconWin)
  			drawIcon();
		    else if (ev->window == w)
			showMotd();
		    else if (ev->window == helpWin)
			fillhelp();

		    break;
		    }
	    }
    } while (team < 0);
    destroyClock();

    if (team == 4)
	team = -1;
				
    XDestroyWindow(dpy, fwin);
    XDestroyWindow(dpy, rwin);
    XDestroyWindow(dpy, kwin);
    XDestroyWindow(dpy, owin);
    XDestroyWindow(dpy, qwin);
    return(team);
}

numShips(owner)
{
	int		i, num = 0;
	struct player	*p;

	for (i = 0, p = players; i < MAXPLAYER; i++, p++)
		if (p->p_status == PALIVE && p->p_team == owner)
			num++;
	return (num);
}

static char	*AUTHOR[] = {
    "",
    "---  XTREK Release Version 4.0 ---",
    "",
    "By Chris Guthrie (chris@ic.berkeley.edu)",
    "And Ed James (edjames@ic.berkeley.edu)",
    "X11 version by Jeff Weinstein"
};

showMotd()
{
    char buf[BUFSIZ];
    FILE *motd, *fopen();
    int	i, length, top, center;

    /* Author Gratification */
    XClearWindow(dpy, w);
    for (i = 0; i < SIZEOF(AUTHOR); i++) {
	length = strlen(AUTHOR[i]);
	center = WINSIDE / 2 - (length * FONTWIDTH(dfontinfo)) / 2;
	XText(w, center, i * FONTHEIGHT(dfontinfo), AUTHOR[i], 
	    length, dfont, textColor, backColor);
    }
    top = SIZEOF(AUTHOR) + 2;

    /* the following will print a motd */
    if ((motd = fopen( MOTD , "r")) != NULL) {
	for (i = top; fgets(buf, sizeof (buf), motd) != NULL; i++) {
	    length = strlen(buf);
	    buf[length-1] = NULL;
	    if (length > 80)
		length = 80;
	    XText(w, 20, i * FONTHEIGHT(dfontinfo), buf, length, dfont,
		textColor, backColor);
	}
	(void) fclose(motd);
    }
}

getResources(prog)
	char	*prog;
{
    getFonts(prog);
    getColorDefs(prog);
    getTiles(prog);
    initStats(prog);

    showShields = booleanDefault(prog, "showShields");
    showStats = booleanDefault(prog, "showStats");
}

static char	solid[TILESIDE*2] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};
static char	gray[TILESIDE*2] = {
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
};
static char	striped[TILESIDE*2] = {
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f,
};

getTiles(prog)
	char	*prog;
{
	char	rPatt[TILESIDE*2], yPatt[TILESIDE*2], gPatt[TILESIDE*2];
	int	rSize = sizeof (rPatt);
	int	ySize = sizeof (yPatt);
	int	gSize = sizeof (gPatt);
	XImage	*image;
	GC	gc;

	backTile = XMakeTile(backColor);
	foreTile = XMakeTile(borderColor);

	gc = XCreateGC(dpy, root, 0, NULL);

	if ( !mono ) {
		rTile = XMakeTile(rColor);
		yTile = XMakeTile(yColor);
		gTile = XMakeTile(gColor);
	} else {
		if (arrayDefault(prog, "RalertPattern", &rSize, rPatt) < 0) {
			rSize = TILESIDE;
			bcopy(striped, rPatt, sizeof (rPatt));
		}
		if (arrayDefault(prog, "YalertPattern", &ySize, yPatt) < 0) {
			ySize = TILESIDE;
			bcopy(gray, yPatt, sizeof (yPatt));
		}
		if (arrayDefault(prog, "GalertPattern", &gSize, gPatt) < 0) {
			gSize = TILESIDE;
			bcopy(solid, gPatt, sizeof (gPatt));
		}

		XSetForeground(dpy, gc, rColor);
		XSetBackground(dpy, gc, backColor);
		image = XCreateImage(dpy, DefaultVisual(dpy, screen), 1, XYBitmap, 0, rPatt, rSize, rSize, 8, 0);
		rTile = XCreatePixmap(dpy, root, rSize, rSize, DefaultDepth(dpy, screen) );
		XPutImage(dpy, rTile, gc, image, 0, 0, 0, 0, TILESIDE, TILESIDE);
		XFree(image);

		XSetForeground(dpy, gc, yColor);
		XSetBackground(dpy, gc, backColor);
		image = XCreateImage(dpy, DefaultVisual(dpy, screen), 1, XYBitmap, 0, yPatt, ySize, ySize, 8, 0);
		yTile = XCreatePixmap(dpy, root, ySize, ySize, DefaultDepth(dpy, screen) );
		XPutImage(dpy, yTile, gc, image, 0, 0, 0, 0, TILESIDE, TILESIDE);
		XFree(image);

		XSetForeground(dpy, gc, gColor);
		XSetBackground(dpy, gc, backColor);
		image = XCreateImage(dpy, DefaultVisual(dpy, screen), 1, XYBitmap, 0, gPatt, gSize, gSize, 8, 0);
		gTile = XCreatePixmap(dpy, root, gSize, gSize, DefaultDepth(dpy, screen) );
		XPutImage(dpy, gTile, gc, image, 0, 0, 0, 0, TILESIDE, TILESIDE);
		XFree(image);

	}

	XSetForeground(dpy, gc, textColor);
	XSetBackground(dpy, gc, backColor);
	image = XCreateImage(dpy, DefaultVisual(dpy, screen), 1, XYBitmap, 0, 
		stipple_bits, stipple_width, stipple_height, 8, 0);
	stippleTile = XCreatePixmap(dpy, root, stipple_width, stipple_height, DefaultDepth(dpy, screen) );
	XPutImage(dpy, stippleTile, gc, image, 0, 0, 0, 0, stipple_width, stipple_height);
	XFree(image);
	XFreeGC(dpy, gc);

}

getFonts(prog)
	char	*prog;
{
    char	*font;
    char **fontdirs;
    char **newfontdirs;
    int npaths;
    XFontStruct *xtrekfontinfo;
    
    if ((font = XGetDefault(dpy, prog, "font")) == NULL)
	font = "serif10";
    if ((dfontinfo = XLoadQueryFont(dpy, font)) == NULL) {
	perror(font);
	exit(1);
    }

    if ((font = XGetDefault(dpy, prog, "boldFont")) == NULL)
	font = "serifb10";
    if ((bfontinfo = XLoadQueryFont(dpy, font)) == NULL)
	bfontinfo = dfontinfo;

    if ((font = XGetDefault(dpy, prog, "italicFont")) == NULL)
	font = "serifi10";
    if ((ifontinfo = XLoadQueryFont(dpy, font)) == NULL)
	ifontinfo = dfontinfo;

    if ((font = XGetDefault(dpy, prog, "bigFont")) == NULL)
	font = "vg-40";
    if ((bigFont = XLoadQueryFont(dpy, font)) == NULL)
	bigFont = dfontinfo;

    dfont = dfontinfo->fid;
    bfont = bfontinfo->fid;
    ifont = ifontinfo->fid;

    if ((font = XGetDefault(dpy, prog, "xtrekFont")) == NULL)
	font = "xtrek";
    xtrekfontinfo = XLoadQueryFont(dpy, font);
    
#ifdef FONTDIRHACK

    /*
     * Set the font path to the current font path plus the 
     * XTrek library directory.  This is so people can run
     * XTrek without needing to install fonts in the system
     * font directory.
     */


    if ( xtrekfontinfo == NULL )
	{

#ifdef DEBUG
	fprintf(stderr, "Couldn't find xtrek font, using alternate path\n");
#endif /* DEBUG */

	/*
	 * Grab the server oh-so-briefly to prevent any nasty
	 * race conditions.  Probably not necessary, but better
	 * safe than sorry.
	 */
	XGrabServer(dpy);
	
	fontdirs = XGetFontPath(dpy, &npaths);
	newfontdirs = (char **)malloc(sizeof(char *) * npaths+1);
	if ( newfontdirs )
	    {
	    int i;
	    for(i = 0; i < npaths; i++)
		newfontdirs[i] = fontdirs[i];
	    newfontdirs[npaths] = FONTDIR;
	    XSetFontPath(dpy, newfontdirs, npaths+1);
	    }
	XUngrabServer(dpy);

	/* Try again */
	xtrekfontinfo = XLoadQueryFont(dpy, font);

	}
    
#endif FONTDIRHACK

    if ( xtrekfontinfo == NULL )
	{
	fprintf(stderr, "Couldn't load XTrek font\n");
	exit(1);
	}
    
    xtrekfont = xtrekfontinfo->fid;

}

redrawFed(fwin)
	Window fwin;
{
    char buf[BUFSIZ];

    XClearWindow(dpy, fwin);
    XText(fwin, 5, 5, "Federation", 10, dfont, shipCol[1], backColor);
    (void) sprintf(buf, "%d", numShips(FED));
    XTextMask(fwin, 5, 50, buf, strlen(buf), bigFont->fid, shipCol[1]);
}

redrawRom(rwin)
	Window rwin;
{
    char buf[BUFSIZ];

    XClearWindow(dpy, rwin);
    XText(rwin, 5, 5, "Romulan", 7, dfont, shipCol[2], backColor);
    (void) sprintf(buf, "%d", numShips(ROM));
    XTextMask(rwin, 5, 50, buf, strlen(buf), bigFont->fid, shipCol[1]);
}

redrawKli(kwin)
	Window kwin;
{
    char buf[BUFSIZ];

    XClearWindow(dpy, kwin);
    XText(kwin, 5, 5, "Klingon", 7, dfont, shipCol[3], backColor);
    (void) sprintf(buf, "%d", numShips(KLI));
    XTextMask(kwin, 5, 50, buf, strlen(buf), bigFont->fid, shipCol[1]);
}

redrawOri(owin)
	Window owin;
{
    char buf[BUFSIZ];

    XClearWindow(dpy, owin);
    XText(owin, 5, 5, "Orion", 5, dfont, shipCol[4], backColor);
    (void) sprintf(buf, "%d", numShips(ORI));
    XTextMask(owin, 5, 50, buf, strlen(buf), bigFont->fid, shipCol[1]);
}

redrawQuit(qwin)
	Window qwin;
{
    XText(qwin, 5, 5, "Quit xtrek", 10, dfont, textColor, backColor);
}

char *help_message[] = {
    "0-9 Set speed",
    "k   Set course",
    "p   Fire phaser",
    "t   Launch torp",
    "d   detonate other torps",
    "D   detonate your torps",
    "L   List players",
    "P   List planets",
    "S   (Un)Map status window",
    "M   Toggle map window updating",
    "+   Put up screens",
    "-   Put down screens",
    "u   Toggle screens",
    "i   Get info on player/planet",
    "b   Bomb planet",
    "z   Beam up armies",
    "x   Beam down armies",
    "R   Enter repair mode",
    "o   orbit planet",
    "Q   Quit",
    "?   Review messages",
    "c   Toggle cloak mode",
    "C   Coup a planet",
    "l   Lock on to player/planet",
    "@   (Dis)Allow copilots",
    "h   (Un)Map this window",
    "w   (Un)Map war window",
    "*   Send in practice robot",
    "&   Send in harder robot",
    0,
};

#define MAXHELP 32

fillhelp()
{
    register int i = 0, row, column;

    for (column = 0; column < 4; column++) {
	for (row = 1; row < 9; row++) {
	    if (help_message[i] == 0)
		break;
	    else {
		XText(helpWin, FONTWIDTH(dfontinfo) * (MAXHELP * column + 1),
		    FONTHEIGHT(dfontinfo) * row, help_message[i],
		    strlen(help_message[i]), dfont, textColor, backColor);
		i++;
	    }
	}
	if (help_message[i] == 0)
	    break;
    }
}

drawIcon()
{
}

static Window	clock;
static Pixmap   clockBitmap = 0;

#define CLOCK_WID	(BOXSIDE * 9 / 10)
#define CLOCK_HEI	(BOXSIDE * 2 / 3)
#define CLOCK_BDR	0
#define CLOCK_X		(BOXSIDE / 2 - CLOCK_WID / 2)
#define CLOCK_Y		(BOXSIDE / 2 - CLOCK_HEI / 2)

#include "clock.bitmap"

makeClock(w)
	Window	w;
{
	GC gc;
    	XImage *image;

	clock = X10CreateWindow(w, CLOCK_X, CLOCK_Y, CLOCK_WID, CLOCK_HEI,
		CLOCK_BDR, foreTile, backTile);
	XMapWindow(dpy, clock);

	if ( clockBitmap == 0 )
		{
		clockBitmap = XCreateBitmapFromData(dpy, root, clock_bits, clock_width, clock_height);
		return;
		}
}

destroyClock()
{
	XDestroyWindow(dpy, clock);
}

#define PI		3.141592654

showTimeLeft(time, max)
{
	char	buf[BUFSIZ], *cp;
	int	cx, cy, ex, ey, tx, ty;
	static GC gc = 0;
	static GC lgc = 0;

	XClearWindow(dpy, clock);

	if ( gc == 0 )
		{
		gc = XCreateGC(dpy, iconWin, 0, NULL);
		XSetForeground(dpy, gc, textColor);
		XSetBackground(dpy, gc, backColor);
		XSetStipple(dpy, gc, clockBitmap);
		XSetFillStyle(dpy, gc, FillOpaqueStippled);

		lgc = XCreateGC(dpy, iconWin, 0, NULL);
		XSetForeground(dpy, lgc, textColor);
		XSetBackground(dpy, lgc, backColor);
		}

	cx = CLOCK_WID / 2;
	cy = (CLOCK_HEI - FONTHEIGHT(dfontinfo)) / 2;
	ex = cx - clock_width / 2;
	ey = cy - clock_height / 2;

	XSetTSOrigin(dpy, gc, ex, ey);
	XFillRectangle(dpy, clock, gc, ex, ey, clock_width, clock_height);

	ex = cx - clock_width * sin(2 * PI * time / max) / 2;
	ey = cy - clock_height * cos(2 * PI * time / max) / 2;
	XDrawLine(dpy, clock, lgc, cx, cy, ex, ey);
	
	sprintf(buf, "%d", max - time);
	tx = cx - FONTWIDTH(dfontinfo) * strlen(buf) / 2;
	ty = cy - FONTHEIGHT(dfontinfo) / 2;
	XText(clock, tx, ty, buf, strlen(buf), dfont, textColor, backColor);

	cp = "Auto Quit";
	tx = cx - FONTWIDTH(dfontinfo) * strlen(cp) / 2;
	ty = CLOCK_HEI - FONTHEIGHT(dfontinfo);
	XText(clock, tx, ty, cp, strlen(cp), dfont, textColor, backColor);
}
