
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/orbit.c,v 3.1 88/09/20 00:44:30 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#include <math.h>
#ifndef ibm032
#include <sys/ipc.h>
#include <sys/shm.h>
#endif ibm032
#include "defs.h"
#include "struct.h"
#include "data.h"

/* orbit a planet */

orbit()
{
    register int i;
    register struct planet *l;
    unsigned char dir;
    int dx, dy;

    if (me->p_speed > ORBSPEED) {
	warning("Speed must be less than two to orbit");
	return;
    }
    for (i = 0, l = &planets[i]; i < MAXPLANETS; i++, l++) {
	dx = ABS(l->pl_x - me->p_x);
	dy = ABS(l->pl_y - me->p_y);
	if (dx > ENTORBDIST || dy > ENTORBDIST)		/*XXX*/
	    continue;
	if (dx * dx + dy * dy > ENTORBDIST * ENTORBDIST)
	    continue;

#ifdef SYSATAN2
	dir = (unsigned char) (atan2((double) (me->p_x - l->pl_x),
	    (double) (l->pl_y - me->p_y))
	    / 3.14159 * 128.);
#else
	dir = myatan2( me->p_x - l->pl_x, l->pl_y - me->p_y );
#endif
	l->pl_info |= me->p_team;
	me->p_dir = dir + 64;
	me->p_flags |= PFORBIT;
	me->p_x = l->pl_x + ORBDIST * Cos[dir];
	me->p_y = l->pl_y + ORBDIST * Sin[dir];
	me->p_speed = me->p_desspeed = 0;
	me->p_planet = l->pl_no;
	return;
    }
    warning("Not close enough to any planet to orbit");
}
