/*
** Copyright 1988 Silicon Graphics Inc.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of SGI not be used in advertising
** or publicity pertaining to distribution of the software without specific,
** written prior permission.  SGI makes no representations about the
** suitability of this software for any purpose.  It is provided "as is"
** without express or implied warranty.
**
** SGI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SGI
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
** OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
** CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael Toy, SGI
*/

#include "X.h"
#include "Xproto.h"
#include "input.h"
#include "scrnintstr.h"
#include "sgifb.h"

#include <fcntl.h>

struct KbPrivate KbPrivate = { 0, -1, 0, 0 };
struct MsPrivate MsPrivate = { -1 };
extern int debug_menu;

extern CARD8 *sgiModMap[];
extern KeySymsRec sgiKeySyms[];

/*
 * Alter some of the keyboard control parameters
 */
static void
sgiKeybdCtrl (pKeyboard, ctrl)
    DevicePtr	pKeyboard;	    /* Keyboard to alter */
    KeybdCtrl	*ctrl;
{
    /* none for now */
}

/*
 * Ring the keyboard bell
 */
void
sgiBell (loudness, pKeyboard)
    int	    	  loudness;	    /* Percentage of full volume */
    DevicePtr	  pKeyboard;	    /* Keyboard to ring */
{
    struct KbPrivate *pPriv = (struct KbPrivate *)pKeyboard->devicePrivate;

    if (loudness != pPriv->bellVolume) {
	pPriv->bellVolume = loudness;
	if (loudness <= 0)
	    setbell(0);
	else if (loudness > 50)
	    setbell(2);
	else 
	    setbell(1);
    }
    ringbell();
}


int
sgiKeybdProc (pKeyboard, what)
    DevicePtr	  pKeyboard;	/* Keyboard to manipulate */
    int	    	  what;	    	/* What to do to it */
{
    switch (what) {
	case DEVICE_INIT: {
	    CARD8	modMap[MAP_LENGTH];

	    if (pKeyboard != LookupKeyboardDevice()) {
		ErrorF ("Cannot open non-system keyboard");
		return (!Success);
	    }
	    if (KbPrivate.fd < 0) {
		KbPrivate.fd = open("/dev/queue", O_RDONLY);
		if (KbPrivate.fd < 0) {
		    ErrorF ("Cannot open keyboard: ");
		    perror("");
		    return (!Success);
		}
		MsPrivate.fd = KbPrivate.fd;
	        KbPrivate.type = KB_SGI4D;
		debug_menu = defpup("X11 Sever%t|Pop|Push|Quit");
	    }

	    /*
	     * Perform final initialization of the system private keyboard
	     * structure and fill in various slots in the device record.
	     */
	    pKeyboard->devicePrivate = (pointer)&KbPrivate;
	    pKeyboard->on = FALSE;
	    /*
	    ** Assure we don't go below MIN_KEYCODE
	    */
	    if (sgiKeySyms[KbPrivate.type].minKeyCode < MIN_KEYCODE) {
		int offset = MIN_KEYCODE - sgiKeySyms[KbPrivate.type].minKeyCode;
		sgiKeySyms[KbPrivate.type].minKeyCode += offset;
		sgiKeySyms[KbPrivate.type].maxKeyCode += offset;
		KbPrivate.offset = offset;
	    }
	    sgiMakeModMap(KbPrivate.type, modMap, KbPrivate.offset);

	    InitKeyboardDeviceStruct(
		    pKeyboard,
		    &(sgiKeySyms[KbPrivate.type]),
		    modMap,
		    sgiBell,
		    sgiKeybdCtrl);
	    break;
	}
	case DEVICE_ON:
	    AddEnabledDevice(KbPrivate.fd);
	    pKeyboard->on = TRUE;
	    break;

	case DEVICE_CLOSE:
	case DEVICE_OFF:
	    RemoveEnabledDevice(KbPrivate.fd);
	    pKeyboard->on = FALSE;
	    break;
    }
    return (Success);
}

Bool
LegalModifier(key)
{
    return TRUE;
}
