/****************************************************************************/
/* key.c  --	X-WINDOWS KEYBOARD INPUT ROUTINES FOR THE IBM PC	    */
/****************************************************************************/
/****************************************************************************/
#include "key.h"
/****************************************************************************/
/****************************************************************************/
/* KEYCODE DEFINTIONS (for IBM PC)					    */
/****************************************************************************/
#include "keysym.h"
#include "inpevent.h"

#define	XK_undef	(XK_space)

XKEYCODE	PC2X_low[32]= {
/* 0x0000 */	XK_undef,
/* 0x0001 */	XK_undef,
/* 0x0002 */	XK_undef,
/* 0x0003 */	XK_undef,
/* 0x0004 */	XK_undef,
/* 0x0005 */	XK_undef,
/* 0x0006 */	XK_undef,
/* 0x0007 */	XK_undef,
/* 0x0008 */	XK_BackSpace,
/* 0x0009 */	XK_Tab,
/* 0x000a */	XK_Linefeed,
/* 0x000b */	XK_Clear,
/* 0x000c */	XK_undef,
/* 0x000d */	XK_Return,
/* 0x000e */	XK_undef,
/* 0x000f */	XK_undef,
/* 0x0010 */	XK_undef,
/* 0x0011 */	XK_undef,
/* 0x0012 */	XK_undef,
/* 0x0013 */	XK_undef,
/* 0x0014 */	XK_undef,
/* 0x0015 */	XK_undef,
/* 0x0016 */	XK_undef,
/* 0x0017 */	XK_undef,
/* 0x0018 */	XK_undef,
/* 0x0019 */	XK_undef,
/* 0x001a */	XK_undef,
/* 0x001b */	XK_Escape,
/* 0x001c */	XK_undef,
/* 0x001d */	XK_undef,
/* 0x001e */	XK_undef,
/* 0x001f */	XK_undef
};


XKEYCODE	PC2X_high[129]= {
/* 0x007F */	XK_undef,
/* 0x0080 */	XK_undef,
/* 0x0081 */	XK_undef,
/* 0x0082 */	XK_undef,
/* 0x0083 */	XK_undef,
/* 0x0084 */	XK_undef,
/* 0x0085 */	XK_undef,
/* 0x0086 */	XK_undef,
/* 0x0087 */	XK_undef,
/* 0x0088 */	XK_undef,
/* 0x0089 */	XK_undef,
/* 0x008a */	XK_undef,
/* 0x008b */	XK_undef,
/* 0x008c */	XK_undef,
/* 0x008d */	XK_undef,
/* 0x008e */	XK_undef,
/* 0x008f */	XK_undef,
/* 0x0090 */	XK_undef,
/* 0x0091 */	XK_ae,
/* 0x0092 */	XK_AE,
/* 0x0093 */	XK_undef,
/* 0x0094 */	XK_undef,
/* 0x0095 */	XK_undef,
/* 0x0096 */	XK_undef,
/* 0x0097 */	XK_undef,
/* 0x0098 */	XK_undef,
/* 0x0099 */	XK_undef,
/* 0x009a */	XK_undef,
/* 0x009b */	XK_cent,
/* 0x009c */	XK_undef,
/* 0x009d */	XK_undef,
/* 0x009e */	XK_paragraph,
/* 0x009f */	XK_undef,
/* 0x00a0 */	XK_undef,
/* 0x00a1 */	XK_undef,
/* 0x00a2 */	XK_undef,
/* 0x00a3 */	XK_undef,
/* 0x00a4 */	XK_undef,
/* 0x00a5 */	XK_undef,
/* 0x00a6 */	XK_undef,
/* 0x00a7 */	XK_undef,
/* 0x00a8 */	XK_questiondown,
/* 0x00a9 */	XK_undef,
/* 0x00aa */	XK_undef,
/* 0x00ab */	XK_onehalf,
/* 0x00ac */	XK_onequarter,
/* 0x00ad */	XK_undef,
/* 0x00ae */	XK_undef,
/* 0x00af */	XK_undef,
/* 0x00b0 */	XK_undef,
/* 0x00b1 */	XK_undef,
/* 0x00b2 */	XK_undef,
/* 0x00b3 */	XK_undef,
/* 0x00b4 */	XK_undef,
/* 0x00b5 */	XK_undef,
/* 0x00b6 */	XK_undef,
/* 0x00b7 */	XK_undef,
/* 0x00b8 */	XK_undef,
/* 0x00b9 */	XK_undef,
/* 0x00ba */	XK_undef,
/* 0x00bb */	XK_undef,
/* 0x00bc */	XK_undef,
/* 0x00bd */	XK_undef,
/* 0x00be */	XK_undef,
/* 0x00bf */	XK_undef,
/* 0x00c0 */	XK_undef,
/* 0x00c1 */	XK_undef,
/* 0x00c2 */	XK_undef,
/* 0x00c3 */	XK_undef,
/* 0x00c4 */	XK_undef,
/* 0x00c5 */	XK_undef,
/* 0x00c6 */	XK_undef,
/* 0x00c7 */	XK_undef,
/* 0x00c8 */	XK_undef,
/* 0x00c9 */	XK_undef,
/* 0x00ca */	XK_undef,
/* 0x00cb */	XK_undef,
/* 0x00cc */	XK_undef,
/* 0x00cd */	XK_undef,
/* 0x00ce */	XK_undef,
/* 0x00cf */	XK_undef,
/* 0x00d0 */	XK_undef,
/* 0x00d1 */	XK_undef,
/* 0x00d2 */	XK_undef,
/* 0x00d3 */	XK_undef,
/* 0x00d4 */	XK_undef,
/* 0x00d5 */	XK_undef,
/* 0x00d6 */	XK_undef,
/* 0x00d7 */	XK_undef,
/* 0x00d8 */	XK_undef,
/* 0x00d9 */	XK_undef,
/* 0x00da */	XK_undef,
/* 0x00db */	XK_undef,
/* 0x00dc */	XK_undef,
/* 0x00dd */	XK_undef,
/* 0x00de */	XK_undef,
/* 0x00df */	XK_undef,
/* 0x00e0 */	XK_undef,
/* 0x00e1 */	XK_undef,
/* 0x00e2 */	XK_undef,
/* 0x00e3 */	XK_undef,
/* 0x00e4 */	XK_undef,
/* 0x00e5 */	XK_undef,
/* 0x00e6 */	XK_undef,
/* 0x00e7 */	XK_undef,
/* 0x00e8 */	XK_undef,
/* 0x00e9 */	XK_undef,
/* 0x00ea */	XK_undef,
/* 0x00eb */	XK_undef,
/* 0x00ec */	XK_undef,
/* 0x00ed */	XK_undef,
/* 0x00ee */	XK_undef,
/* 0x00ef */	XK_undef,
/* 0x00f0 */	XK_undef,
/* 0x00f1 */	XK_plusminus,
/* 0x00f2 */	XK_undef,
/* 0x00f3 */	XK_undef,
/* 0x00f4 */	XK_undef,
/* 0x00f5 */	XK_undef,
/* 0x00f6 */	XK_undef,
/* 0x00f7 */	XK_undef,
/* 0x00f8 */	XK_undef,
/* 0x00f9 */	XK_undef,
/* 0x00fa */	XK_periodcentered,
/* 0x00fb */	XK_undef,
/* 0x00fc */	XK_undef,
/* 0x00fd */	XK_undef,
/* 0x00fe */	XK_undef,
/* 0x00ff */	XK_undef
};

XKEYCODE	PC2X_ext[133]= {
/* 000 */	XK_undef,
/* 001 */	XK_undef,
/* 002 */	XK_undef,
/* 003 */	XK_undef, /*null */
/* 004 */	XK_undef,
/* 005 */	XK_undef,
/* 006 */	XK_undef,
/* 007 */	XK_undef,
/* 008 */	XK_undef,
/* 009 */	XK_undef,
/* 010 */	XK_undef,
/* 011 */	XK_undef,
/* 012 */	XK_undef,
/* 013 */	XK_undef,
/* 014 */	XK_undef,
/* 015 */	XK_Tab,	/* shift-tab */
/* 016 */	XK_Q,	/* alt-q */
/* 017 */	XK_W,	/* alt-w */
/* 018 */	XK_E,	/* alt-e */
/* 019 */	XK_R,	/* alt-r */
/* 020 */	XK_T,	/* alt-t */
/* 021 */	XK_Y,	/* alt-y */
/* 022 */	XK_U,	/* alt-u */
/* 023 */	XK_I,	/* alt-i */
/* 024 */	XK_O,	/* alt-o */
/* 025 */	XK_P,	/* alt-p */
/* 026 */	XK_undef,
/* 027 */	XK_undef,
/* 028 */	XK_undef,
/* 029 */	XK_undef,
/* 030 */	XK_A,	/* alt-a */
/* 031 */	XK_S,	/* alt-s */
/* 032 */	XK_D,	/* alt-d */
/* 033 */	XK_F,	/* alt-f */
/* 034 */	XK_G,	/* alt-g */
/* 035 */	XK_H,	/* alt-h */
/* 036 */	XK_J,	/* alt-j */
/* 037 */	XK_K,	/* alt-k */
/* 038 */	XK_L,	/* alt-l */
/* 039 */	XK_undef,
/* 040 */	XK_undef,
/* 041 */	XK_undef,
/* 042 */	XK_undef,
/* 043 */	XK_undef,
/* 044 */	XK_Z,	/* alt-z */
/* 045 */	XK_X,	/* alt-x */
/* 046 */	XK_C,	/* alt-c */
/* 047 */	XK_V,	/* alt-v */
/* 048 */	XK_B,	/* alt-b */
/* 049 */	XK_N,	/* alt-n */
/* 050 */	XK_M,	/* alt-m */
/* 051 */	XK_undef,
/* 052 */	XK_undef,
/* 053 */	XK_undef,
/* 054 */	XK_undef,
/* 055 */	XK_undef,
/* 056 */	XK_undef,
/* 057 */	XK_undef,
/* 058 */	XK_undef,
/* 059 */	XK_F1,
/* 060 */	XK_F2,
/* 061 */	XK_F3,
/* 062 */	XK_F4,
/* 063 */	XK_F5,
/* 064 */	XK_F6,
/* 065 */	XK_F7,
/* 066 */	XK_F8,
/* 067 */	XK_F9,
/* 068 */	XK_F10,
/* 069 */	XK_undef,
/* 070 */	XK_undef,
/* 071 */	XK_Home,
/* 072 */	XK_Up,
/* 073 */	XK_undef,	/* page up */
/* 074 */	XK_undef,
/* 075 */	XK_Left,
/* 076 */	XK_undef,
/* 077 */	XK_Right,
/* 078 */	XK_undef,
/* 079 */	XK_End,
/* 080 */	XK_Down,
/* 081 */	XK_undef,	/* page down */
/* 082 */	XK_Insert,	/* ins */
/* 083 */	XK_Delete,	/* del */
/* 084 */	XK_F1,	/* shift-F1 */
/* 085 */	XK_F2,	/* shift-F2 */
/* 086 */	XK_F3,	/* shift-F3 */
/* 087 */	XK_F4,	/* shift-F4 */
/* 088 */	XK_F5,	/* shift-F5 */
/* 089 */	XK_F6,	/* shift-F6 */
/* 090 */	XK_F7,	/* shift-F7 */
/* 091 */	XK_F8,	/* shift-F8 */
/* 092 */	XK_F9,	/* shift-F9 */
/* 093 */	XK_F10,	/* shift-F10 */
/* 094 */	XK_F1,	/* ctrl-F1 */
/* 095 */	XK_F2,	/* ctrl-F2 */
/* 096 */	XK_F3,	/* ctrl-F3 */
/* 097 */	XK_F4,	/* ctrl-F4 */
/* 098 */	XK_F5,	/* ctrl-F5 */
/* 099 */	XK_F6,	/* ctrl-F6 */
/* 100 */	XK_F7,	/* ctrl-F7 */
/* 101 */	XK_F8,	/* ctrl-F8 */
/* 102 */	XK_F9,	/* ctrl-F9 */
/* 103 */	XK_F10,	/* ctrl-F10 */
/* 104 */	XK_F1,	/* alt-F1 */
/* 105 */	XK_F2,	/* alt-F2 */
/* 106 */	XK_F3,	/* alt-F3 */
/* 107 */	XK_F4,	/* alt-F4 */
/* 108 */	XK_F5,	/* alt-F5 */
/* 109 */	XK_F6,	/* alt-F6 */
/* 110 */	XK_F7,	/* alt-F7 */
/* 111 */	XK_F8,	/* alt-F8 */
/* 112 */	XK_F9,	/* alt-F9 */
/* 113 */	XK_F10,	/* alt-F10 */
/* 114 */	XK_undef,	/* ctrl-PrtSc */
/* 115 */	XK_Left,	/* ctrl-left */
/* 116 */	XK_Right,	/* ctrl-right */
/* 117 */	XK_End,		/* ctrl-end */
/* 118 */	XK_undef,	/* ctrl-pgup */
/* 119 */	XK_Home,	/* ctrl-home */
/* 120 */	XK_1,	/* alt-1 */
/* 121 */	XK_2,	/* alt-2 */
/* 122 */	XK_3,	/* alt-3 */
/* 123 */	XK_4,	/* alt-4 */
/* 124 */	XK_5,	/* alt-5 */
/* 125 */	XK_6,	/* alt-6 */
/* 126 */	XK_7,	/* alt-7 */
/* 127 */	XK_8,	/* alt-8 */
/* 128 */	XK_9,	/* alt-9 */
/* 129 */	XK_0,	/* alt-0 */
/* 130 */	XK_minus,	/* alt-- */
/* 131 */	XK_equal,	/* alt-= */
/* 132 */	XK_undef	/* ctrl-pgup */
};
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
#include "Xproto.h"  /* GET BOOL TYPEDEF FOR queue.h AND bios.h */
#include "queue.h"
/*#include "timetick.h"*/

extern	QUEUEID	queue;	/* GLOBAL QUEUE OF ALL INPUT EVENTS (MOUSE & KEYBOARD) */

Bool	key_add(XKEYCODE xkeycode, Bool pressed) {
	INPEVENT	inpevent;
	inpevent.type=	(pressed)?(KeyPress):(KeyRelease);
	inpevent.input.xkeycode=	xkeycode;
/*	inpevent.timetick=	timetick();*/
	return(queue_add(queue,&inpevent));
}
/****************************************************************************/
/****************************************************************************/

void	key_flash(XKEYCODE xkk) {
	key_add(xkk,TRUE);
	key_add(xkk,FALSE);
}
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
#include "bios.h"

#define HARDWARE_KEY_INT	(0x9)
void	interrupt (*hardware_key_int)()=	0;


static	BIOSKEY_SHIFTSTATE	old;	/* REMEMBER THE LAST KEYSTATE */

void interrupt	key_catch()
{
	BIOSKEY_SHIFTSTATE		new;

	/* PROCESS THE INTERRUPT NORMALLY */
	hardware_key_int();

	/* NOW SEE WHAT HAPPENDED... */

	/* DID THE SHIFT KEY STATE CHANGE? */
	new= bioskey_shiftstate();
	if (old.rightshift	!=	new.rightshift)
		key_add(XK_Shift_R,new.rightshift);
	if (old.leftshift	!=	new.leftshift)
		key_add(XK_Shift_L,new.leftshift);
	if (old.ctrl		!=	new.ctrl)
		key_add(XK_Control_L,new.ctrl);
	if (old.alt		!=	new.alt)
		key_add(XK_Alt_L,new.alt);

	if (old.scrolllock	!=	new.scrolllock)
		key_flash(XK_Pause);
	if (old.numlock		!=	new.numlock)
		key_flash(XK_Hyper_L);
	if (old.caps		!=	new.caps)
		key_flash(XK_Caps_Lock);
	if (old.insert		!=	new.insert)
		key_flash(XK_Insert);
        old=	new;


	/* DID A KEY ARRIVE? */
	while (bioskey(BIOSKEY_KEYWAITING)) {
		XKEYCODE key=	bioskey(BIOSKEY_GETKEYCODE);
		unsigned char	ascii=	key & 0x00FF;
		if (ascii) {
			if (ascii <' ')
				key=	PC2X_low[ascii];
			else if (ascii>'~')
				key=	PC2X_high[ascii-'~'-1];
			else	key=	ascii;
		} else
			key=	PC2X_ext[key >> 8];
		key_flash(key);
	}
}
/****************************************************************************/
/****************************************************************************/
/* Def. of Porting Layer: Controlling Input Devices (5.1.4) */
/****************************************************************************/
#include <stdio.h>
void	key_bell(int loud, DevicePtr pDevice) {
	putch(7);
}
/****************************************************************************/
void	key_controlproc(DevicePtr device, KeybdCtrl *ctrl) {
	return;
}
/****************************************************************************/
/****************************************************************************/
/* extern	void InitKeyboardDeviceStruct(DevicePtr device, BYTE *map, int mapLength, void (*Bell)(), void (*ControlProc)()); */
#include <mp\dos.h>

Bool	key_deviceproc(DevicePtr device, int action) {
	switch(action) {
		case(DEVICE_INIT):
			InitKeyboardDeviceStruct(device,(char *)0 /*map?*/,0 /*mapLength?*/,key_bell,key_controlproc);
			break;
		case(DEVICE_ON):
			if (key_initialized())	break;	/* DO NOTHING IF ALREADY INTIALIZED */
			/* REDIRECT HARDWARE KEYBOARD INTERRUPT */
			old=	bioskey_shiftstate();	/* SAVE CURRENT SHIFT STATE (FOR FUTURE COMPARISON) */
			hardware_key_int=	getvect(HARDWARE_KEY_INT);
			setvect(HARDWARE_KEY_INT,key_catch);
			break;
		case(DEVICE_OFF):
			if (!key_initialized())	break;	/* IF NOT INITIALIZED, DO NOTHING */
			/* RESTORE HARDWARE KEYBOARD INTERRUPT */
			setvect(HARDWARE_KEY_INT,hardware_key_int);	/* RESTORE THE HARDWARE INTERRUPT */
			hardware_key_int=	0;
			break;
		case(DEVICE_CLOSE):
			break;
		default:
			/* UNRECOGNIZED action IN mouse_deviceproc() */
#include "assert.h"
			assert(0);
	}
	return(TRUE);
}
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
