/****************************************************************************/
/* ptr_inp.c  -X-WINDOWS (MICROSOFT) MOUSE INPUT ROUTINES FOR THE IBM PC   */
/****************************************************************************/
/****************************************************************************/
#include "ptr_inp.h"
/****************************************************************************/
/****************************************************************************/
#include "inpevent.h"
#include "Xproto.h"	/* GET xTimecoord TYPEDEF, BOOL TYPEDEF for queue.h */
#include "queue.h"
/*#include "timetick.h"*/
/****************************************************************************/
/****************************************************************************/
/* GLOBAL QUEUE OF ALL INPUT EVENTS (MOUSE & KEYBOARD) */
extern	QUEUEID	queue;
/****************************************************************************/
Bool	ptr_inp_addbutton(KEYCODE buttonno, Bool pressed) {
	INPEVENT	inpevent;
	inpevent.type=	(pressed)?(ButtonPress):(ButtonRelease);
	inpevent.input.xkeycode=	buttonno;
/*	inpevent.timetick=	timetick();*/
	return(queue_add(queue,&inpevent));
}
/****************************************************************************/
Bool	ptr_inp_addmotion(COORD coord) {
	INPEVENT	inpevent;
	inpevent.type=	MotionNotify;
	inpevent.input.coord=	coord;
/*	inpevent.timetick=	timetick();*/
	return(queue_add(queue,&inpevent));
}
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
#include "msmouse.h"
#define	MOUSE_LBUTTON	(1)
#define	MOUSE_RBUTTON	(2)

void near ptr_inp_catch(void)
{
	unsigned	AX=	_AX;
	COORD		coord;
	coord.x=	_CX;
	coord.y=	_DX;

	if (AX & MSMOUSE_SETINT_MASK_LBUTTONPRESS)
		ptr_inp_addbutton(MOUSE_LBUTTON,TRUE);
	if (AX & MSMOUSE_SETINT_MASK_LBUTTONRELEASE)
		ptr_inp_addbutton(MOUSE_LBUTTON,FALSE);
	if (AX & MSMOUSE_SETINT_MASK_RBUTTONPRESS)
		ptr_inp_addbutton(MOUSE_RBUTTON,TRUE);
	if (AX & MSMOUSE_SETINT_MASK_RBUTTONRELEASE)
		ptr_inp_addbutton(MOUSE_RBUTTON,FALSE);

	if (AX & MSMOUSE_SETINT_MASK_MOVEMENT)
		ptr_inp_addmotion(coord);
}
/****************************************************************************/
/****************************************************************************/
/* Def. of Porting Layer: Controlling Input Devices (5.1.4) */
/****************************************************************************/
int	ptr_inp_getmotionevents(DevicePtr device, xTimecoord *buff, CARD32 start, CARD32 stop) {
	return(0);
}
/****************************************************************************/
void	ptr_inp_controlproc(DevicePtr device, PtrCtrl *ctrl) {
	return;
}
/****************************************************************************/
/****************************************************************************/
Bool	ptr_inp_inited=	FALSE;
/****************************************************************************/
/* extern	InitPointerDeviceStruct(DevicePtr device, BYTE *map, int mapLength, int (*GetMotionEvents)(), int (*ControlProc)()); */

Bool	ptr_inp_deviceproc(DevicePtr device, int action) {
	switch(action) {
		case(DEVICE_INIT):
			InitPointerDeviceStruct(device, (char *)0 /*map?*/,0/*mapLength?*/,ptr_inp_getmotionevents,ptr_inp_controlproc);
			break;
		case(DEVICE_ON): {
			MSMOUSE	msm;
			if (ptr_inp_initialized())	break;
			ptr_inp_initialized()=		TRUE;

			/* RESET THE MOUSE */
			msm.func=	MSMOUSE_INSTALLEDANDRESET;
			msmouse(&msm);
			if (!msm.func)	return(FALSE);

			/* TURN THE CURSOR ON */
			msm.func=	MSMOUSE_SHOWCURSOR;
			msmouse(&msm);

			/* SET MOUSE STATUS-CHANGE HANDLING ROUTINE */
			msm.func=	MSMOUSE_SETINT;
			msm.arg3=	MSMOUSE_SETINT_MASK_ALL;
			msm.arg4=	(short)ptr_inp_catch;
			msmouse(&msm);
			break;
		}
		case(DEVICE_OFF): {
			MSMOUSE	msm;
			if (!ptr_inp_initialized())	break;
			ptr_inp_initialized()=		FALSE;
			msm.func=	MSMOUSE_INSTALLEDANDRESET;
			msmouse(&msm);
			break;
		}
		case(DEVICE_CLOSE):
			break;
		default:
			/* UNRECOGNIZED action IN ptr_inp_deviceproc()! */
#include "assert.h"
			assert(0);
	}
	return(TRUE);
}
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
