/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $Header: utils.c,v 1.26 87/07/16 14:11:13 toddb Exp $ */
#include <stdio.h>
#include <time.h>      /* changed from sys/time.h */ 
#include "misc.h"
#include "X.h"
#include "input.h"
#include "opaque.h"
#include <string.h>
#include <stdlib.h>    /* added */
#include <malloc.h>    /* added */

extern char *display;

Bool clientsDoomed = FALSE;
extern void KillServerResources();

/* Force connections to close on SIGHUP from init */

AutoResetServer ()
{
    clientsDoomed = TRUE;
#ifdef GPROF
    chdir ("/temp");
    exit (0);
#endif
}

/* Force connections to close and then exit on SIGTERM, SIGINT */

GiveUp()
{
    KillServerResources();
    exit(0);
}


void
ErrorF( f, s0, s1, s2, s3, s4, s5, s6, s7, s8, s9) /* limit of ten args */
    char *	f;
    char *s0, *s1, *s2, *s3, *s4, *s5, *s6, *s7, *s8, *s9;
{
    fprintf( stderr, f, s0, s1, s2, s3, s4, s5, s6, s7, s8, s9);
}

int
Error(str)
    char *str;
{
    perror(str);
}

int
Notice()
{
}

int
GetTimeInMillis()
{
/*  struct timeval  tp;
    gettimeofday(&tp, 0);
    return(tp.tv_sec * 1000) + (tp.tv_usec / 1000);
*/
    long *timeptr;

    time (timeptr);
    printf ("Current time is %s \n", ctime(timeptr)); 
}

/*
 * This function parses the command line. Handles device-independent fields
 * only.  It is not allowed to modify argc or any of the strings pointed to
 * by argv.
 */
ProcessCommandLine ( argc, argv )
int	argc;
char	*argv[];

{
    int i;

    for ( i = 1; i < argc; i++ )
    {
	/* initialize display */
	if(argv[i][0] ==  ':')  
	{
	    display = argv[i];
	    display++;
	}
	else if ( strcmp( argv[i], "-a") == 0)
	{
	    if(++i < argc)
	        defaultPointerControl.num = atoi(argv[i]);
	    else
		UseMsg();
	}
	else if ( strcmp( argv[i], "c") == 0)
	{
	    if(++i < argc)
	        defaultKeyboardControl.click = atoi(argv[i]);
	    else
		UseMsg();
	}
	else if ( strcmp( argv[i], "-c") == 0)
	{
	    defaultKeyboardControl.click = 0;
	}
	else if ( strcmp( argv[i], "-f") == 0)
	{
	    if(++i < argc)
	        defaultKeyboardControl.bell = atoi(argv[i]);
	    else
		UseMsg();
	}
	else if ( strcmp( argv[i], "-fc") == 0)
	{
	    if(++i < argc)
	        defaultCursorFont = argv[i];
	    else
		UseMsg();
	}
	else if ( strcmp( argv[i], "-fn") == 0)
	{
	    if(++i < argc)
	        defaultTextFont = argv[i];
	    else
		UseMsg();
	}
	else if ( strcmp( argv[i], "-fp") == 0)
	{
	    if(++i < argc)
	        defaultFontPath = argv[i];
	    else
		UseMsg();
	}
	else if ( strcmp( argv[i], "-t") == 0)
	{
	    if(++i < argc)
	        defaultPointerControl.threshold = atoi(argv[i]);
	    else
		UseMsg();
	}
	else if ( strcmp( argv[i], "-s") == 0)
	{
	    if(++i < argc)
	        ;
	    else
		UseMsg();
	  	}
	else
	    UseMsg();
    }
}

UseMsg()
{
    ErrorF("use: X <display> [option] <tty>\n");
    ErrorF("options -a #, c #, -c, -f #, -fc <CursorFont>, -fn <TextFont>,\n");
    ErrorF("\t-fp <FontPath>, -t #, -s #\n");
}
/*
 * malloc wrap-around, to take care of the "no memory" case, since
 * it would be difficult in many places to "back out" on failure.
 */
#ifdef DEBUG
#define FIRSTMAGIC 0x11aaaa11
#define SECONDMAGIC 0x22aaaa22
#define FREEDMAGIC  0x33aaaa33
#endif

#ifndef ibm032
unsigned long * 
Xalloc (amount)
    int amount;
{
    char		*malloc();
    register pointer	ptr;
	
    if(amount == 0)
	return( (unsigned long *)NULL);
#ifdef DEBUG
        /* aligned extra on long word boundary */
    amount = (amount + 3) & ~3;  
    if (ptr = (pointer) malloc( ((unsigned) amount) + 12))
    {
        *(long *)ptr = FIRSTMAGIC;
        *((long *)(ptr + 4)) = amount;
        *((long *)(ptr + 8 + amount)) = SECONDMAGIC;
	return (ptr + 8);
    }
    FatalError("Error in Xalloc\n");
    /* NOTREACHED */
#else
    ptr = (pointer) malloc( ((unsigned) amount));
    return ((unsigned long *)ptr);
#endif /* DEBUG */
    /* NOTREACHED */
}

/*****************
 * Xrealloc
 *     realloc wrap-around, to take care of the "no memory" case, since
 *     it would be difficult in many places to "back out" on failure.
 *****************/

extern unsigned char *minfree;           /* DEBUG */

unsigned long *
Xrealloc (ptr, amount)
register pointer	ptr;
int amount;
{
    char *malloc();
    char *realloc();
    char *foo;

    if (ptr)
    {
        if (ptr < minfree)
        {
	    ErrorF("Xrealloc: trying to free static storage\n");
	    /* Force a core dump */
	    abort();
	}
#ifdef DEBUG
	CheckNode(ptr - 8);
	ptr = (pointer) realloc ((ptr - 8), (unsigned) amount + 12);
#else
        ptr = (pointer) realloc (ptr, amount);
#endif /* DEBUG */
    }
    else
    {
#ifdef DEBUG
	ptr = (pointer) malloc (((unsigned) amount) + 12);
#else
	ptr = (pointer) malloc ((unsigned) amount);
#endif 
    }
#ifdef DEBUG
    if (ptr)
    {
        *(long *)ptr = FIRSTMAGIC;
	*((long *)(ptr + 4)) = amount;
	*((long *)(ptr + 8 + amount)) = SECONDMAGIC;
	return ((ptr + 8));
    }
    FatalError ("Error in Xrealloc\n");
    /*NOTREACHED*/
#else
        return((unsigned long *)ptr);
#endif /* DEBUG */
}
                    
/*****************
 *  Xfree
 *    calls free 
 *****************/    

void
Xfree(ptr)
    register pointer ptr;
{
    if (ptr == (pointer) NULL)
	return;
#ifdef DEBUG
    CheckNode(ptr - 8);
    if (ptr < minfree)
	FatalError("Xfree: trying to free static storage\n");
    *(long *)(ptr - 8) = FREEDMAGIC;
    free(ptr - 8); 
#else
    if (ptr < minfree)
	FatalError("Xfree: trying to free static storage\n");
    free(ptr); 
#endif /* DEBUG */
}

#ifdef DEBUG
CheckNode(ptr)
    pointer ptr;
{
    int    amount;

    amount = *((long *)(ptr + 4));
    if (*((long *) ptr) == FREEDMAGIC)
        FatalError("Freeing something already freed!\n");
    if( *((long *) ptr) != FIRSTMAGIC ||
        *((long *) (ptr + amount + 8)) != SECONDMAGIC)
	FatalError("Heap bug!\n");
}
#endif /* DEBUG */
#endif /* ibm032 */
