/*
 * Dclock.c -- a digital clock widget.
 * Author: Dan Heller <island!argv@sun.com>
 */
#ifndef _XtDclock_h
#define _XtDclock_h

/* Parameters:

 Name                Class              RepType         Default Value
 ----                -----              -------         -------------
 background          Background         pixel           White
 bell		     Boolean		Boolean		False
 border              BorderColor        pixel           Black      
 borderWidth         BorderWidth        int             1
 date		     String		String		NULL
 destroyCallback     Callback           Pointer         NULL
 foreground          Foreground         Pixel           Black 
 height              Height             int             80
 mappedWhenManaged   MappedWhenManaged  Boolean         True
 reverseVideo        ReverseVideo       Boolean         False
 seconds	     Boolean		Boolean		False
 scroll		     Boolean		Boolean		True
 x                   Position           int             0 
 y                   Position           int             0

*/

#define XtNseconds	"seconds"
#define XtNbell		"bell"
#define XtNscroll	"scroll"
#define XtNdate		"date"

typedef struct _DclockRec *DclockWidget;
typedef struct _DclockClassRec *DclockWidgetClass;

extern WidgetClass dclockWidgetClass;

#endif _XtDclock_h
