#ifndef lint
static char *rcsid[] = "$Header: window.c,v 0.5 88/08/10 15:03:14 $";
#endif  lint
/************************************************************************
 *									*
 *	<< window.c - xwindow   main program >>				*
 *									*
 *						Sony Corporation	*
 *						Wed Aug 10 1988		*
 *									*
 ************************************************************************/
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Cascade.h>
#include <X11/Xatom.h>
#include <X11/Shell.h>
#include <X11/Clock.h>
#include <X11/SStringDefs.h>
#include <X11/SWindow.h>
#include <X11/SMenu.h>
#include <X11/SBitmap.h>
#include <X11/SPDMenu.h>
#include <X11/SScreen.h>
#include <X11/SScroll.h>

extern	void	exit();
static	void	callback_close();
static	void	callback_resize();
static	void	callback_hscroll();
static	void	callback_vscroll();
static	void	callback_scroll();
static	void	callback_move();
static	void	callback_raise();
static	void	callback_selclr();
void	tool_proc();
void	file_proc();
void	edit_proc();

#ifdef KANJI
static	XFontStruct *font;
static	XFontStruct *kanji_font;
#endif KANJI
static	Boolean shown_clipboard = FALSE;
static	int current_view;
Widget	menubar;
Widget	tool_menu;
Widget	file_menu;
Widget	edit_menu;

static XrmOptionDescRec options[] = {
    {"-x",	"*x",		 	XrmoptionSepArg,	NULL},
    {"-y",	"*y",		 	XrmoptionSepArg,	NULL},
    {"-d",	"*windowType",	 	XrmoptionSepArg,	NULL},
    {"-w",	"*screenWidth",	 	XrmoptionSepArg,	NULL},
    {"-h",	"*screenHeight",	XrmoptionSepArg,	NULL},
    {"-maxw",	"*maxScreenWidth",	XrmoptionSepArg,	NULL},
    {"-maxh",	"*maxScreenHeight",	XrmoptionSepArg,	NULL},
    {"-minw",	"*minScreenWidth",	XrmoptionSepArg,	NULL},
    {"-minh",	"*minScreenHeight",	XrmoptionSepArg,	NULL},
    {"-resize",	"*resizeareaFlag",	XrmoptionSepArg,	NULL},
    {"-close",	"*closeboxFlag",	XrmoptionSepArg,	NULL},
    {"-title",	"*titlebarFlag",	XrmoptionSepArg,	NULL},
    {"-menu",	"*menubarFlag",		XrmoptionSepArg,	NULL},
    {"-scroll",	"*scrollboxFlag",	XrmoptionSepArg,	NULL},
    {"-vscroll","*vscrollbarFlag",	XrmoptionSepArg,	NULL},
    {"-hscroll","*hscrollbarFlag",	XrmoptionSepArg,	NULL},
};

/*===================================================================
	Callback list
=====================================================================*/
static XtCallbackRec close_callback[] = {
	{ callback_close,	NULL },
	{ NULL,			NULL },
};
static XtCallbackRec resize_callback[] = {
	{ callback_resize,	NULL },
	{ NULL,			NULL },
};
static XtCallbackRec hscroll_callback[] = {
	{ callback_hscroll,	NULL },
	{ NULL,			NULL },
};
static XtCallbackRec vscroll_callback[] = {
	{ callback_vscroll,	NULL },
	{ NULL,			NULL },
};
static XtCallbackRec tool_callback[] = {
	{tool_proc,		NULL}, 
	{NULL,			NULL},
};
static XtCallbackRec file_callback[] = {
	{file_proc,		NULL}, 
	{NULL,			NULL},
};
static XtCallbackRec edit_callback[] = {
	{edit_proc,		NULL},
	{NULL,			NULL},
};
static XtCallbackRec scroll_callback[] = {
        {callback_scroll,       NULL},
        {NULL,                  NULL},
};
static XtCallbackRec move_callback[] = {
        {callback_raise,        NULL},
        {NULL,                  NULL},
};
static XtCallbackRec selclr_callback[] = {
        {callback_selclr,       NULL},
        {NULL,                  NULL},
};
static XtCallbackRec raise_callback[] = {
        {callback_raise,        NULL},
        {NULL,                  NULL},
};

/*===================================================================
	menu items
=====================================================================*/
static XtMenuItem tool_items[] = {
    {(Widget)NULL, "tool1",	NULL,	(ArgList)NULL, 0},
    {(Widget)NULL, "tool2",	NULL,	(ArgList)NULL, 0},
    {(Widget)NULL, "tool3",	NULL,	(ArgList)NULL, 0},
    {(Widget)NULL, "tool4",	NULL,	(ArgList)NULL, 0},
    {(Widget)NULL, "tool5",	NULL,	(ArgList)NULL, 0},
};
static XtMenuItem file_items[] = {
   {(Widget)NULL, "file1",	NULL,	(ArgList)NULL, 0},
   {(Widget)NULL, "file2",	NULL,	(ArgList)NULL, 0},
   {(Widget)NULL, "file3",	NULL,	(ArgList)NULL, 0},
   {(Widget)NULL, "file4",	NULL,	(ArgList)NULL, 0},
};
static XtMenuItem edit_items[] = {
   {(Widget)NULL, "edit1",      NULL,	(ArgList)NULL, 0},
   {(Widget)NULL, "edit2",      NULL,	(ArgList)NULL, 0},
   {(Widget)NULL, "edit3",      NULL,	(ArgList)NULL, 0},
   {(Widget)NULL, "edit4",      NULL,	(ArgList)NULL, 0},
   {(Widget)NULL, "edit5",      NULL,	(ArgList)NULL, 0},
};
/*===================================================================
	Default Arguments
=====================================================================*/
static Arg tool_arg[] = {
    {XtNpullDownCallback,	(XtArgVal)tool_callback },
    {XtNitems,			(XtArgVal)tool_items },
    {XtNnumItems,		(XtArgVal)(XtNumber(tool_items)) },
};
static Arg file_arg[] = {
    {XtNpullDownCallback,	(XtArgVal)file_callback },
    {XtNitems,			(XtArgVal)file_items },
    {XtNnumItems,		(XtArgVal)(XtNumber(file_items)) },
};
static Arg edit_arg[] = {
    {XtNpullDownCallback,	(XtArgVal)edit_callback },
    {XtNitems,			(XtArgVal)edit_items },
    {XtNnumItems,		(XtArgVal)(XtNumber(edit_items)) },
};
static Arg image_args[] = {
       {XtNwidth,              (XtArgVal)816},
       {XtNheight,             (XtArgVal)1024},
};
static Arg window_args[] = {
	{ XtNmenuClass,		(XtArgVal)NULL },
	{ XtNscreenWidth,	(XtArgVal)600 },
	{ XtNscreenHeight,	(XtArgVal)600 },
	{ XtNmaxScreenWidth,	(XtArgVal)816 },
	{ XtNmaxScreenHeight,	(XtArgVal)1024 },
	{ XtNcloseCallback,     (XtArgVal)close_callback },
	{ XtNresizeCallback,    (XtArgVal)resize_callback },
	{ XtNselclrCallback,    (XtArgVal)selclr_callback },
	{ XtNraiseCallback,     (XtArgVal)raise_callback },
	{ XtNmoveCallback,      (XtArgVal)move_callback },
	{ XtNiconify,	 	(XtArgVal)1 },
	{ XtNiconBitmapFile, 	(XtArgVal)"Cabinet" },
	{ XtNiconLabel, 	(XtArgVal)"cabinet" },
};
static Arg titlebar_args[] = {
	{ XtNleftLabel,	(XtArgVal)"Window Sample" },
#ifdef KANJI
	{ XtNleftFont,	(XtArgVal)0 },
	{ XtNleftKanjiFont,	(XtArgVal)0 },
#endif KANJI
	{ XtNheight,	(XtArgVal)22 },
};
static Arg vscroll_args[] = {
	{XtNscrollShownV,        (XtArgVal)600},
	{XtNscrollPositionV,     (XtArgVal)0},
	{XtNscrollMinV,          (XtArgVal)0},
	{XtNscrollMaxV,          (XtArgVal)1023},
	{XtNscrollSmoothV,       (XtArgVal)10},
};
static Arg hscroll_args[] = {
	{XtNscrollShownH,        (XtArgVal)600},
	{XtNscrollPositionH,     (XtArgVal)0},
	{XtNscrollMinH,          (XtArgVal)0},
	{XtNscrollMaxH,          (XtArgVal)815},
	{XtNscrollSmoothH,       (XtArgVal)10},
};

static Arg scroll_args[] = {
	{XtNwidth,	        (XtArgVal)64},
	{XtNheight,	        (XtArgVal)48},
	{XtNscrollShownH,        (XtArgVal)600},
	{XtNscrollPositionH,     (XtArgVal)0},
	{XtNscrollMinH,          (XtArgVal)0},
	{XtNscrollMaxH,          (XtArgVal)815},
	{XtNscrollSmoothH,       (XtArgVal)10},
	{XtNscrollShownV,        (XtArgVal)600},
	{XtNscrollPositionV,     (XtArgVal)0},
	{XtNscrollMinV,          (XtArgVal)0},
	{XtNscrollMaxV,          (XtArgVal)1023},
	{XtNscrollSmoothV,       (XtArgVal)10},
};
 static Arg child_args[] = {
        { XtNscreenClass,       (XtArgVal)NULL },
        { XtNx,                 (XtArgVal)80 },
        { XtNy,                 (XtArgVal)150 },
	{ XtNscreenWidth,       (XtArgVal)300 },
	{ XtNscreenHeight,      (XtArgVal)300 },
	{ XtNminScreenWidth,    (XtArgVal)300 },
	{ XtNminScreenHeight,   (XtArgVal)300 },
	{ XtNmaxScreenWidth,    (XtArgVal)300 },
	{ XtNmaxScreenHeight,   (XtArgVal)300 },
	{ XtNresizeareaFlag,    (XtArgVal)0 },
	/*
	{ XtNmaxScreenWidth,    (XtArgVal)300 },
	{ XtNmaxScreenHeight,   (XtArgVal)300 },
	*/
	{ XtNvscrollbarFlag,    (XtArgVal)0 },
	{ XtNhscrollbarFlag,    (XtArgVal)0 },
	{ XtNiconify,	 	(XtArgVal)1 },
	{ XtNiconBitmapFile, 	(XtArgVal)"Clock" },
	{ XtNiconLabel, 	(XtArgVal)"clock" },
};
static Arg titlebar1_args[] = {
        { XtNlabel,     (XtArgVal)"CLOCK" },
        { XtNheight,    (XtArgVal)22 },
};


/*
 * Report the syntax for calling xwindow.
 */
Syntax(call)
    char *call;
{
	fprintf(stderr, "%s : Syntax error\n", call);
	exit(1);
}

void main(argc, argv)
    int argc;
    char **argv;
{
    Widget	toplevel, w, w1, screen, child;
    Cardinal	i;


    toplevel = XtInitialize(argv[0], "SWindow", options, XtNumber(options), &argc, argv);
    if (argc != 1) Syntax(argv[0]);

    window_args[0].value = (XtArgVal)sMenuWidgetClass;
    w = XtCreateManagedWidget (argv[0], sWindowWidgetClass, toplevel,
				(ArgList)window_args, XtNumber(window_args));
    if (child = XtNameToWidget(w, "titlebar")) {
#ifdef KANJI
    	font = XLoadQueryFont( XtDisplay(toplevel), "8x16kana");
	titlebar_args[1].value = (XtArgVal)kanji_font;
    	kanji_font = XLoadQueryFont( XtDisplay(toplevel), "16x16kanji");
	titlebar_args[2].value = (XtArgVal)kanji_font;
#endif KANJI
	XtSetValues(child, titlebar_args, XtNumber(titlebar_args));
    }
    if (child = XtNameToWidget(w, "screen"))
    	screen = XtCreateManagedWidget ("image", sScreenWidgetClass, child, 
				(ArgList)image_args, XtNumber(image_args));
    child_args[0].value = (XtArgVal)clockWidgetClass;
    w1 = XtCreateManagedWidget ("window1", sWindowWidgetClass, screen,
	                        (ArgList)child_args, XtNumber(child_args));
    if (child = XtNameToWidget(w1, "titlebar"))
	XtSetValues(child, titlebar1_args, XtNumber(titlebar1_args));

    if (child = XtNameToWidget(w, "vscrollbar")) {
	XtSetValues(child, vscroll_args, XtNumber(vscroll_args));
	XtAddCallbacks(child, XtNcallback, vscroll_callback);
    }
    if (child = XtNameToWidget(w, "hscrollbar")) {
	XtSetValues(child, hscroll_args, XtNumber(hscroll_args));
	XtAddCallbacks(child, XtNcallback, hscroll_callback);
    }
    if (child = XtNameToWidget(w, "scrollbox")) {
	XtSetValues(child, scroll_args, XtNumber(scroll_args));
	XtAddCallbacks(child, XtNcallback, scroll_callback);
    }

    /* Create Menu Bar */
    menubar = XtNameToWidget(w, "menubar");
    for (i = 0; i < XtNumber(tool_items); i++)
	tool_items[i].class = sBitmapWidgetClass;
    tool_menu = XtCreateManagedWidget(
			"tool", sPDMenuWidgetClass, menubar,
			(ArgList)tool_arg, XtNumber(tool_arg));

    /* Create File Menu */
    for (i = 0; i < XtNumber(file_items); i++)
	file_items[i].class = sBitmapWidgetClass;
    file_menu = XtCreateManagedWidget(
			"file", sPDMenuWidgetClass, menubar,
			(ArgList)file_arg, XtNumber(file_arg));

    /* Create Edit Menu */
    for (i = 0; i < XtNumber(edit_items); i++)
	edit_items[i].class = sBitmapWidgetClass;
    edit_menu = XtCreateManagedWidget(
			"edit", sPDMenuWidgetClass, menubar,
			(ArgList)edit_arg, XtNumber(edit_arg));

    current_view = 0;

    XtRealizeWidget (toplevel);
    XSetSelectionOwner(XtDisplay(w), XA_PRIMARY,
			XtWindow(w), CurrentTime);
    XtMainLoop();
}


/*===============================================================
	Change scroll bar status
===============================================================*/
static void change_scrollbar(w)
Widget	w;
{
    Arg		args[2];
    int		width, height;
    int		x, y;
    Widget		child;

    if (child = XtNameToWidget(w, "screen")) {
	width = height = 0;
	XtSetArg(args[0], XtNwidth,  &width);
	XtSetArg(args[1], XtNheight, &height);
	XtGetValues(child, args, 2);
    }
    if (child = XtNameToWidget(w, "screen.image")) {
	XtSetArg(args[0], XtNx, &x);
	XtSetArg(args[1], XtNy, &y);
	XtGetValues(child, args, 2);
    }

    if (child = XtNameToWidget(w, "vscrollbar")) {
	XtSetArg(args[0], XtNscrollShownV, height - y);
	XtSetValues(child, args, 1);
    }

    if (child = XtNameToWidget(w, "hscrollbar")) {
	XtSetArg(args[0], XtNscrollShownH, width - x);
	XtSetValues(child, args, 1);
    }

    if (child = XtNameToWidget(w, "scrollbox")) {
	XtSetArg(args[0], XtNscrollShownV, height - y);
	XtSetArg(args[1], XtNscrollShownH, width - x);
	XtSetValues(child, args, 2);
    }
}

/*===============================================================
	Call back routine (selection clear)
===============================================================*/
static void callback_selclr(widget, closure,callData)
Widget	widget;
caddr_t	closure;
caddr_t	callData;
{
    Arg		args;
    int		inactive = 0;

    XtSetArg(args, XtNinactive, &inactive);
    XtGetValues(widget, &args, 1);
    if (!inactive) {
	XtSetArg(args, XtNinactive, 1);
	XtSetValues(widget, &args, 1);
    }
}
/*===============================================================
	Call back routine (raise event)
===============================================================*/
static void callback_raise(widget, closure,callData)
Widget	widget;
caddr_t	closure;
caddr_t	callData;
{
    Arg		args;
    int		inactive = 0;

    XtSetArg(args, XtNinactive, &inactive);
    XtGetValues(widget, &args, 1);
    if (inactive) {
	XtSetArg(args, XtNinactive, 0);
	XtSetValues(widget, &args, 1);
	XSetSelectionOwner(XtDisplay(widget), XA_PRIMARY,
			XtWindow(widget), CurrentTime);
    }
}
/*===============================================================
	Call back routine (close box)
===============================================================*/
static void callback_close(widget, closure,callData)
Widget	widget;
caddr_t	closure;
caddr_t	callData;
{
}


/*===============================================================
	Call back routine (resize box)
===============================================================*/
static void callback_resize(widget, closure,callData)
Widget	widget;
caddr_t	closure;
caddr_t	callData;
{
    Widget		image;
    SresizeEvent	*resize;
    int	x, y;


    resize = (SresizeEvent *)callData;
    change_scrollbar(widget);

    if ((resize->type & ResizeEv_PlusX) &&
	(resize->type & ResizeEv_PlusY))
		return;
    if (image = XtNameToWidget(widget, "screen.image")) {
	if (resize->type & ResizeEv_PlusX)
	    x = image->core.x;
	else
	    x = image->core.x + resize->x;
	if (resize->type & ResizeEv_PlusY)
	    y = image->core.y;
	else
	    y = image->core.y + resize->y;
	XtMoveWidget(image, x, y);
    }
}

/*===============================================================
	Call back routine (scroll box)
===============================================================*/
static void callback_scroll(widget, closure,callData)
Widget	widget;
caddr_t	closure;
caddr_t callData;
{
    Arg		arg;
    Position	x, y;
    Widget		image;
    SscrollEvent	*event;

    event = (SscrollEvent *)callData;
    change_scrollbar(widget);

    if (image = XtNameToWidget(widget->core.parent, "screen.image")) {
	x = - (int)(event->scrollEv_posH);
	y = - (int)(event->scrollEv_posV);
	XtMoveWidget(image, (int)x, (int)y);
    }
}


/*===============================================================
	Call back routine (horizontal scroll bar)
===============================================================*/
static void callback_hscroll(widget, closure,callData)
Widget	widget;
caddr_t	closure;
caddr_t	callData;
{
    Arg		arg;
    Position	x, y;
    Widget		image;
    SscrollEvent	*event;

    event = (SscrollEvent *)callData;
    change_scrollbar(widget);

    if (image = XtNameToWidget(widget->core.parent, "screen.image")) {
	y = 0;
	XtSetArg(arg, XtNy, &y);
	XtGetValues(image, &arg, 1);
	x = - (int)(event->scrollEv_posH);
	XtMoveWidget(image, (int)x, (int)y);
    }
}


/*===============================================================
	Call back routine (vertical scroll bar)
===============================================================*/
static void callback_vscroll(widget, closure,callData)
Widget	widget;
caddr_t	closure;
caddr_t	callData;
{
    Arg		arg;
    Position	x, y;
    Widget		image;
    SscrollEvent	*event;

    event = (SscrollEvent *)callData;
    change_scrollbar(widget);

    if (image = XtNameToWidget(widget->core.parent, "screen.image")) {
	x = 0;
	XtSetArg(arg, XtNx, &x);
	XtGetValues(image, &arg, 1);
	y = - (int)(event->scrollEv_posV);
	XtMoveWidget(image, (int)x, (int)y);
    }
}
/*===============================================================
	Call back routine (menu bar)
===============================================================*/
void tool_proc(w, closure, callData)
Widget w;
caddr_t closure;
caddr_t callData;
{
	int item = (int)callData;

	switch (item) {
		case 0:	/* About */
			fprintf(stderr, "Mail is selected\n");
			break;

		case 1:	/* Clock */
			fprintf(stderr, "Clock is selected\n");
			break;

		case 2:	/* Calc */
			fprintf(stderr, "Calc is selected\n");
			break;

		case 3:	/* Calendar */
			fprintf(stderr, "Calendar is selected\n");
			break;

		case 4:	/* NotePad */
			fprintf(stderr, "NotePad is selected\n");
			break;
	}
}

/*===============================================================
	Call back routine (menu bar)
===============================================================*/
void file_proc(w, closure, callData)
Widget w;
caddr_t closure;
caddr_t callData;
{
	int item = (int)callData;

	switch (item) {
		case 0:	/* Open File */
			fprintf(stderr, "Open File is selected\n");
			break;

		case 1:	/* Close File */
			fprintf(stderr, "Close File is selected\n");
			break;

		case 2:	/* Print File */
			fprintf(stderr, "Print File is selected\n");
			break;

		case 3:	/* Quit */
			fprintf(stderr, "Quit is selected\n");
			exit(1);
	}
}

/*===============================================================
	Call back routine (menu bar)
===============================================================*/
void edit_proc(w, closure, callData)
Widget w;
caddr_t closure;
caddr_t callData;
{
	int item = (int)callData;
	Widget widget;

	switch (item) {
		case 0: /* Undo */
			fprintf(stderr, "Undo is selected\n");
			break;

		case 1:	/* Cut */
			fprintf(stderr, "Cut is selected\n");
			break;

		case 2:	/* Paste */
			fprintf(stderr, "Paste is selected\n");
			break;

		case 3:	/* Copy */
			fprintf(stderr, "Copy is selected\n");
			break;

		case 4:	/* Clear */
			fprintf(stderr, "Clear is selected\n");
			break;
	}
}

