#ifndef lint
static char rcsid[] = "$Header: CodeConv.c,v 1.1 88/08/20 09:06:17 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	CodeConv.c,v $
 * Revision 1.1  88/08/20  09:06:17  michael
 * Initial revision
 * 
 */

#ifdef KANJI
/***********************************************************
 *                                                         *
 *  JIS <-> Shit JIS code conversion utilities             *
 *	Copyright (c) 1988 Sony Corp.                      *
 *                                                         *
 ***********************************************************/

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

#include <ctype.h>
#include <jctype.h>
#include <X11/Intrinsic.h>

#define KanaIn	0x0e
#define KanaOut	0x0f
#define ESC 0x1b
#define ShiftCode(x, y, z) {result[j++] = x;\
			   result[j++] = y;\
			   result[j++] = z;}

typedef enum { Ascii, Kana, Kanji } CharMode;

char *
Sjis2jis( str, length )
char *str;
int length;
{
    int i,j;
    CharMode mode = Ascii;
    char *result;
    unsigned short jis;
    int rsize;

    if ( length <= 0 )
	return NULL;
    
    result = XtMalloc( rsize = 2 * length * sizeof( char *) );
    i = j = 0;
    while ( i < length ) {
        if (iskanji( str[i] )) {
	    if ( mode != Kanji ) {
	        if ( j >= rsize - 10)
		    result = XtRealloc( result, rsize = rsize * 2 );
		ShiftCode( ESC, '$', 'B' );
		mode = Kanji;
	    }
	    jis = ms2jis( ((str[i++] << 8) & 0xff00) + (str[i++] & 0xff) );
	    if ( j >= rsize - 10)
		result = XtRealloc( result, rsize = rsize * 2 );
	    result[j++] = ( jis >> 8 ) & 0xff;
	    result[j++] =  jis & 0xff;
	} else if(iskana( str[i] )) {
	    if ( mode != Kana) {
		if ( j >= rsize - 10)
		    result = XtRealloc( result, rsize = rsize * 2 );
		ShiftCode( ESC, '(', 'I' );
		mode = Kana;
	    }
	    if ( j >= rsize - 10)
		result = XtRealloc( result, rsize = rsize * 2 );
	    result[j++] = str[i++] & 0xff;
	} else {
	    if (mode != Ascii) {
		if ( j >= rsize - 10)
		    result = XtRealloc( result, rsize = rsize * 2 );
		ShiftCode( ESC, '(', 'B' );
		mode = Ascii;
	    }
	    if ( j >= rsize - 10)
		result = XtRealloc( result, rsize = rsize * 2 );
	    result[j++] = str[i++];
	}
    }
    if ( mode != Ascii )
	ShiftCode( ESC, '(', 'B' );
    result[j] = NULL;
    return result;
}
    
Boolean
isascii_in( str )
char *str;
{
    if ( (str[0] == ESC) && (str[1] == '(') && (str[2] == 'B') )
	return TRUE;
    return FALSE;
}

Boolean
iskana_in( str )
char *str;
{
    if ( (str[0] == ESC) && (str[1] == '(') && (str[2] == 'I') )
	return TRUE;
    return FALSE;
}

Boolean
iskanji_in( str )
char *str;
{
    if ( (str[0] == ESC) && (str[1] == '$') && (str[2] == 'B') )
	return TRUE;
    return FALSE;
}

char *
Jis2sjis( str, length )
char *str;
int length;
{
    int i,j;
    CharMode mode = Ascii;
    char *result;
    unsigned short sjis;
    int rsize;

    if ( length <= 0 )
	return NULL;
    
    result = XtMalloc( rsize =  length * sizeof( char *) );
    i = j = 0;
    while ( i < length ) {
        if ( i < length - 2 && isascii_in( &str[i] )) {
	    if ( mode != Ascii ) 
		mode = Ascii;
	    i += 3;
	    continue;
	} else if ( i < length - 2 && iskana_in( &str[i] )) {
	    if ( mode != Kana ) 
		mode = Kana;
	    i += 3;
	    continue;
	} else if ( i < length - 2 && iskanji_in( &str[i] )) {
	    if ( mode != Kanji )
		mode = Kanji;
	    i += 3;
	    continue;
	}
	if ( mode == Kanji ) {
	    sjis = jis2ms( ((str[i++] << 8) & 0xff00) + (str[i++] & 0xff) );
	    result[j++] = ( sjis >> 8 ) & 0xff;
	    result[j++] =  sjis & 0xff;
	} else if ( mode == Kana ) {
	    result[j++] = str[i++] | 0x80;
	} else 
	    result[j++] = str[i++];
    }
    result[j] = NULL;
    return result;
}
#endif KANJI
