/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SDialog.h,v 1.1 88/08/20 09:06:44 michael Exp $ Sony Corporation
 *
 * $Log:	SDialog.h,v $
 * Revision 1.1  88/08/20  09:06:44  michael
 * Initial revision
 * 
 */

#ifndef _SDialog_h
#define _SDialog_h

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		pixel		White
 border		     BorderColor	pixel		Black
 borderWidth	     BorderWidth	int		1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		int		0
 label		     Label		String		NULL
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 maximumLength	     Max		int		256
 sensitive	     Sensitive		Boolean		True
 value		     Value		String		NULL
 width		     Width		int		0
 x		     Position		int		0
 y		     Position		int		0

 dialogType	     DialogType         XtDialogType    alert
 itemList            ItemList           XtDialogItemList NULL
 defaultButton       DefaultButton      String          button1
 numBeep             NumBeep            int             1
*/


#include <X11/Form.h>

#define XtNgrabFocus	"grabFocus"
#define XtCGrabFocus	"GrabFocus"

#define XtNdialogType	"dialogType"
#define XtNitemList	"itemList"
#define XtNdefaultButton	"defaultButton"
#define XtNnumBeep	"numBeep"

#define XtCDialogType	"DialogType"
#define XtCItemList	"ItemList"
#define XtCDefaultButton	"DefaultButton"
#define XtCNumBeep	"NumBeep"

typedef enum { XtdtAlert, XtdtModal, XtdtModeless } XtDialogType;
typedef enum { XtdiBitmap, XtdiButton, XtdiRadioBtn, XtdiCheckBtn,
	       XtdiLabel, XtdiStandardText, XtdiText, XtdiNumericText, 
	       XtdiStaticText, XtdiScrollText, XtdiViewText, XtdiUser, 
	       XtdiEnd 
	} XtDialogItemType;

typedef struct {
	XtDialogItemType	item_type;
	WidgetClass		item_widget_class;
	char			*item_name;
	ArgList			item_arg;
	unsigned int		num_arg;
	Boolean			focus;
	Widget			widget;
	char			*fromVert;
	char			*fromHoriz;
	caddr_t			value;
} XtDialogItem, *XtDialogItemList;

typedef struct _SDialogClassRec	*SDialogWidgetClass;
typedef struct _SDialogRec	*SDialogWidget;

extern WidgetClass sDialogWidgetClass;

extern Widget XtSCreateDialog();
extern void XtSDialogGetItemValue();
extern void XtSDialogPopupCallback();
extern void XtSDialogPopdownCallback();

#endif _SDialog_h
/* DON'T ADD STUFF AFTER THIS #endif */
