/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SDialogP.h,v 1.1 88/08/20 09:06:45 michael Exp $ Sony Corporation
 *
 * $Log:	SDialogP.h,v $
 * Revision 1.1  88/08/20  09:06:45  michael
 * Initial revision
 * 
 */

#ifndef _SDialogP_h
#define _SDialogP_h

#include "SDialog.h"
#include <X11/FormP.h>

#define MaxGroup 100

typedef struct {int empty;} SDialogClassPart;

typedef struct _SDialogClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    FormClassPart	form_class;
    SDialogClassPart	sdialog_class;
} SDialogClassRec;

extern SDialogClassRec sDialogClassRec;

typedef struct _SDialogPart {
    /* resources */
    XtDialogType	dialog_type;	/* Dialog Type */
    XtDialogItemList	item_list;	/* Dialog item list */
    char		*default_button; /* Default button name */
    int			num_beep;	/* Number of Beeps (Alert only)*/
    /* private data */
    WidgetList		focus_list;
    int			num_focus;
    int			num_slots;
    int			current_focus;	/* current focus in focus list */
    Widget		current_focus_widget; 
    int			beep_count;
    Widget		radio_button_group[MaxGroup];
    Boolean		has_grab;      /* currently unused */
    Widget		prev_grab;     /* currently unused */
} SDialogPart;

typedef struct _SDialogRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    FormPart		form;
    SDialogPart		dialog;
} SDialogRec;

typedef struct {int empty;} SDialogConstraintsPart;

typedef struct _SDialogConstraintsRec {
    FormConstraintsPart	  form;
    SDialogConstraintsPart dialog;
} SDialogConstraintsRec, *SDialogConstraints;

#endif _SDialogP_h
