#ifndef lint
static char rcsid[] = "$Header: SMenu.c,v 1.2 88/08/20 10:45:14 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SMenu.c,v $
 * Revision 1.2  88/08/20  10:45:14  michael
 * Null pointer accesse.
 * 
 * Revision 1.1  88/08/20  09:06:29  michael
 * Initial revision
 * 
 */

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/********************************************************
*							*
*	Sony Menu Widget				*
*							*
*	Written by M.abe				*
*							*
********************************************************/

/********************************************************
*							*
*	Include definition				*
*							*
********************************************************/

#include	<stdio.h>

#include	<X11/IntrinsicP.h>
#include	<X11/StringDefs.h>
#include	<X11/Misc.h>
#include	<X11/Cascade.h>
#include	<X11/Shell.h>
#include	<X11/ShellP.h>

#include	<X11/SBitmapP.h>
#include	<X11/SPDMenu.h>

#include	<X11/SMenu.h>
#include	<X11/SMenuP.h>

/********************************************************
*							*
*	Private procedure definition			*
*							*
********************************************************/

static	void			Initialize();
static	void			Realize();
static	void			Resize();
static	void			Destroy();
static	Boolean			SetValues();
static	XtGeometryResult	GeometryManager();
static	void			ChangeManaged();
static	XtGeometryResult	PreferredSize();

static	void			UpdateSizeInfo();
static	void			DoLayout();

static	void			Set();
static	void			Unset();
static	void			Unset1();
static	void			Drag();
static	void			Notify();
static	void			Notify1();
static	void			Cancel();
static	void			Toggle();

/********************************************************
*							*
*	Full class record constant			*
*							*
********************************************************/

static char defaultTranslations[] =
        "<Btn1Down>: set() \n\
        <Btn1Up>: unset() \n\
        <Btn1Motion>: drag() \n\
	<Btn2Down>: toggle() \n\
	<Btn3Down>: cancel()";

static XtResource resources[] = {
    {XtNcols, XtCCols, XtRInt, sizeof(int),
	XtOffset(SMenuWidget, smenu.columns), XtRString, "1"},
    {XtNrows, XtCRows, XtRInt, sizeof(int),
	XtOffset(SMenuWidget, smenu.rows), XtRString, "1"},
    {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t),
        XtOffset(SMenuWidget, smenu.callbacks), XtRCallback,
        (caddr_t)NULL},
    {XtNflash, XtCFlash, XtRInt, sizeof(int),
        XtOffset(SMenuWidget, smenu.flash), XtRString, "0"},
    {XtNnumItems, XtCNumItems, XtRInt, sizeof(int),
	XtOffset(SMenuWidget, smenu.num_items), XtRString, "0"},
    {XtNitems, XtCItems, XtRPointer, sizeof(caddr_t),
	XtOffset(SMenuWidget, smenu.items), XtRPointer, NULL},
    {XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor),
	XtOffset(SMenuWidget, smenu.cursor), XtRString, "opendot"},
    {XtNselectList, XtCSelectList, XtRPointer, sizeof(WidgetList),
	XtOffset(SMenuWidget, smenu.select_list), XtRPointer,
	(caddr_t)NULL},
    {XtNnumSelect, XtCNumSelect, XtRInt, sizeof(int),
	XtOffset(SMenuWidget, smenu.num_select), XtRString, "0"},
};

static XtActionsRec actionsList[] = {
	{"set",		Set},
	{"unset",	Unset},
	{"unset1",	Unset1},
	{"drag",	Drag},
	{"notify",	Notify},
	{"toggle",	Toggle},
	{"cancel",	Cancel},
};

SMenuClassRec sMenuClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &compositeClassRec,
    /* class_name         */    "SMenu",
    /* widget_size        */    sizeof(SMenuRec),
    /* class_initialize   */    NULL,
    /* class_part_init	  */	NULL,
    /* class_inited       */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook	  */	NULL,
    /* realize            */    Realize,
    /* actions            */    actionsList,
    /* num_actions	  */	XtNumber(actionsList),
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    Destroy,
    /* resize             */    Resize,
    /* expose             */    NULL,
    /* set_values         */    SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */	XtInheritSetValuesAlmost,
    /* get_values_hook	  */	NULL,
    /* accept_focus       */    NULL,
    /* version		  */	XtVersion,
    /* callback_private	  */	NULL,
    /* tm_table		  */	defaultTranslations,
    /* query_geometry	  */	PreferredSize,
  },{
/* composite_class fields */
    /* geometry_manager   */    GeometryManager,
    /* change_managed     */    ChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* move_focus_to_next */    NULL,
    /* move_focus_to_prev */    NULL
  },{
    /* mumble		  */	0	/* Make C compiler happy   */
  }
};

WidgetClass sMenuWidgetClass = (WidgetClass)&sMenuClassRec;

/********************************************************
*							*
*	Private Routines				*
*							*
********************************************************/

/********************************************************
*							*
*	Class Initialize				*
*							*
********************************************************/

/*
static void ClassInitialize()
{
}
*/

/********************************************************
*							*
*	Initialize					*
*							*
********************************************************/

static void Initialize(request, new, args, num_args)
SMenuWidget request, new;
ArgList args;
Cardinal num_args;
{
    SMenuWidget mw = (SMenuWidget)new;
    XtMenuItemList items;
    int i;

    if (new->core.width == 0) new->core.width = 10;
    if (new->core.height == 0) new->core.height = 10;

    new->smenu.max_width = NULL;
    new->smenu.max_height = NULL;
    new->smenu.max_border_width = 0;

    new->smenu.activated = NULL;
    new->smenu.current_widget = NULL;

    items = mw->smenu.items;
    for (i = 0; i < mw->smenu.num_items; i++) {
	items[i].widget = XtCreateManagedWidget(items[i].name,
				items[i].class, mw,
				items[i].args, items[i].num_args);
    }

    mw->smenu.last_selected_time = 0;
}

/********************************************************
*							*
*	Realize						*
*							*
********************************************************/

static void Realize(w, valueMask, attributes)
register Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
    attributes->bit_gravity = NorthWestGravity;
    *valueMask |= CWBitGravity;
    
    XtCreateWindow( w, (unsigned)InputOutput, (Visual *)CopyFromParent,
		   *valueMask, attributes);
}

/********************************************************
*							*
*	Destroy						*
*							*
********************************************************/


static void Destroy(w)
Widget w;
{
    SMenuWidget mw = (SMenuWidget)w;

    if (mw->smenu.max_width) free(mw->smenu.max_width);
    if (mw->smenu.max_height) free(mw->smenu.max_height);
}


/********************************************************
*							*
*	Resize						*
*							*
********************************************************/

static void Resize(mw)
SMenuWidget	mw;
{
}

/********************************************************
*							*
*	Redisplay					*
*							*
********************************************************/

/*
Redisplay(w, event)
Widget w;
XEvent *event;
{

}
*/

/********************************************************
*							*
*	Set Values					*
*							*
********************************************************/

static Boolean SetValues (current, request, new, last)
SMenuWidget current, request, new;
Boolean last;
{
    SMenuWidget cur = (SMenuWidget) current;
    SMenuWidget req = (SMenuWidget) request;
    SMenuWidget mw = (SMenuWidget) new;
    Arg arg[1];

    if (cur->smenu.columns != mw->smenu.columns ||
	cur->smenu.rows != mw->smenu.rows) {
	    UpdateSizeInfo(mw);
	    DoLayout(mw);
    }

    if (cur->smenu.current_widget != mw->smenu.current_widget) {
	arg[0].name = XtNselected;
	if (cur->smenu.current_widget != NULL) {
	    arg[0].value = FALSE;
	    XtSetValues(cur->smenu.current_widget, arg, 1);
	}
	arg[0].value = TRUE;
	XtSetValues(mw->smenu.current_widget, arg, 1);
    }
    return (FALSE);
}

/********************************************************
*							*
*	Geometry Manager				*
*							*
********************************************************/

/*ARGSUSED*/
static XtGeometryResult GeometryManager(w, request, reply)
Widget		w;
XtWidgetGeometry	*request;
XtWidgetGeometry	*reply;	/* RETURN */
{
    SMenuWidget mw;

    /* Position request always denied */
    if ((request->request_mode & CWX && request->x != w->core.x) ||
	(request->request_mode & CWY && request->y != w->core.y))
	return (XtGeometryNo);

    if (request->request_mode & CWWidth)
	    w->core.width = request->width;
    if (request->request_mode & CWHeight)
	    w->core.height = request->height;
    if (request->request_mode & CWBorderWidth)
	    w->core.border_width = request->border_width;

    mw = (SMenuWidget) w->core.parent;
    UpdateSizeInfo(mw);
    DoLayout(mw);
    return (XtGeometryYes);
}

static XtGeometryResult PreferredSize(w, constraint, preferred)
Widget		w;
XtWidgetGeometry	*constraint;
XtWidgetGeometry	*preferred;	/* RETURN */
{
    return (XtGeometryYes);
}

/********************************************************
*							*
*	ChangeManaged					*
*							*
********************************************************/

static void ChangeManaged(mw)
SMenuWidget mw;
{
	UpdateSizeInfo(mw);
	DoLayout(mw);
}

/********************************************************
*							*
*	Utility procedures				*
*							*
********************************************************/

/********************************************************
*							*
*	Update size info				*
*							*
********************************************************/

static void UpdateSizeInfo(mw)
SMenuWidget mw;
{
    int i, row, column;
    Widget w;

    /* free old size info table */

    if (mw->smenu.max_width) XtFree(mw->smenu.max_width);
    if (mw->smenu.max_height) XtFree(mw->smenu.max_height);

    /* alloc new size info table */
    mw->smenu.max_width =
		(int *)XtMalloc(mw->smenu.columns * sizeof(int));
    mw->smenu.max_height =
		(int *)XtMalloc(mw->smenu.rows * sizeof(int));

    /* fill zero in it */
    for (i = 0; i < mw->smenu.columns; i++)
		mw->smenu.max_width[i] = 0;
    for (i = 0; i < mw->smenu.rows; i++)
		mw->smenu.max_height[i] = 0;

    /* update size info table */
    i = 0;
    for (row = 0; row < mw->smenu.rows; row++) {
	for (column = 0; column < mw->smenu.columns; column++) {
	    do {
		if (i >= mw->composite.num_mapped_children) return;
		w = mw->composite.children[i++];
	    } while (!w->core.managed);
	    mw->smenu.max_width[column] =
		Max(mw->smenu.max_width[column], w->core.width);
	    mw->smenu.max_height[row] =
		Max(mw->smenu.max_height[row], w->core.height);
	    mw->smenu.max_border_width =
		Max(mw->smenu.max_border_width, w->core.border_width);
	}
    }
}

/********************************************************
*							*
*	Do Layout					*
*							*
********************************************************/

static void DoLayout(mw)
SMenuWidget mw;
{
    int i;
    int x, y;
    int origin_x, origin_y;
    int row, column;
    Widget w;

    int total_width = 0, total_height = 0;
    XtWidgetGeometry  reqGeo;

    i = 0;
    y = 0;
    for (row = 0; row < mw->smenu.rows; row++) {
	x = 0;
	for (column = 0; column < mw->smenu.columns; column++) {
	    do {
		if (i >= mw->composite.num_mapped_children) goto adjust;
		w = mw->composite.children[i++];
	    } while (!w->core.managed);
	    XtResizeWidget(w, mw->smenu.max_width[column],
		mw->smenu.max_height[row], mw->smenu.max_border_width);
	    XtMoveWidget(w, x, y);
	    x += mw->smenu.max_width[column] +
		 2 * mw->smenu.max_border_width;
	}
	y += mw->smenu.max_height[row] + 2 * mw->smenu.max_border_width;
    }

adjust:
	reqGeo.request_mode = NULL;
	for (i = 0; i < mw->smenu.columns; i++)
	    total_width += mw->smenu.max_width[i] +
				2 * mw->smenu.max_border_width;
	if (total_width != mw->core.width) {
	    reqGeo.request_mode |= CWWidth;
	    reqGeo.width = total_width;
	}
	for (i = 0; i < mw->smenu.rows; i++)
	    total_height += mw->smenu.max_height[i]  +
				2 * mw->smenu.max_border_width;
	if (total_height != mw->core.height) {
	    reqGeo.request_mode |= CWHeight;
	    reqGeo.height = total_height;
	}
	if (reqGeo.request_mode != NULL) {
	    if (XtMakeGeometryRequest((Widget)mw, &reqGeo,
		    (XtWidgetGeometry *)NULL) == XtGeometryYes) {
			mw->core.width = total_width;
			mw->core.height = total_height;
	    }
	}
}

/********************************************************
*                                                       *
*       Action procedure                                *
*                                                       *
********************************************************/

#define RedisplayBitmapWidget(w)	((*((SBitmapWidgetClass)XtClass(w))->sbitmap_class.redisplay)((Widget)w, event))

static Boolean isSelected(mw, w)
SMenuWidget mw;
Widget w;
{
	int i;

	for (i = 0; i < mw->smenu.num_select; i++) {
	    if (w == mw->smenu.select_list[i]) return(TRUE);
	}
	return(FALSE);
}

static Unselect(mw, w)
SMenuWidget mw;
Widget w;
{
    int i, j;

    for (i = 0; i < mw->smenu.num_select; i++) {
	if (w == mw->smenu.select_list[i]) {
	    for (j = i+1; j < mw->smenu.num_select; j++)
		mw->smenu.select_list[j-1] =
					mw->smenu.select_list[j];
	    mw->smenu.num_select--;
	    mw->smenu.select_list =
	    (Widget *)realloc(mw->smenu.select_list,
				  sizeof(Widget)*mw->smenu.num_select);
	    return;
	}
    }
}

static Select(mw, w)
SMenuWidget mw;
Widget w;
{
    int i;

    for (i = 0; i < mw->smenu.num_select; i++) {
	if (w == mw->smenu.select_list[i]) return;
    }
    mw->smenu.num_select++;
    mw->smenu.select_list = (Widget *)realloc(mw->smenu.select_list,
				sizeof(Widget *)*mw->smenu.num_select);
    mw->smenu.select_list[mw->smenu.num_select - 1] = w;
}

/********************************************************
*                                                       *
*       Set                                             *
*                                                       *
********************************************************/

static void Set(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long *num_param;
{
        SMenuWidget mw = (SMenuWidget)w;
	SBitmapWidget current, new;
	ShellWidget shell;
	WidgetList sel_list;
	int i;

	new = (SBitmapWidget)XtWindowToWidget(XtDisplay(w),
					event->xbutton.subwindow);

	mw->smenu.activated = TRUE;
	if (!new || !new->core.sensitive) return;

	mw->smenu.current_widget = (Widget)new;

	if (mw->smenu.num_select == 1 &&
	    new == (SBitmapWidget)mw->smenu.select_list[0] &&
	    event->xbutton.time - mw->smenu.last_selected_time < 500) {
		Notify(mw, event, param, num_param);
		mw->smenu.last_selected_time = 0;
	} else {
	    mw->smenu.last_selected_time = event->xbutton.time;
	    sel_list = mw->smenu.select_list;
	    if (sel_list) {
		for (i = 0; i < mw->smenu.num_select; i++) {
		    ((SBitmapWidget)sel_list[i])->sbitmap.highlighted = FALSE;
		    RedisplayBitmapWidget(sel_list[i]);
		}
	    }
	    if (new) {
		new->sbitmap.highlighted = TRUE;
		RedisplayBitmapWidget(new);
		if (XtClass(new) == sPDMenuWidgetClass) {
/*		    XGrabServer(XtDisplay(new));	*/
		    XtPullMenuDown(new);
		}
	    }
	}
	free(sel_list);
	mw->smenu.select_list = NULL;
	mw->smenu.num_select = 0;
}

/********************************************************
*                                                       *
*       Unset                                           *
*                                                       *
********************************************************/

static void Unset(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
Cardinal *num_param;
{
        SMenuWidget mw = (SMenuWidget)w;
	SBitmapWidget current;
	int i, j;

	mw->smenu.activated = FALSE;
	current = (SBitmapWidget)mw->smenu.current_widget;

	if (current) {
	    if (*num_param != 0 && !strcmp(param[0], "goAway")) {
		for (i = 0; i < mw->smenu.flash; i++) {
		    current->sbitmap.highlighted = FALSE;
		    RedisplayBitmapWidget(current);
		    XSync(XtDisplay(current), 1);
		    for (j = 3000; j; j--);
		    current->sbitmap.highlighted = TRUE;
		    RedisplayBitmapWidget(current);
		    XSync(XtDisplay(current), 1);
		    for (j = 3000; j; j--);
		}
		current->sbitmap.highlighted = FALSE;
		RedisplayBitmapWidget(current);
	    } else if (current->core.sensitive) {
		mw->smenu.select_list =
				(WidgetList)malloc(sizeof(Widget));
		mw->smenu.select_list[0] = (Widget)current;
		mw->smenu.num_select = 1;
	    }
	}
	mw->smenu.current_widget = NULL;
}

static void Unset1(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
Cardinal *num_param;
{
        SMenuWidget submenu = (SMenuWidget)w;
	SMenuWidget menubar;
	SBitmapWidget current_item, current_menu;
	ShellWidget shell;
	int i, j;

	submenu->smenu.activated = FALSE;
	current_item = (SBitmapWidget)submenu->smenu.current_widget;

	if (current_item) {
	    for (i = 0; i < submenu->smenu.flash; i++) {
		current_item->sbitmap.highlighted = FALSE;
		RedisplayBitmapWidget(current_item);
		XSync(XtDisplay(current_item), 1);
		for (j = 3000; j; j--);
		current_item->sbitmap.highlighted = TRUE;
		RedisplayBitmapWidget(current_item);
		XSync(XtDisplay(current_item), 1);
		for (j = 3000; j; j--);
	    }
	    current_item->sbitmap.highlighted = FALSE;
	    RedisplayBitmapWidget(current_item);
	}

	shell = (ShellWidget)submenu->core.parent;
	if (XtClass(shell) == popupWidgetClass) {
	    current_menu = (SBitmapWidget)shell->core.parent;
	    menubar = (SMenuWidget)current_menu->core.parent;
	    menubar->smenu.activated = FALSE;

	    XtEraseMenu(current_menu);
/*	    XUngrabServer(XtDisplay(current_menu));	*/

	    menubar->smenu.current_widget = NULL;

	    if (current_item && current_item->core.sensitive) {
		for (i = 0; i < submenu->composite.num_children; i++) {
		    if (submenu->composite.children[i] ==
					submenu->smenu.current_widget) {
			XtCallCallbacks(w, XtNcallback, i);
			break;
		    }
		}
	    }

	    current_menu->sbitmap.highlighted = FALSE;
	    RedisplayBitmapWidget(current_menu);
	}
	submenu->smenu.current_widget = NULL;
}

/********************************************************
*                                                       *
*       Drag                                            *
*                                                       *
********************************************************/

static void Drag(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
Cardinal *num_param;
{
        SMenuWidget mw = (SMenuWidget)w;
	SBitmapWidget current, new, child;
	ShellWidget shell;
	int x, y, i;

	if (mw->smenu.activated == FALSE) return;
	new = (SBitmapWidget)XtWindowToWidget(XtDisplay(w),
					event->xbutton.subwindow);

	current = (SBitmapWidget)(mw->smenu.current_widget);

	if (new && new == current) return;

	if (new == NULL &&
	    *num_param > 0 && !strcmp(param[0], "noGoAway"))
		return;

	if (current && current->core.sensitive) {
		current->sbitmap.highlighted = FALSE;
		RedisplayBitmapWidget(current);
	}

	current = new;
	mw->smenu.current_widget = (Widget)current;
	if (current) {
	    if (current->core.sensitive) {
		current->sbitmap.highlighted = TRUE;
		RedisplayBitmapWidget(current);
	    }
	} else {
	    shell = (ShellWidget)mw->core.parent;
	    if (!shell->shell.popped_up) return;
	    if (XtClass(shell) == popupWidgetClass) {
		current = (SBitmapWidget)shell->core.parent;
		mw = (SMenuWidget)current->core.parent;
		for (i = 0; i < mw->composite.num_children; i++) {
		    child = (SBitmapWidget)mw->composite.children[i];
		    XtTranslateCoords((Widget)child, 0, 0, &x, &y);
		    if (x < event->xbutton.x_root &&
			event->xbutton.x_root < x+child->core.width &&
			y < event->xbutton.y_root &&
			event->xbutton.y_root < y+child->core.height) {
			    if (child != current) {
				mw->smenu.current_widget = (Widget)child;

				XtEraseMenu(current);
				current->sbitmap.highlighted = FALSE;
				RedisplayBitmapWidget(current);

				child->sbitmap.highlighted = TRUE;
				RedisplayBitmapWidget(child);
				XtPullMenuDown(child);
			    }
			    return;
		    }
		}

	    }
	}
}

/********************************************************
*                                                       *
*       Notify                                          *
*                                                       *
********************************************************/

static void Notify(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
Cardinal *num_param;
{
	SMenuWidget mw = (SMenuWidget)w;
	SBitmapWidget current = (SBitmapWidget)mw->smenu.current_widget;
	int i;

	if (mw->smenu.activated && current->core.sensitive) {
	    for (i = 0; i < mw->composite.num_children; i++) {
		if ((Widget)current == mw->composite.children[i]) {
		    XtCallCallbacks(w, XtNcallback, i);
		    break;
		}
	    }
	}
}

/********************************************************
*							*
*	Cancel						*
*							*
********************************************************/

static void Cancel(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
Cardinal *num_param;
{
        SMenuWidget mw = (SMenuWidget)w;
	SBitmapWidget current, new;
	ShellWidget shell;

	new = (SBitmapWidget)XtWindowToWidget(XtDisplay(w),
					event->xbutton.subwindow);

	if (!new->core.sensitive) return;

	if (new && isSelected(mw, new)) {
	    new->sbitmap.highlighted = FALSE;
	    RedisplayBitmapWidget(new);
	    Unselect(mw, new);
	}
}

/********************************************************
*							*
*	Toggle						*
*							*
********************************************************/

static void Toggle(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
Cardinal *num_param;
{
        SMenuWidget mw = (SMenuWidget)w;
	SBitmapWidget current, new;
	ShellWidget shell;

	new = (SBitmapWidget)XtWindowToWidget(XtDisplay(w),
					event->xbutton.subwindow);

	if (!new->core.sensitive) return;

	if (new == NULL) return;

	if (isSelected(mw, new)) {
	    new->sbitmap.highlighted = FALSE;
	    RedisplayBitmapWidget(new);
	    Unselect(mw, new);
	} else {
	    new->sbitmap.highlighted = TRUE;
	    RedisplayBitmapWidget(new);
	    Select(mw, new);
	}
}

/********************************************************
*							*
*	Public Functions				*
*							*
********************************************************/

XtAppendMenuItems(w, items, num_items)
Widget w;
XtMenuItemList items;
int num_items;
{
    SMenuWidget mw = (SMenuWidget)w;
    int i;

    for (i = 0; i < num_items; i++) {
	items[i].widget = XtCreateManagedWidget(items[i].name,
				items[i].class, mw,
				items[i].args, items[i].num_args);
    }
}
