/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SMenuP.h,v 1.1 88/08/20 09:06:50 michael Exp $ Sony Corporation
 *
 * $Log:	SMenuP.h,v $
 * Revision 1.1  88/08/20  09:06:50  michael
 * Initial revision
 * 
 */
/********************************************************
*							*
*	Private header for Sony Menu widget		*
*							*
*	Written by M.abe				*
*							*
********************************************************/

#ifndef _XtSMenuPrivate_h
#define _XtSMenuPrivate_h

#include "X11/SMenu.h"

/********************************************************
*							*
*	Sony Menu Widget Private Data			*
*							*
 *******************************************************/

/* New fields for the Menu widget class record */
typedef struct {
     int mumble;   /* No new procedures */
} SMenuClassPart;

/* Full class record declaration */
typedef struct _SMenuClassRec {
    CoreClassPart	core_class;
    CompositeClassPart  composite_class;
    SMenuClassPart	smenu_class;
} SMenuClassRec;

extern SMenuClassRec sMenuClassRec;

/* New fields for the Menu widget record */
typedef struct {
	/* resources */
	Dimension	columns;
	Dimension	rows;
	WidgetList	select_list;
	int		num_select;
	XtCallbackList	callbacks;
	int		flash;
	XtMenuItemList  items;
	int 		num_items;
	Cursor		cursor;

	/* private status */
	Boolean		activated;
	int		*max_width;
	int		*max_height;
	int		max_border_width;
	XImage		*save_image;
	Time		last_selected_time;
	Widget		current_widget;	
} SMenuPart;

/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _SMenuRec {
    CorePart	    core;
    CompositePart   composite;
    SMenuPart	    smenu;
} SMenuRec;

#endif _XtSMenuPrivate_h
/* DON'T ADD STUFF AFTER THIS #endif */
