#ifndef lint
static char rcsid[] = "$Header: SPDMenu.c,v 1.1 88/08/20 09:06:30 michael Locked $ Sony Corporation";
#endif lint
/*
 * $Log:	SPDMenu.c,v $
 * Revision 1.1  88/08/20  09:06:30  michael
 * Initial revision
 * 
 */

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/********************************************************
*							*
*	Sony PullDown Menu Widget			*
*							*
*	Written by M.Abe				*
*							*
********************************************************/

/********************************************************
*							*
*	Include definition				*
*							*
********************************************************/

#include <stdio.h>
#include <ctype.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Misc.h>
#include <X11/Shell.h>
#include <X11/ShellP.h>
#include <X11/Cascade.h>

#include <X11/SBitmapP.h>
#include <X11/SMenuP.h>

#include <X11/SPDMenu.h>
#include <X11/SPDMenuP.h>

/********************************************************
*							*
*	Private procedure definitions			*
*							*
********************************************************/

static	void	ClassInitialize();
static	void	Initialize();
static	void	Realize();
static	void	Resize();
static	void	Redisplay();
static	Boolean	SetValues();
static	void	Destroy();

/********************************************************
*							*
*	Full class record constant			*
*							*
********************************************************/

static XtResource resources[] = { 
   {XtNpullDownCallback, XtCCallback, XtRCallback, sizeof(caddr_t),
	XtOffset(SPDMenuWidget, spdmenu.callbacks), XtRCallback,
	(caddr_t)NULL},
   {XtNnumItems, XtCNumItems, XtRInt, sizeof(int),
	XtOffset(SPDMenuWidget, spdmenu.num_items), XtRString, "0"},
   {XtNitems, XtCItems, XtRPointer, sizeof(caddr_t),
	XtOffset(SPDMenuWidget, spdmenu.items), XtRPointer, NULL},
   {XtNshellWidget, XtCShellWidget, XtRPointer, sizeof(Widget),
	XtOffset(SPDMenuWidget, spdmenu.shell), XtRPointer, NULL},
   {XtNmenuWidget, XtCMenuWidget, XtRPointer, sizeof(Widget),
	XtOffset(SPDMenuWidget, spdmenu.menu), XtRPointer, NULL},
};  

SPDMenuClassRec sPDMenuClassRec = {
  {
    (WidgetClass) &sBitmapClassRec,	/* superclass		*/
    "SPDMenu",				/* class_name		*/
    sizeof(SPDMenuRec),			/* size			*/
    NULL,				/* class initialize	*/
    ClassInitialize,			/* class_part_initialize*/
    FALSE,				/* class_inited		*/
    Initialize,				/* initialize		*/
    NULL,				/* initialize_hook	*/
    XtInheritRealize,			/* realize		*/
    NULL,				/* actions		*/
    0,					/* num_actions		*/
    resources,                          /* resources	        */
    XtNumber(resources),                /* resource_count	*/
    NULLQUARK,                          /* xrm_class	        */
    FALSE,				/* compress_motion	*/
    TRUE,
    TRUE,
    FALSE,				/* visible_interest	*/
    Destroy,				/* destroy		*/
    XtInheritResize,			/* resize		*/
    XtInheritExpose,			/* expose		*/
    SetValues,				/* set_values		*/
    NULL,				/* set_values_hook	*/
    XtInheritSetValuesAlmost,		/* set_values_almost	*/
    NULL,				/* get_values_hook	*/
    NULL,				/* accept_focus		*/
    XtVersion,                          /* version		*/
    NULL,                               /* callback_private	*/
    NULL,		                /* tm_table		*/
    NULL,                               /* query_geometry	*/
  },  /* CoreClass fields initialization */
  {
    Redisplay,					/* redisplay */
  },  /* SBitmapClass fields initialization */
  {
    0,                                     /* field not used    */
  },  /* SPDMenuClass fields initialization */
};

  /* for public consumption */
WidgetClass sPDMenuWidgetClass = (WidgetClass) &sPDMenuClassRec;

static char xltbl[] =
	"<EnterWindow>: set() \n\
	 <LeaveWindow>: drag() \n\
	 <Btn1Up>: unset1(goAway) \n\
	 <Btn1Motion>: drag()";

static void callback_proc(w, closure, callData)
Widget w;
caddr_t closure;
caddr_t callData;
{
    Widget parent;

    parent = w->core.parent;		/* shell widget */
    parent = parent->core.parent;	/* this widget */
    XtCallCallbacks(parent, XtNpullDownCallback, callData);
}

static XtCallbackRec callbacks[] =
    {{callback_proc, NULL}, {NULL, NULL}};

/********************************************************
*							*
*	Private Procedures				*
*							*
********************************************************/

/********************************************************
*							*
*	Class Initialize				*
*							*
********************************************************/

static void ClassInitialize(widgetClass)
WidgetClass;
{
} 

/********************************************************
*							*
*	Initialize					*
*							*
********************************************************/

static void Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;
Cardinal num_args;
{
    SPDMenuWidget pdmw =(SPDMenuWidget)new;
    SPDMenuWidget req = (SPDMenuWidget)request;
    char *shell_name;
    char *menu_name;
    int len, i;
    Arg arg[3];
    XtMenuItemList items;

    len = strlen(pdmw->core.name) + 1;
    shell_name = (char *)malloc(len + 11);
    strcpy(shell_name, pdmw->core.name);
    strcat(shell_name, "_menu_shell");
    arg[0].name = XtNallowShellResize;
    arg[0].value = TRUE;
    arg[0].name = XtNsaveUnder;
    arg[0].value = TRUE;
    pdmw->spdmenu.shell = XtCreatePopupShell(
				shell_name, popupWidgetClass, pdmw,
				(ArgList)arg, 2);
    free(shell_name);

    menu_name = (char *)malloc(len + 5);
    strcpy(menu_name, pdmw->core.name);
    strcat(menu_name, "_menu");
    arg[0].name = XtNtranslations;
    arg[0].value = (XtArgVal)XtParseTranslationTable(xltbl);
    arg[1].name = XtNcallback;
    arg[1].value = (XtArgVal)callbacks;
    arg[2].name = XtNrows;
    arg[2].value = pdmw->spdmenu.num_items;
    pdmw->spdmenu.menu = XtCreateWidget(menu_name, sMenuWidgetClass,
				pdmw->spdmenu.shell, (ArgList)arg, 2); 
    free(menu_name);

    items = pdmw->spdmenu.items;
    for (i = 0; i < pdmw->spdmenu.num_items; i++) {
	items[i].widget = XtCreateManagedWidget(items[i].name,
				sBitmapWidgetClass, pdmw->spdmenu.menu,
				items[i].args, items[i].num_args);
    }
    XtRealizeWidget(pdmw->spdmenu.shell);
} 

/********************************************************
*							*
*	Realize						*
*							*
********************************************************/

static void Realize(w, valueMask, attributes) 
register Widget w;
Mask valueMask;
XSetWindowAttributes *attributes;
{
} 

/********************************************************
*							*
*	Destroy						*
*							*
********************************************************/

static void Destroy(w)
Widget w;
{
	/* must free GCs and pixmaps */
}

/********************************************************
*							*
*	Resize						*
*							*
********************************************************/

static void Resize(w)
Widget	w;
{
}

/********************************************************
*							*
*	Redisplay					*
*							*
*********************************************************/

static void Redisplay(w, event)
Widget w;
XEvent *event;
{
	SPDMenuWidget pdmw = (SPDMenuWidget)w;

	(*((SBitmapWidgetClass)XtSuperclass(w))->sbitmap_class.redisplay)(w, event);
}

/********************************************************
*							*
*	Set Value					*
*							*
*********************************************************/

static Boolean SetValues (current, request, new, last)
Widget current, request, new;
Boolean last;
{
    SPDMenuWidget cur = (SPDMenuWidget) current;
    SPDMenuWidget req = (SPDMenuWidget) request;
    SPDMenuWidget bw = (SPDMenuWidget) new;

    return(FALSE);
}

/********************************************************
*							*
*	Public Functions				*
*							*
********************************************************/

/********************************************************
*							*
*	Pull menu down					*
*							*
********************************************************/

void XtPullMenuDown(pdmw)
SPDMenuWidget pdmw;
{
	ShellWidget shell;
	SMenuWidget mw;
	int x, y;

	shell = (ShellWidget)pdmw->core.popup_list[0];
	XtTranslateCoords(pdmw, 0, pdmw->core.height, &x, &y);
	if (x < 0) x = 0;
	if (x + shell->core.width + shell->core.border_width * 2 >
		DisplayWidth(XtDisplay(shell), 0)) {
	    x = DisplayWidth(XtDisplay(shell), 0) -
		shell->core.width - shell->core.border_width * 2;
	}
	if (y < 0) y = 0;
	if (y + shell->core.height + shell->core.border_width * 2 >
		DisplayHeight(XtDisplay(shell), 0)) {
	    y = DisplayHeight(XtDisplay(shell), 0) -
		shell->core.height - shell->core.border_width * 2;
	}
	XtMoveWidget(shell, x, y);

	mw = (SMenuWidget)shell->composite.children[0];
/*
	mw->smenu.save_image =
		XGetImage(XtDisplay(mw),
		    RootWindowOfScreen(XtScreen(mw)),
		    shell->core.x, shell->core.y,
		    shell->core.width + shell->core.border_width * 2,
		    shell->core.height + shell->core.border_width * 2,
		    AllPlanes, XYPixmap);
*/
	_XtPopup(shell, XtGrabExclusive, TRUE);
	XSync(XtDisplay(shell), 0);
	XGrabPointer(XtDisplay((Widget)mw),
		XtWindow((Widget)mw), FALSE,
		ButtonReleaseMask|PointerMotionMask,
		GrabModeAsync, GrabModeAsync,
		None, mw->smenu.cursor, CurrentTime);
	XGrabServer(XtDisplay(pdmw));
}

/********************************************************
*							*
*	Erase menu					*
*							*
********************************************************/

void XtEraseMenu(pdmw)
SPDMenuWidget pdmw;
{
	ShellWidget shell;
	GC gc;
	SMenuWidget mw;

	shell = (ShellWidget)pdmw->core.popup_list[0];

	mw = (SMenuWidget)shell->composite.children[0];

	XtPopdown(shell);
/*
	gc = XCreateGC(XtDisplay(shell),
		RootWindowOfScreen(XtScreen(shell)),
		0L, NULL);
	XSetSubwindowMode(XtDisplay(shell), gc, IncludeInferiors);
	XPutImage(XtDisplay(shell),
		RootWindowOfScreen(XtScreen(shell)),
		gc, mw->smenu.save_image, 0, 0,
		shell->core.x, shell->core.y,
		shell->core.width + shell->core.border_width * 2,
		shell->core.height + shell->core.border_width * 2);
	XtFree(mw->smenu.save_image);
	XFreeGC(XtDisplay(shell), gc);
	XSync(XtDisplay((Widget)pdmw), 1);
*/
	XUngrabPointer(XtDisplay((Widget)pdmw), CurrentTime);
	XUngrabServer(XtDisplay(pdmw));
}

/********************************************************
*							*
*	Append PDMenu Items				*
*							*
********************************************************/

XtAppendPDMenuItems(parent, items, num_items)
Widget parent;
XtMenuItemList items;
int num_items;
{
    extern void XtAppenMenuItems();
    int i;

    SPDMenuWidget pdmw = (SPDMenuWidget)parent;
    for (i = 0; i < num_items; i++)
	items[i].class = sBitmapWidgetClass;
    XtAppendMenuItems(pdmw->spdmenu.menu, items, num_items);
}

/********************************************************
*							*
*	Menu Short Cut					*
*							*
********************************************************/

Boolean XtMenuShortCut(pdmw, charcode)
SPDMenuWidget pdmw;
int charcode;		/* Caped alpha and numeric */
{
    CompositeWidget shell;
    CompositeWidget menu;
    SBitmapWidget item;
    char *label;
    int i;

    shell = (CompositeWidget)pdmw->core.popup_list[0];
    menu = (CompositeWidget)shell->composite.children[0];
    for (i = 0; i < menu->composite.num_children; i++) {
	item = (SBitmapWidget)menu->composite.children[i];
	label = item->sbitmap.right_label;
	if (label) {
	    if (*(label + 1) == charcode) {
		pdmw->sbitmap.highlighted = TRUE;
		(*((SBitmapWidgetClass)XtSuperclass(pdmw))->sbitmap_class.redisplay)(pdmw, NULL);
		XSync(XtDisplay(pdmw), 0);
		XtCallCallbacks(menu, XtNcallback, i);

		pdmw->sbitmap.highlighted = FALSE;
		(*((SBitmapWidgetClass)XtSuperclass(pdmw))->sbitmap_class.redisplay)(pdmw, NULL);
		XSync(XtDisplay(pdmw), 0);
		return(TRUE);
	    }
	}
    }
    return(FALSE);
}
