/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SScrollP.h,v 1.1 88/08/20 09:06:55 michael Exp $ Sony Corporation
 *
 * $Log:	SScrollP.h,v $
 * Revision 1.1  88/08/20  09:06:55  michael
 * Initial revision
 * 
 */

/****************************************************************
 *
 * The Private Header File for SScroll Widget by SONY
 *
 ****************************************************************/

typedef struct {
     /* public */
    XtCallbackList callbacks;		/* scroll callback list */
    XtScrollOrientation  orientation;	/* scroll orientation */
    Boolean	  point_mode;		/* point scroll mode */
    Boolean	  thumb_fix;		/* thumb len fix mode */
    Boolean	  inactive;		/* inactive mode */
    Boolean	  button_side;		/* button side loc */
    Boolean	  hide_resthumb;	/* hide resident thumb */
    Boolean	  button_raw;		/* scroll button raw mode */
    Boolean	  bar_raw;		/* scroll bar raw mode */
    Boolean	  thumb_raw;		/* scroll thumb raw mode */
    int		  interval_time;	/* repeat interval time */
    Log_Position  position[2];		/* logical start position */  
    Log_Position  min[2];		/* logical minimum position */  
    Log_Position  max[2];		/* logical maximum position */  
    Log_Volume	  shown[2];		/* logical shown volume */  
    Log_Volume	  smooth[2];		/* logical smooth volume */  
    Dimension	  thumb_len[2];		/* thumb length */
    Dimension	  button_len[2];	/* scroll button area length */  
    XtHotSpot	  hot_spot;		/* hot spot position */
     /* private */
    unsigned long status[2];
    XtIntervalId  interval_id;		/* interval id */
    Widget	  widget_btn_minus[2];	/* minus dir. scroll button widget */
    Widget	  widget_btn_plus[2];	/* plus dir. scroll button widget */
    Widget	  widget_bar;		/* scroll bar widget */
    Widget	  widget_thumb;		/* scroll thumb widget */
    Widget	  widget_thumbshade;	/* scroll thumbshade widget */
    Log_Volume	  whole[2];		/* logical whole volume */
    Log_Position  offset[2];		/* logical current position offset */
    Position	  cur_loc[2];		/* current top location of thumb */
    Dimension	  bar_len[2];		/* scroll bar length */
    Position	  bar_pos[2];		/* scroll bar position */
    Position	  cur_pull[2];		/* thumb pull current position */
    Dimension	  off_pull[2];		/* thumb pull offset from top */
    unsigned	  barevent;		/* save bar event type */
    Position	  barpossav[2];		/* save position in bar*/
} SScrollPart;

typedef struct _SScrollRec {
    CorePart		core;
    CompositePart	composite;
    SScrollPart	sscroll;
} SScrollRec;

typedef struct {
     /* no new procedures */
    int dummy;
} SScrollClassPart;

typedef struct _SScrollClassRec {
    CoreClassPart		core_class;
    CompositeClassPart		composite_class;
    SScrollClassPart		sscroll_class;
} SScrollClassRec;

#define	SCR_IDLE		0L
#define	SCR_THUMBPULL		(1L<<0)
#define	SCR_THUMBPULLDE		(1L<<1)
/* end */
