/*
 * $Header: STextP.h,v 1.1 88/08/20 09:07:00 michael Exp $ Sony Corporation
 *
 * $Log:	STextP.h,v $
 * Revision 1.1  88/08/20  09:07:00  michael
 * Initial revision
 * 
 */
/***********************************************************
 *                                                         *
 *   Sony Text widget private definition                   *
 *	Copyright (c) 1988 Sony Corp.                      *
 *                                                         *
 *    Original: TextP.h by DEC, M.I.T.                     *
 *    Modified: by Sony Corp.                              *
 *                                                         *
 ***********************************************************/

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifndef _XtSTextP_h
#define _XtSTextP_h


#include "SText.h"
#include <X11/CoreP.h>
#include <X11/SimpleP.h>

/****************************************************************
 *
 * SText widget private
 *
 ****************************************************************/
#define MAXCUT	30000	/* Maximum number of characters that can be cut. */

#define LF	0x0a
#define CR	0x0d
#define TAB	0x09
#define BS	0x08
#define SP	0x20
#define DEL	0x7f
#define BSLASH	'\\'

#define EditDone 0
#define EditError 1
#define PositionError 2

#define NameLen 255

/* constants that subclasses may want to know */
#define DEFAULT_TEXT_HEIGHT ~0
#define  yMargin 2

typedef enum {XtsdLeft, XtsdRight} XtTextScanDirection;
typedef enum {XtstPositions, XtstWhiteSpace, XtstEOL, XtstParagraph, XtstAll}
    XtTextScanType;

/* the data field is really a pointer to source info, see disk and 
   stream sources in TextKinds.c */

typedef struct _XtTextSource {
    int			(*Read)();
    int			(*Replace)();
    XtTextPosition	(*GetLastPos)();
    int			(*SetLastPos)();
    int			(*GetLinePos)();
    XtTextPosition	(*Scan)();
    void		(*AddWidget)( /* source, widget */ );
    void		(*RemoveWidget)( /* source, widget */ );
    void		(*SetSelection)( /* source, left, right */);
    Boolean		(*GetSelection)( /* source, left, right */);
    XtTextEditType	edit_mode;
    caddr_t		data;	    
    };

typedef struct _XtTextSink {
    XFontStruct	*font;
    int foreground;
    int (*Display)();
    int (*InsertCursor)();
    int (*ClearToBackground)();
    int (*FindPosition)();
    int (*FindDistance)();
    int (*Resolve)();
    int (*MaxLines)();
    int (*MaxHeight)();
    caddr_t data;
    };

/* displayable text management data structures */

typedef struct {
    XtTextPosition position;
    Position x, y, endX;
    } XtTextLineTableEntry, *XtTextLineTableEntryPtr;

/* Line Tables are n+1 long - last position displayed is in last lt entry */
typedef struct {
    XtTextPosition	 top;	/* Top of the displayed text.		*/
    int			 lines;	/* How many lines in this table.	*/
    XtTextLineTableEntry *info;	/* A dynamic array, one entry per line  */
    } XtTextLineTable, *XtTextLineTablePtr;

typedef enum {XtisOn, XtisOff} XtTextInsertState;

typedef enum {XtsmTextSelect, XtsmTextExtend} XtTextSelectionMode;

typedef enum {XtactionStart, XtactionAdjust, XtactionEnd}
    XtTextSelectionAction;

typedef struct {
    XtTextPosition left, right;
    XtTextSelectType type;
} XtTextSelection;

#define IsPositionVisible(ctx, pos) \
		(pos >= ctx->text.lt.info[0].position && \
		 pos <= ctx->text.lt.info[ctx->text.lt.lines].position)

/* Private Text Definitions */

typedef int (*ActionProc)();

/* New fields for the SText widget class record */

typedef struct {int empty;} STextClassPart;

/* Full class record declaration */
typedef struct _STextClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    STextClassPart	text_class;
} STextClassRec;

extern STextClassRec sTextClassRec;

/* New fields for the Text widget record */
typedef struct _STextPart {
    /* resources */
    XtTextSource	source;
    XtTextSink		sink;
    XtTextPosition	insertPos;
    XtTextSelection	s;
    XtTextSelectType	*sarray;	   /* Array to cycle for selections. */
    Dimension		client_leftmargin;   /* client-visible resource */
    int			options;	     /* wordbreak, scroll, etc. */
    int			dialog_horiz_offset; /* position for popup dialog */
    int			dialog_vert_offset;  /* position for popup dialog */
    /* added by M. Ono */
    XtCallbackList      callbacks;
    XtCallbackList      scroll_callbacks;
    XtCallbackList      shortcut_callbacks;
    Boolean		show_insert_cursor;
    /* private state */
    XtTextLineTable	lt;
    XtTextScanDirection extendDir;
    XtTextSelection	origSel;    /* the selection being modified */
    Dimension	    leftmargin;	    /* Width of left margin. */
    Time	    lasttime;	    /* timestamp of last processed action */
    Time	    time;	    /* time of last key or button action */ 
    Position	    ev_x, ev_y;	    /* x, y coords for key or button action */
    XtTextPosition  *updateFrom;    /* Array of start positions for update. */
    XtTextPosition  *updateTo;	    /* Array of end positions for update. */
    int		    numranges;	    /* How many update ranges there are. */
    int		    maxranges;	    /* How many ranges we have space for */
    Boolean	    showposition;   /* True if we need to show the position. */
    XtTextPosition  lastPos;	    /* Last position of source. */
    Widget	    dialog;	    /* Dialog Widget */
    Widget	    alt_dialog;	    /* Alert dialog Widget */
    char	    file_name[NameLen];  /* Dialog Insert file name */
    GC              gc;
    Boolean         hasfocus;       /* TRUE if we currently have input focus.*/
    Boolean	    update_disabled; /* TRUE if display updating turned off */
    /* added by M. Ono */
    int		    currentLine;    /* Current top line */
    int		    lastLine;	    /* Last Line */
    int		    modified_count; /* Counts of text modification */
} STextPart;

/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _STextRec {
    CorePart	core;
    SimplePart	simple;
    STextPart	text;
} STextRec;


#endif _XtSTextP_h
