/*
.nf
 *                            Xw.c
 *
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *
 *		        Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP. MASSCOMP MAKES
 * NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
 * PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */
 
/*
 * Xw.c - X Window Widget hack
 *
 * This provides an X Window Widget for use within the XToolkit.
 * Since it has it's own class, it can be tested for and
 * extracted from deep heirarchies without requiring it's name,
 * if it is the only widget of its class in the hierarchy.
 * This is very useful when it is part of a heirarchy which is
 * loaded from disk (unpickled). When you create all your widgets
 * at run time, this is not usually a necessary routine since
 * you get to meet each widget you may need when you create them.
 *
 * This Simple Widget is also nice because it passes the event
 * structure back to the callback routine so that the callback
 * routine has virtually unlimited control of what to do through
 * just one routine.
 * New events can be added by XtAddEventHandler() or by
 * just adding them to the code below.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "XwP.h"

static void Notify();
static void Resize();
static void Redisplay();

/*
 * Full class record constant
 */

/* Private Data */

static char defaultTranslations[] =
    "<Btn1Down>:         notify() \n\
     <Btn1Motion>:       notify() \n\
     <Btn1Up>:           notify() \n\
     <EnterWindow>:      notify() \n\
     <LeaveWindow>:      notify()";

static int defHighlight = 2;
static XtResource resources[] = { 

  {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t), 
    XtOffset(XwWidget, xw.callbacks), XtRCallback, (caddr_t)NULL},
  {XtNhighlightThickness, XtCThickness, XtRInt, sizeof(Dimension),
    XtOffset(XwWidget,xw.highlight_thickness), XtRInt, (caddr_t)&defHighlight},
 };  

static XtActionsRec actionsList[] =
{
  {"notify",		Notify},
};

XwClassRec xwClassRec = {
  {
    (WidgetClass) &widgetClassRec,          /* superclass	*/    
    "Xw",                                  /* class_name	*/
    sizeof(XwRec),                         /* size		*/
    NULL,                                  /* class initialize  */
    NULL,	  			   /* class_part_initialize  */
    FALSE,                                 /* class_inited      */
    NULL,				   /* initialize_hook	  */
    NULL,                                  /* initialize	*/
    XtInheritRealize,                      /* realize		*/
    actionsList,                           /* actions		*/
    XtNumber(actionsList),                 /* num_actions	*/
    resources,                             /* resources	        */
    XtNumber(resources),                   /* resource_count	*/
    NULLQUARK,                             /* xrm_class	        */
    FALSE,                                 /* compress_motion	*/
    FALSE,                                 /* compress_exposure	*/
    TRUE,				   /* compress_enterleave    */
    FALSE,                                 /* visible_interest	*/
    NULL,	                           /* destroy		*/
    Resize,                                /* resize		*/
    Redisplay,     	                   /* expose		*/
    NULL,               	           /* set_values	*/
    NULL,				   /* set_values_hook	  */
    XtInheritSetValuesAlmost,		   /* set_values_almost	  */
    NULL,				   /* get_values_hook	  */
    NULL,                                  /* accept_focus	*/
    XtVersion,				   /* version		  */
    NULL,                                  /* callback_private	*/
    defaultTranslations,		   /* tm_table		  */
    NULL,				   /* query_geometry	  */
  },  /* CoreClass fields initialization */
  {
    0,                                     /* field not used    */
  },  /* XwClass fields initialization */
};

  /* for public consumption */

WidgetClass xwWidgetClass = (WidgetClass) &xwClassRec;

/*
 *  Routines to implement this X Window Widget 
 */

static void Resize( w )
Widget w;
{
  XtCallCallbacks( w, XtNcallback, NULL );
}


static void Notify( w, event, params, num_params )
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
  XtCallCallbacks( w, XtNcallback, event );
}

static void Redisplay( w, event, region )
Widget w;
XEvent *event;
Region region;		/* unused */
{
  XtCallCallbacks( w, XtNcallback, event );
}

/*
 *    that's all folks! 
 */
