/*
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		       Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP CORPORATION.
 * MASSCOMP MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */
/*
.nf
*/
/*
 *	user interface support for paint via X11 Toolkit
 */


#include <stdio.h>
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Command.h>
#include <X11/Form.h>
#include <X11/Xos.h>
#include <X11/TextP.h>
#include <X11/Dialog.h>


#define	RESPONSE_LEN	20
char	response[RESPONSE_LEN];
extern WidgetClass labelWidgetClass;
extern WidgetClass commandWidgetClass;
extern WidgetClass boxWidgetClass;
extern WidgetClass DLobedientWidgetClass;

extern Display *toplevelDisplay;
extern Window work_area_window;
extern Widget workarea;
	
extern Widget toplevel;
extern int max_colors;
extern int color_display;
extern int cur_color;
extern GC gc;

Widget XtInitialize();
Widget XtInitializeInWindow();


void callback(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
 (void) fprintf(stderr,"xcommand callback\n");
  XtDestroyWidget(toplevel);
  exit(0);
}

extern void make_toplevel_obedient_cmd();

extern void make_obedient_cmd();
extern void make_command_cmd();
extern void make_label_cmd();

extern void load_widget_cmd();
extern void save_widget_cmd();
extern void copy_widget_cmd();
extern void move_widget_cmd();
extern void copy_widget_cmd();
extern void resize_widget_cmd();
extern void rename_widget_cmd();
extern void delete_widget_cmd();

extern void recallback_widget_cmd();
extern void relabel_widget_cmd();

extern void line_cmd();
extern void linerect_cmd();
extern void linefrect_cmd();
extern void rectangle_cmd();
extern void filled_rectangle_cmd();
extern void color_handler();
extern void text_cmd();
extern void color_cmd();
extern void exit_cmd();

static XrmOptionDescRec options[] = {
{"-label",	XtNlabel,	XrmoptionSepArg,	NULL}
};


/*
	top_level_window is the window the application wants
	the XToolkit to view as the top level rootWindow
 */

load_uims( toplevel )
Widget toplevel;
{
    Widget ascii_load_widgets();
    unsigned int mask;

    /*
     * register all our exposed (to the user interface, e.g. XToolkit)
     * routines from the application
     */
    
    XtRegisterFtn( line_cmd, "line_cmd" );
    XtRegisterFtn( linerect_cmd, "linerect_cmd" );
    XtRegisterFtn( linefrect_cmd, "linefrect_cmd" );
    XtRegisterFtn( rectangle_cmd, "rectangle_cmd" );
    XtRegisterFtn( filled_rectangle_cmd, "filled_rectangle_cmd" );
    XtRegisterFtn( text_cmd, "text_cmd" );
    XtRegisterFtn( exit_cmd, "exit_cmd" );
    XtRegisterFtn( color_handler, "color_handler" );
    
    
    XtRegisterFtn( make_toplevel_obedient_cmd, "make_toplevel_obedient_cmd" );
    XtRegisterFtn( make_obedient_cmd, "make_dlobedient_cmd" );
    XtRegisterFtn( make_command_cmd,  "make_dlcommand_cmd" );
    XtRegisterFtn( make_label_cmd,    "make_dllabel_cmd" );
    XtRegisterFtn( make_obedient_cmd, "make_obedient_cmd" );
    XtRegisterFtn( make_command_cmd,  "make_command_cmd" );
    XtRegisterFtn( make_label_cmd,    "make_label_cmd" );
    
    XtRegisterFtn( load_widget_cmd,   "load_widget_cmd" );
    XtRegisterFtn( save_widget_cmd,   "save_widget_cmd" );
    XtRegisterFtn( copy_widget_cmd,   "copy_widget_cmd" );
    XtRegisterFtn( move_widget_cmd,   "move_widget_cmd" );
    XtRegisterFtn( resize_widget_cmd, "resize_widget_cmd" );
    XtRegisterFtn( rename_widget_cmd, "rename_widget_cmd" );
    XtRegisterFtn( delete_widget_cmd, "delete_widget_cmd" );
    XtRegisterFtn( copy_widget_cmd,   "copy_widget_cmd" );
    XtRegisterFtn( recallback_widget_cmd, "recallback_widget_cmd" );
    XtRegisterFtn( relabel_widget_cmd, "relabel_widget_cmd" );


    /* this tells the toolkit which directory the widgets are in */
    
    XtUseDirectory( "./widgets" );
    
    /* now load our user interface from disk */
				
    if (toplevel) {
	ascii_load_widgets( "obedient", toplevel );
	XtRealizeWidget( toplevel );
    } else {
	fprintf(stderr, "No TopLevel Widget passed to load_uims();\n");
	exit();
    }
    /*
     * here we use a private routine to get our event mask, 
     * 	expose it you guys (or give us a replacement)
     */
    mask = XtBuildEventMask( toplevel ); 
    XFlush( XtDisplay( toplevel ) );
    return mask;
}


static int dialog_in_progress = 0;
Widget text_input_popup = NULL;
Widget dialog = NULL;
Widget dbutton1 = NULL;
Widget dbutton2 = NULL;

static char text_response[256];

char *input_text( prompt ) char *prompt;
{
	Arg arglist[12];
	Cardinal num_args, len;
	XEvent event;
	XFontStruct *font;
	XtTextBlock text_block;
	char *str;
	
	dialog_in_progress = 1;
	if (!text_input_popup) create_text_input();
	
	text_response[0] = 0;
	if ( text_input_popup ) {
	        font = XLoadQueryFont( XtDisplay(toplevel), "vg-20" );
		if (font) { 
		  num_args = 0;
		  XtSetArg( arglist[num_args],XtNfont, font ); num_args++;
		  XtSetValues( dbutton1, arglist, num_args);
		  XtSetValues( dbutton2, arglist, num_args);
		}
		if (prompt) { 
		  num_args = 0;
		  XtSetArg( arglist[num_args],XtNlabel, prompt ); num_args++;
		  XtSetValues( XtNameToWidget( dialog, "label"), arglist, num_args );
		}
		text_block.firstPos = 0;
		text_block.length = 3;
		text_block.ptr = "new";

printf("clearing dialog field\n");
clear_dialog_field( dialog );
printf("dialog field cleared\n");
/*
		len = strlen(XtDialogGetValueString( dialog ));

		if (len > 0) XtTextReplace(XtNameToWidget( dialog, "value") , 0, len, &text_block);
*/
/*	gee, this would be nice if it worked 
		Change_Text( XtNameToWidget( dialog, "value"), "" );
*/

                XtSetKeyboardFocus( dialog, XtNameToWidget( dialog, "value" ));
		XtPopup( text_input_popup, XtGrabExclusive );  /* not getting the keyboard */
        } else {
	  printf("No text_input_popup widget\n");
	  return NULL;
	}
	XSync(XtDisplay(text_input_popup), 1);

	do {
		if(XPending( toplevelDisplay ) ) {
			XtNextEvent( &event );
			XtDispatchEvent( &event );
		}
	} while( dialog_in_progress );
	str = XtDialogGetValueString( dialog );
	if (str) printf("String is: <%s>\n", str );
	if (text_input_popup) XtPopdown( text_input_popup );
	strcpy( text_response, str );
	return text_response;
}


/* we must be passed a dialog box widget */

clear_dialog_field( w )
Widget w;
{
    TextWidget ctx;

    XtTextBlock text;

    Arg args[2];
    static XtCallbackRec callbacks[] = { {NULL, NULL}, {NULL, NULL} };
    int x, y;
    Window j;


    w = XtNameToWidget( w, "value");
    ctx  = (TextWidget) w;

    if (ctx->text.source->edit_mode != XttextEdit) {
	XBell(XtDisplay(w), 50);
	return;
    }
    if (ctx->text.s.left < ctx->text.s.right) {
	_XtTextGetText(ctx, ctx->text.s.left, ctx->text.s.right);
/*	DeleteCurrentSelection(ctx, (XEvent*)NULL); */

	text.ptr = "Replacement";
	text.length = strlen(text.ptr);
	(void) XtTextReplace(ctx, ctx->text.insertPos, ctx->text.insertPos, &text);
	ctx->text.s.left = ctx->text.insertPos;
	ctx->text.s.right = ctx->text.insertPos = strlen( text.ptr );
      }
  }




Change_Text( widget, str )
Widget widget; char *str;
{
    static Arg arglist[] = {
	{XtNtextSource, (XtArgVal) NULL}
    };
    Arg arglist2[3];
    XtTextSource source;

    arglist[0].value = (XtArgVal)&source;
    XtGetValues( widget, arglist, XtNumber(arglist));
    XtStringSourceDestroy( source );
    XtSetArg( arglist2[0], XtNstring, str );
    XtSetArg( arglist2[1], XtNeditType, XttextEdit );
/*    XtSetArg( arglist2[1], XtNlength, 30 ); */
    source = XtStringSourceCreate( widget, arglist2, XtNumber(arglist2) );
    XtTextSetSource( widget, source, (XtTextPosition) 0 );
}

void dialog_ok()
{
	dialog_in_progress = 0;
}

void dialog_cancel()
{
	dialog_in_progress = 0;
}


char *default_name = "unnamed";

create_text_input()
{
	Arg arglist[12];
	Cardinal num_args, center_x, center_y;
	Widget box, label;
	Widget button1, button2, button3, button4;
	XFontStruct *font;
	static XtCallbackRec callback[] = {
		{ NULL, NULL },
		{ NULL, NULL },
	};
	
    static Arg popup_args[] = {
	{XtNallowShellResize, True},
	{XtNsaveUnder, True},
    };


	if (text_input_popup != NULL) return;
	
	num_args = 0;
	XtSetArg( arglist[num_args],XtNallowShellResize, TRUE ); num_args++;

	center_x = workarea->core.x + (workarea->core.width / 2.);
	center_y = workarea->core.y + (workarea->core.height / 2.);
	XtSetArg( arglist[num_args],XtNx, center_x - 100 ); num_args++;
	XtSetArg( arglist[num_args],XtNy, center_y - 54 ); num_args++;
	font = XLoadQueryFont( XtDisplay( toplevel ), "vg-20" );
	XtSetArg( arglist[num_args],XtNfont, font ); num_args++;

	text_input_popup = XtCreatePopupShell( "Text Input",
				     transientShellWidgetClass,
 				     toplevel, arglist, num_args );
		
	if (!text_input_popup) {
		printf("Popup Holder creation failed\n"); 
		exit(); 
	}
	num_args = 0;
	XtSetArg( arglist[num_args],XtNlabel, (XtArgVal)"--------------Title------------:" ); num_args++;
	XtSetArg( arglist[num_args], XtNvalue, (XtArgVal)""); num_args++;
	XtSetArg( arglist[num_args],XtNfont, font ); num_args++;

	XtSetArg( arglist[num_args], XtNmaximumLength, (XtArgVal)RESPONSE_LEN-1); num_args++;

	dialog = XtCreateManagedWidget("Dialog Box", dialogWidgetClass, 
			text_input_popup, arglist, num_args );
			
	XtSetKeyboardFocus( text_input_popup, dialog );

/*	XtDialogAddButton( dialog, "ok", dialog_ok, NULL );
	XtDialogAddButton( dialog, "cancel", dialog_cancel, NULL );
*/	

	num_args = 0;
	callback[0].callback = dialog_ok;
	XtSetArg( arglist[num_args], XtNcallback, callback); num_args++;
	XtSetArg( arglist[num_args],XtNfont, font ); num_args++;
	dbutton1 = XtCreateManagedWidget("ok", commandWidgetClass,
			dialog, arglist, num_args );
	num_args = 0;
	callback[0].callback = dialog_cancel;
	XtSetArg( arglist[num_args], XtNcallback, callback); num_args++;
	XtSetArg( arglist[num_args],XtNfont, font ); num_args++;
	dbutton2 = XtCreateManagedWidget("cancel", commandWidgetClass,
			dialog, arglist, num_args );

			
	XtRealizeWidget( text_input_popup );
	XSync( XtDisplay( toplevel ), 1 );
}


int text_justify = 999;
#define TLEFT	1
#define TCENTER	2
#define TRIGHT	3
#define TCANCEL	4


void leftjust_handler()
{
	text_justify = TLEFT;
}

void centerjust_handler()
{
	text_justify = TCENTER;
}

void rightjust_handler()
{
	text_justify = TRIGHT;
}

void cancel_handler()
{
	text_justify = TCANCEL;
}

Widget text_position_popup = NULL;

create_justify_popup()
{
	Arg arglist[10];
	Cardinal num_args, center_x, center_y;
	Widget box, label;
	XFontStruct *font;
	Widget button1, button2, button3, button4;
	static XtCallbackRec callback[] = {
		{ NULL, NULL },
		{ NULL, NULL },
	};
	
	if (text_position_popup != NULL) return;

	font = XLoadQueryFont( XtDisplay( toplevel ), "vg-20" );


	num_args = 0;
	XtSetArg( arglist[num_args],XtNallowShellResize, TRUE ); num_args++;
	center_x = workarea->core.x + (workarea->core.width / 2.);
	center_y = workarea->core.y + (workarea->core.height / 2.);
	XtSetArg( arglist[num_args],XtNx, center_x - 100 ); num_args++;
	XtSetArg( arglist[num_args],XtNy, center_y - 54 ); num_args++;

	text_position_popup = XtCreatePopupShell( "Text Position",
		transientShellWidgetClass, toplevel, arglist, num_args );
		
	if (!text_position_popup) { printf("Popup Holder creation failed\n"); exit(); }
	num_args = 0;
	box = XtCreateWidget("Justification", boxWidgetClass, 
			text_position_popup, NULL, 0 );
	if (!box) { printf("Box widget creation failed\n"); exit(); }

	num_args = 0;
	XtSetArg( arglist[num_args],XtNborderWidth, 0 ); 
	num_args++;
	XtSetArg( arglist[num_args],XtNfont, font ); 
	num_args++;
	XtSetArg( arglist[num_args],XtNlabel,
			"Would you like to justify the text?" );
	num_args++;
	label = XtCreateManagedWidget("label", labelWidgetClass, box,
			arglist, num_args );
	num_args = 0;
	callback[0].callback = leftjust_handler;
	XtSetArg( arglist[num_args], XtNcallback, callback);
	num_args++;
	XtSetArg( arglist[num_args],XtNfont, font ); 
	num_args++;
	button1 = XtCreateManagedWidget("left", commandWidgetClass,
			box, arglist, num_args );
	num_args = 0;
	callback[0].callback = centerjust_handler;
	XtSetArg( arglist[num_args],XtNfont, font ); 
	num_args++;
	XtSetArg( arglist[num_args], XtNcallback, callback);
	num_args++;
	button2 = XtCreateManagedWidget("center", commandWidgetClass,
			box, arglist, num_args );
	num_args = 0;
	XtSetArg( arglist[num_args],XtNfont, font ); 
	num_args++;
	callback[0].callback = rightjust_handler;
	XtSetArg( arglist[num_args], XtNcallback, callback);
	num_args++;
	button3 = XtCreateManagedWidget("right", commandWidgetClass,
			box, arglist, num_args );
	num_args = 0;
	XtSetArg( arglist[num_args],XtNfont, font ); 
	num_args++;
	callback[0].callback = cancel_handler;
	XtSetArg( arglist[num_args], XtNcallback, callback);
	num_args++;
	button4 = XtCreateManagedWidget("cancel", commandWidgetClass,
			box, arglist, num_args );
	XtManageChild(box);
	XtRealizeWidget( text_position_popup );
printf("Done creating popup justify widget\n");	
}

void popup_justify( w, junk, event )
Widget w;
caddr_t junk;
XEvent *event;
{
	create_justify_popup();
	printf("Justify popup created, poping up\n");
	if ( text_position_popup ) 
		XtPopup( text_position_popup, XtGrabExclusive );
	else printf("No test_position_popup widget\n");
	printf("Done popping up\n");
}

void PopDown_Justify()
{
/*	if (event->xcrossing.detail != NotifyInferior) */
	if (text_position_popup)
		XtPopdown( text_position_popup );
}

/*

XtPositionWidget( widget, x, y, wd, ht )
Widget widget; int x, y, wd, ht;
{
	widget->core.x = x;
	widget->core.y = y;
	widget->core.width = wd;
	widget->core.height = ht;
}

*/
#define BXWD		40
#define BXHT		20
#define SELECTION_HT	20
static int vlt_rows = 4;

void color_handler( w, closure, event ) 
Widget w; caddr_t closure; XEvent *event;
{
    int i, x, y, col, row, index;
    Display *display; Window window;
    
    display = XtDisplay( w );
    window = XtWindow( w );
    
    vlt_rows = (w->core.height - SELECTION_HT) / BXHT;
    if (vlt_rows <= 1) vlt_rows = 1;
    if (event->type == Expose) {
	for (i=0; i< max_colors; i++) {
		XSetForeground( display, gc, i );
		XFillRectangle( display, window, gc, 
			/* X integer truncate in X down the column */
			/* Y advances for each value then modulo's to top */
    			BXWD*(i/vlt_rows), SELECTION_HT + BXHT*(i%vlt_rows),
					BXWD, BXHT);
	}
        XSetForeground( display, gc, cur_color );
	XFillRectangle( display, window, gc,
			0, 0, w->core.width, SELECTION_HT );
	
    }
    if (event->type == ButtonRelease) {
	x = event->xbutton.x;
	y = event->xbutton.y;
	y -= SELECTION_HT;
	if (y < 0) {
		cur_color++;
		if (cur_color > max_colors) cur_color = 0;
	} else {
		
		row = y / BXHT;
		col = x / BXWD;
		index = row + col * vlt_rows;
		if (cur_color > max_colors) cur_color = 0;
		else cur_color = index;
		printf(" x:%d, y:%d, col:%d, row:%d, index:%d, color:%d\n",
				x, y, col, row, index, cur_color );
	}
        XSetForeground( display, gc, cur_color );
	XFillRectangle( display, window, gc,
			0, 0, w->core.width, SELECTION_HT );
    }
}



/*
 * the following set of routines give us a way of
 * determining which widgets have been created which
 * are of the primary_level status, and should be
 * used as root nodes of the trees they represent
 * for saving to disk.
 *
 * First we call PrimaryWidget(), then we call NextPrimaryWidget()
 * until a NULL widget is returned. 
 */


Widget get_primary_widget( widget ) Widget widget;
{
	if (!widget) return NULL;
	if (widget->core.parent == workarea) return widget;
	return get_primary_widget( widget->core.parent );
	
}
	
save_widget( widget ) Widget widget;
{
	Widget get_primary_widget();
	
	widget = get_primary_widget( widget );
	return ascii_save_primary_widget( widget );
}	
