static char SCCSID[] = "%W% %E%";

/*
 * Copyright 1988 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>

/* X toolkit Include files */

#include <X11/Intrinsic.h>
#include <X11/Cardinals.h>
#include <X11/AsciiText.h>
#include <X11/Box.h>
#include <X11/Viewport.h>
#include <X11/Command.h>
#include <X11/Form.h>
#include <X11/Shell.h>
#include <X11/Scroll.h>
#include <X11/VPaned.h>

#include "Palette.h"
#include "palette.bit"

#define MIXERHEIGHT 130

extern void exit();
void Quit(), Destroyed();
void Scrolled(), Thumbed();
static XColor mixColor;
long requestColor();
static Display     *dpy;
static Colormap    cmap;

#define RED_SCROLL    0
#define GREEN_SCROLL  1
#define BLUE_SCROLL   2

static XtCallbackRec thumbRedCallbacks[] = {
  { Thumbed, (caddr_t) RED_SCROLL },
  { NULL, NULL },
};

static XtCallbackRec thumbGreenCallbacks[] = {
  { Thumbed, (caddr_t) GREEN_SCROLL },
  { NULL, NULL },
};

static XtCallbackRec thumbBlueCallbacks[] = {
  { Thumbed, (caddr_t) BLUE_SCROLL },
  { NULL, NULL },
};

static Arg argsRed[] = {
  { XtNforeground,  (XtArgVal)0 },
  { XtNborderColor, (XtArgVal)0 },
  { XtNthumbProc,   (XtArgVal)thumbRedCallbacks },
  { XtNheight,      (XtArgVal)MIXERHEIGHT },
};

static Arg argsGreen[] = {
  { XtNforeground,  (XtArgVal)0 },
  { XtNborderColor, (XtArgVal)0 },
  { XtNthumbProc,   (XtArgVal)thumbGreenCallbacks },
  { XtNheight,      (XtArgVal)MIXERHEIGHT },
};

static Arg argsBlue[] = {
  { XtNforeground,  (XtArgVal)0 },
  { XtNborderColor, (XtArgVal)0 },
  { XtNthumbProc,   (XtArgVal)thumbBlueCallbacks },
  { XtNheight,      (XtArgVal)MIXERHEIGHT },
};

static XrmOptionDescRec options[] = {
{"-mixer",    "mixer",     XrmoptionNoArg,     "True"},
};

static Boolean withMixer;

static XtResource resources[] = {
    {"mixer", "Mixer", XtRBoolean, sizeof(Boolean),
	 (Cardinal)&withMixer, XtRString, "False"},
};

/*
 * Report the syntax for calling xclock.
 */
Syntax(call)
	char *call;
{
	(void) printf ("Usage: %s [-bw <pixels>] [-bd <color>]\n", call);
	(void) printf ("       [-d [<host>]:[<vs>]]\n");
	(void) printf ("       [-g =[<width>][x<height>][<+-><xoff>[<+-><yoff>]]]\n\n");
	exit(1);
}

void main(argc, argv)
    unsigned int argc;
    char **argv;
{
    Widget toplevel, outer, palette, mixerbox, mixedcolor;
    static XtCallbackRec callback[2]; /* K&R: initialized to NULL */
    Arg arg[10];
    long red, green, blue;
    Status ok;
    long dummy;

    toplevel = XtInitialize( NULL, "XPalette", options, XtNumber(options), &argc, argv);
    if (argc != 1) Syntax(argv[0]);

    XtGetApplicationResources( toplevel, (caddr_t)NULL,
			       resources, XtNumber(resources),
			       NULL, ZERO );

    dpy = XtDisplay(toplevel);
    cmap = DefaultColormap(dpy, DefaultScreen(dpy));

    arg[0].name = XtNiconPixmap;
    arg[0].value = (XtArgVal) XCreateBitmapFromData (dpy,
						     XtScreen(toplevel)->root,
						     palette_bits,
						     palette_width,
						     palette_height);
    XtSetValues (toplevel, &arg[0], ONE);

    XtSetArg( arg[0], XtNwidth, 200 );
    XtSetArg( arg[1], XtNheight, 250 );
    outer = XtCreateManagedWidget( "vpaned", vPanedWidgetClass, toplevel,
				   arg, ONE );

    callback[0].callback = Quit;
    callback[0].closure = (caddr_t)toplevel;
    XtSetArg( arg[0], XtNcallback, callback );
    XtCreateManagedWidget( "quit", commandWidgetClass, outer, arg, ONE );

    XtSetArg( arg[0], XtNmin, 16 );
    palette = XtCreateManagedWidget("palette", paletteWidgetClass, outer, arg, ONE );

    if (withMixer) {
	red = requestColor(dpy, "red");
	green = requestColor(dpy, "green");
	blue = requestColor(dpy, "blue");
	ok = XAllocColorCells(dpy, cmap, 0, &dummy, 0, &mixColor.pixel, 1);

	/*
	 * create mixer only, when we have at least red, green, blue
	 * and one spare color ...
	 */
	if (ok && (red != -1) && (green != -1) && (blue != -1)) {

	    XtSetArg( arg[0], XtNmin, MIXERHEIGHT );
	    mixerbox = XtCreateManagedWidget(NULL, boxWidgetClass, outer,
					     arg, ONE );

	    mixColor.red = mixColor.green = mixColor.blue = (short)~0;
	    mixColor.flags = DoRed | DoGreen | DoBlue;
	    XStoreColor(dpy, cmap, &mixColor);

	    argsRed[0].value = argsRed[1].value = red;
	    argsGreen[0].value = argsGreen[1].value = green;
	    argsBlue[0].value = argsBlue[1].value = blue;

	    XtCreateManagedWidget( "scrollbarRed", scrollbarWidgetClass, mixerbox,
				  (ArgList)argsRed, XtNumber(argsRed) );

	    XtCreateManagedWidget( "scrollbarGreen", scrollbarWidgetClass, mixerbox,
				  (ArgList)argsGreen, XtNumber(argsGreen) );

	    XtCreateManagedWidget( "scrollbarBlue", scrollbarWidgetClass, mixerbox,
				  (ArgList)argsBlue, XtNumber(argsBlue) );

	    XtSetArg( arg[0], XtNlabel, "" );
	    XtSetArg( arg[1], XtNbackground, mixColor.pixel );
	    XtSetArg( arg[2], XtNheight, MIXERHEIGHT );
	    XtSetArg( arg[3], XtNwidth, MIXERHEIGHT );
	    mixedcolor = XtCreateManagedWidget(NULL, labelWidgetClass,
					       mixerbox, arg, 4);
	}
    }
    XtRealizeWidget(toplevel);
    XtMainLoop();
}

/* ARGSUSED */
void 
Quit(w,junk,garbage)
Widget w;
caddr_t junk,garbage;
{
    XCloseDisplay(XtDisplay(w));
    exit(0);
}

/* ARGSUSED */
void Destroyed(widget, closure, callData)
    Widget widget;		/* unused */
    caddr_t closure;		/* unused */
    caddr_t callData;		/* unused */
{
    exit(0);
}

void Thumbed(w, closure, top)
    Widget w;
    caddr_t closure;
    double top;
{
    int which = (int)closure;
    int mix;

    mix = (int) ((1.0 - top) * 256.0 * 256.0);
    if (mix > 0xFFFF)
	mix = 0xFFFF;

    switch (which) {
	case RED_SCROLL:
	    mixColor.red = mix;
	    break;
	case GREEN_SCROLL:
	    mixColor.green = mix;
	    break;
	case BLUE_SCROLL:
	    mixColor.blue = mix;
	    break;
	default:
	    fprintf(stderr, "Oops Thumb calldata invalid\n");
	    exit(1);
    }
    XStoreColor(dpy, cmap, &mixColor);
}

static long requestColor(dpy, name)
Display *dpy;
char *name;
{
	XColor truecolor, availcolor;

	if (XAllocNamedColor(dpy,
			     DefaultColormap(dpy, DefaultScreen(dpy)),
			     name, &availcolor, &truecolor) == 0) {
	    return -1;
	}
	if (truecolor.red != availcolor.red ||
		truecolor.green != availcolor.green ||
		truecolor.blue != availcolor.blue) {
	    fprintf(stderr, "Warning: %s color bay be wrong\n", name);
	}

	return availcolor.pixel;
}
