.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH TWM 1 "16 August 1988" "X Version 11"
.SH NAME
.PP
twm - a window manager for X11 (Tom's Window Manager)
.PP
.SH SYNTAX
.PP
\fBtwm \fP[-display \fIdisplay\fP]
.PP
.SH DESCRIPTION
.PP
The \fItwm\fP program is a window manager client 
application of the window 
server.
.PP
The \fItwm\fP program was written to incorporate some of the
desirable features of both the \fBwm\fP and \fBuwm\fP window managers.
\fITwm\fP puts a title bar on  and re-parents each window.
The title bar contains the
window's name and three "buttons".  When a pointer button press event
is detected in any of these title bar "buttons" a certain action is
performed.  The left-most title bar button that looks like a window pane
causes the window to be iconified.  The right-most title bar button with
the right-angles is the re-size button.  The resize function is identical
to the window resize function of the \fBwm\fP window manager.  The other
title bar button represents a keyboard; a button click here
causes the input focus to stay directed to this window until the \fBf.unfocus\fP
function is executed or another window is selected to get input focus
(by default, the input focus follows the mouse or other pointing device).
The title bar also becomes highlighted on the
window that currently has the input focus.
.PP
When \fItwm\fP is invoked, it attempts to read a \fItwm\fP startup file.
The name of the \fItwm\fP startup file is:
.sp 0.5
  $HOME/.twmrc
.PP
The \fItwm\fP startup file has three logical
sections: the variables section, the buttons section, and the menus
section.  The variables section must come first, followed by either the
buttons section or the menus section.
.PP
All variables and keywords may be
entered in any combination of upper and lower case letters.
Functions must be entered in lower case. A 
pound sign (#) character in the startup file indicates a comment 
which is terminated by the newline character.  A \fIstring\fP in
the startup file is a series of characters enclosed by double quotes.
.PP
.SH VARIABLES SECTION
.PP
Variables must be entered first, at the top of the startup
file.  Variables are initialized only once, when \fItwm\fP begins
execution.
They will not be affected when a subsequent \fBf.twmrc\fP function is executed.
It is probably a good idea to initialize the color variables first.
.PP
Several variables take filenames as arguments.
Filenames are processed as follows.  \fITwm\fP checks to see if the
first character in the filename is a tilde (~), if it is, \fItwm\fP
prepends the user's \fBHOME\fP environment variable to the filename.
In the case of variables requiring bitmap files, if the above expansion
does not produce a path to a valid bitmap file, the following steps
are taken.  If the \fBIconDirectory\fP variable has been set, and the
filename does not start with a slash (/), the \fBIconDirectory\fP 
variable is prepended to the filename.  If that path does not produce
a valid bitmap file, the string "/usr/include/X11/bitmaps/" is prepended
to the original filename.
.PP
The following describes the \fItwm\fP variables:

.IP "\fBAutoRaise\fP { \fIlist\fP }" 20
This variable is a list of window names that will automatically
raise to the top of the stacking order whenever the pointer enters
the window.  The window names in the list are the first characters
in the window name to check for.  For example:
.EX 0
\fBAutoRaise\fP
{
   "xterm"
   "xclock"
}
.EE
The above list contains two names which will match window names beginning
with the string "xterm" or "xclock".  The following window names will match
and be in auto-raise mode: "xterm", "xterm_iguana", "xclock".
.IP "\fBBorderColor\fP \fIstring\fP" 20
This variable sets the color of the border to placed around all non-iconified
windows.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default  is "black".
.IP "\fBBorderTileForeground\fP \fIstring\fP" 20
This variable sets the foreground color of the "grey" bitmap used in
non-highlighted borders.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default  is "black".
.IP "\fBBorderTileBackground\fP \fIstring\fP" 20
This variable sets the background color of the "grey" bitmap used in
non-highlighted borders.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default  is "white".
.IP "\fBBorderWidth\fP \fIpixels\fP" 20 
This variable specifies the width in pixels of of the border surrounding all
windows.  The default is 2.
.IP "\fBColor\fP { \fIcolors\fP }" 20
This variable is a list of color assignments to be made if the default
display has a depth greater than one, or in other words, has the ability
to display more than black and white.
For example:
.EX 0
\fBColor\fP
{
   BorderColor "red"
   TitleForeground "yellow"
   TitleBackground "blue"
}
.EE
The various color variables may be found in this section of the manual
page.  There is also a \fBMonochrome\fP list of colors that may be specified.
This enables you to use the same initialization file on a color or
monochrome display.
.IP "\fBDecorateTransients\fP
This variable causes \fItwm\fP to put a title bar on transient windows.
By default, transient windows will not be re-parented.
.IP "\fBDefaultFunction\fP \fIfunction\fP" 20
This variable defines a default window manager function to be performed 
if no function is assigned to a combination of modifier keys and mouse
buttons.  A useful function to execute might be \fBf.beep\fP.
.IP "\fBDontIconifyByUnmapping\fP { \fIlist\fP }" 20
This variable is a list of windows to not iconify by simply unmapping
the window.  This may be used when specifying \fBIconifyByUnmapping\fP
to selectively choose windows that will iconify by mapping an icon
window.
.IP "\fBDontMoveOff\fP" 20
If this variable is set, windows will not be allowed to be moved off the
display.
.IP "\fBForceIcons\fP" 20
This variable is only meaningful if a \fBIcons\fP list is defined.  
It forces the icon bitmaps listed in the \fBIcons\fP list to be
used as window icons even if client programs supply their own icons.
The default is to not force icons.
.IP "\fBIcons\fP { \fIlist\fP }" 20
This variable is a list of window names and bitmap filenames to be
used as icons.
For example:
.EX 0
\fBIcons\fP
{
   "xterm"	"xterm.icon"
   "xfd"	"xfd_icon"
}
.EE
The names "xterm" and "xfd" are added to a list that is searched
when the client window is reparented by \fItwm\fP.  The window names
specified are just the first portion of the name to match.  In the
above example, "xterm" would match "xtermfred" and also "xterm blob".
The client window names are checked against those specified in this
list in addition to the class name of the client if it is specified.
By using the class name, all xterm windows can be given the same icon
by the method used above even though the names of the windows may be
different.
.IP "\fBIconBackground\fP \fIstring\fP" 20
This variable sets the background color of icons.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default is "white".
.IP "\fBIconBorderColor\fP \fIstring\fP" 20
This variable sets the color of the border around icons. 
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default is "black".
.IP "\fBIconDirectory\fP \fIstring\fP" 20
This variable names the directory in which to search for icon bitmap
files.  This variable is described under the \fBVARIABLES SECTION\fP
heading.  The default is to have no icon directory.
.IP "\fBIconFont\fP \fIstring\fP" 20
This variable names the font to be displayed within icons.  The default
is "8x13".
.IP "\fBIconForeground\fP \fIstring\fP" 20
This variable sets the foreground color of icons.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default is "black".
.IP "\fBIconifyByUnmapping\fP
This variable causes \fItwm\fP to iconify windows by simply unmapping them.
The icon window will not be made visible.  This variable can be used
in conjunction with the \fBDontIconifyByUnmapping\fP list.  The default
is to iconify by unmapping the window and mapping a seperate icon window.
.IP "\fBIconManagerDontShow\fP { \fIlist\fP }" 20
This variable is a list of window names that will not be displayed 
in the icon manager window.  This may be useful in specifying windows
that are rarely iconified such as "xclock."
.IP "\fBIconManagerBackground\fP \fIstring\fP" 20
This variable sets the background color of the icon manager window.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default is "white".
.IP "\fBIconManagerForeground\fP \fIstring\fP" 20
This variable sets the foreground color of the icon manager window.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default is "black".
.IP "\fBIconManagerGeometry\fP \fIstring\fP" 20
This variable sets the geometry of the icon manager window.  The \fIstring\fP
is of the form:
.nf
    \fI=<width>x<height>{+-}<xoffset>{+-}<yoffset>\fP
.fi
The height of the icon manager window is not vrey important because 
the height of the window will be changing as windows are created and
destroyed.
.IP "\fBMenuBackground\fP \fIstring\fP" 20
This variable sets the background color of menus.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default is "white".
.IP "\fBMenuFont\fP \fIstring\fP" 20
This variable names the font to be displayed within menus.  The default
is "8x13".
.IP "\fBMenuForeground\fP \fIstring\fP" 20
This variable sets the foreground color of menus.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "black".
.IP "\fBMenuShadowColor\fP \fIstring\fP" 20
This variable sets the color of the shadow behind pull-down menus.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "black".
.IP "\fBMenuTitleBackground\fP \fIstring\fP" 20
This variable sets the background color for \fBf.title\fP entries in
menus.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "white".
.IP "\fBMenuTitleForeground\fP \fIstring\fP" 20
This variable sets the foreground color for \fBf.title\fP entries in
menus.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.  The default is "black".
.IP "\fBMonochrome\fP { \fIcolors\fP }" 20
This variable is a list of color assignments to be made if the default
display has a depth equal to one, or in other words can only display
black and white pixels.
For example:
.EX 0
\fBMonochrome\fP
{
   BorderColor "black"
   TitleForeground "black"
   TitleBackground "white"
}
.EE
The various color variables may be found in this section of the manual
page.  There is also a \fBColor\fP list of colors that may be specified.
This enables you to use the same initialization file on a color or
monochrome display.
.IP "\fBNoBackingStore\fP" 20
\fITwm\fP menus attempt to use backing store to minimize menu repainting.
If your server has implemented backing store but you would rather not
use this feature, this variable will disable \fItwm\fP from using 
backing store.
.IP "\fBNoHighlight\fP [ { \fIlist\fP } ]" 20
This variable turns off border highlighting.
An optional list may be specified with window names to selectively turn off
border highlighting.  The default is to highlight the borders of all windows
when the cursor enters the window.  When the border is highlighted, it will
be drawn in the current \fBBorderColor\fP.  When the border is not
highlighted, it will be rendered with a "grey" bitmap using the
current \fBBorderTileForeground\fP and \fBBorderTileBackground\fP colors.
.IP "\fBNoSaveUnder\fP" 20
\fITwm\fP menus attempt to use save unders to minimize window repainting
following menu selections.
If your server has implemented save unders but you would rather not
use this feature, this variable will disable \fItwm\fP from using 
save unders.
.IP "\fBNoTitle\fP [ { \fIlist\fP } ] " 20
This variable is a list of window names that will NOT have a title
bar created for them.  If \fBNoTitle\fP is specified with no window name
list, \fItwm\fP will not put title bars on any windows.
The list
of windows and how they match window names is exactly like the 
\fBAutoRaise\fP variable described above.
.IP "\fBNoRaiseOnDeiconify\fP" 20
If this variable is specified, windows will not be raised to the top of
the stacking order when de-iconified.
.IP "\fBNoRaiseOnMove\fP" 20
If this variable is specified, windows will not be raised to the top of
the stacking order following a move.
.IP "\fBNoRaiseOnResize\fP" 20
If this variable is specified, windows will not be raised to the top of
the stacking order following a resize.
.IP "\fBNoTitleFocus\fP" 20
If this variable is specified, input focus will not be directed to windows
when the pointer is in the title bar.  The default is to focus input to 
a client when the pointer is in the title bar.
.IP "\fBRandomPlacement\fP" 20
This causes windows with no specified geometry to be placed on the display 
in a random (kind of) position when they are created.  The default is
to allow the user to position the window interactively.
.IP "\fBResizeFont\fP \fIstring\fP" 20
This variable names the font to be displayed in the dimensions window
during window resize operations.
The default is "fixed".
.IP "\fBTitleFont\fP \fIstring\fP" 20
This variable names the font to be displayed within
the window title bar.  Note that the title bar is only 17 pixels in height,
so the largest practical font would be something like "9x15". The default
is "8x13".
.IP "\fBReverseVideo\fP" 20 
This variable causes \fItwm\fP to display white characters
on a black background,
rather than black characters on white.  This variable doesn't really do
much now that you can specify individual colors.
.IP "\fBShowIconManager\fP" 20 
This variable causes the icon manager window to be displayed when
twm is started.  The default is to not display the icon manager window.
.IP "\fBTitleBackground\fP \fIstring\fP" 20
This variable sets the background color for the title bars.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default is "white".
.IP "\fBTitleForeground\fP \fIstring\fP" 20
This variable sets the foreground color for the title bars.
It can only be specified inside of a 
\fBColor\fP or \fBMonochrome\fP list.
The default is "black".
.IP "\fBUnknownIcon\fP \fIstring\fP" 20
This variable specifies the file name of a bitmap format file to be
used as the default icon.  This bitmap will be used for the icon of all
clients which do not provide an icon bitmap and are not listed
in the \fBIcons\fP list.  The default is to use
no bitmap.
.IP "\fBWarpCursor\fP" 20
This variable causes the pointer cursor to be warped to a window which
is being deiconified.  The default is to not warp the cursor.
.IP "\fBWindowFunction\fP \fIfunction\fP" 20
This variable is the function to perform when a window is selected 
from the \fBTwmWindows\fP menu.  If this variable is not set, a window
selected from the \fBTwmWindows\fP menu will be deiconified (if it is
an icon) and then raised to the top of the window stacking order.
.IP "\fBZoom\fP [ \fIcount\fP ]" 20
This variable causes a series of outlines to be drawn when a window is
iconified or deiconified.  The optional count is a number which will be
the number of outlines to be drawn.
The default is to not draw the outlines.  The default outline count is 8.
.PP
.SH BUTTONS SECTION
.PP
The buttons section of the startup file contains definitions of functions
to perform when pointer buttons or specific keyboard keys are pressed.
Functions are assigned either to a pointer button, a keyboard key,
or a menu entry.
Functions are assigned to pointer buttons
as follows:
.EX 0
\fBButton\fP\fIn\fP = \fIkeys\fP : \fIcontext\fP :  \fIfunction\fP
.EE
The \fIn\fP following 
\fBButton\fP can be a number between 1 and 5 to indicate which pointer 
button the function is to be tied to. The \fBkeys\fP field is used to specify
which modifier keys must be pressed in conjunction with the pointer 
button.  The \fBkeys\fP field may contain any combination of the letters
\fBs\fP, \fBc\fP, and \fBm\fP, which stand for Shift, Control, and Meta,
respectively.  The \fBcontext\fP field specifies the context in which to
look for the button press.  Valid contexts are: \fBicon\fP, 
\fBroot\fP, \fBtitle\fP, \fBframe\fP, \fBwindow\fP, and \fBiconmgr\fP.
The \fBfunction\fP field
specifies the window manager function to perform.
It is important to note that the \fBiconmgr\fP context is only 
used when a pointer button is pressed in an icon manager window and
the window is an icon.  By default, a button press in an icon manager
window while the window is not iconic, will turn the window into an icon.
Now for some examples:
.EX 0
Button2 =     : title  : f.move                # 1
Button1 =     : root   : f.menu "menu 1"       # 2
Button1 = m   : icon   : f.menu "icon menu 1"  # 3
Button3 = msc : window : f.menu "menu3 1"      # 4
.EE
Line 1 specifies that when pointer button 2 is pressed in the title bar
with no modifier keys pressed, the \fBf.move\fP function is to be executed.
Line 2 specifies that when pointer button 1 is pressed in the root window
with no modifier keys pressed, the menu "menu 1" is popped up. 
Line 3 specifies that when pointer button 1 is pressed in an icon window
with the meta key pressed, the menu "icon menu 1" is popped up.
Line 4 specifies that when pointer button 3 is pressed in a client window
with the shift, control, and meta keys pressed,
the menu "menu 3" is popped up.
.PP
.SH Function Key Specifications
.PP
\fITwm\fP allows you execute functions when any key on the 
keyboard is pressed.  The specification of a function key is exactly like
the button specification described above, except instead of
\fBButton[1-5]\fP, a function key name in double quotes is used.
In addition to the normal contexts that may be specified, a window 
name may be used, and the function will be applied to all windows
matching the name.
For example:
.EX 0
"F1"    =     : window : f.iconify
"F2"    = m   : root   : f.refresh
"F3"    = m   : "window_name" : f.iconify
.EE
Keyboard key names can be found in /usr/include/X11/keysymdef.h.  Simply 
remove the \fBXK_\fP and you have the name that the X server will
recognize.
.PP
.SH TWM Functions
.PP
.IP "\fB!\fP \fIstring\fP" 20
This function causes \fIstring\fP to be sent to /bin/sh for execution.
.IP "\fB^\fP \fIstring\fP" 20
This function causes \fIstring\fP followed by a new line character
to be placed in the window server's cut buffer.
.IP "\fBf.beep\fP" 20
This function causes the bell of the workstation to be sounded.
.IP "\fBf.circledown\fP" 20
This function causes the top window that is obscuring another window to
drop to the bottom of the stack of windows.
.IP "\fBf.circleup\fP" 20
This function raises the lowest window that is obscured by other windows.
.IP "\fBf.cutfile\fP" 20
This function takes the contents of the window server's cut buffer 
and uses it as a filename to read into the server's cut buffer.
.IP "\fBf.deiconify\fP" 20
This function deiconifies a window.  If the window is not an icon, this
function does nothing.
If executed from a menu, the cursor is changed to
a dot and the next window that receives a button press will be
the window that is deiconified.
.IP "\fBf.destroy\fP" 20
This function allows you to destroy a window client.
If executed from a menu, the cursor 
is changed to a skull and crossbones and the next window
to receive a button press
will be destroyed.
.IP "\fBf.file\fP \fIstring\fP" 20
This function assumes \fIstring\fP is a file name.  This file is read into
the window server's cut buffer.
.IP "\fBf.focus\fP" 20
This function implements the same function as the keyboard focus button in
the title bar.  If executed from a menu, the cursor is changed to
a dot and the next window
to receive a button press will gain the input focus.
.IP "\fBf.forcemove\fP" 20
This function allows you to move a window.  If \fBDontMoveOff\fP is set,
\fBf.forcemove\fP allows you to move a window partially off the display.
If executed from a menu, the cursor is changed to
a double arrow and the next window that receives a button press will be
the window that is moved.
.IP "\fBf.fullzoom\fP" 20
This function resizes the current window to the full size of your display. It
is a toggle function so it is
really a fullzoom/unfullzoom function. In order to undo the fullzoom, you
invoke
f.fullzoom again - similar to \fBf.iconify\fP.
If executed from a menu, the cursor is changed to
a dot and the next window that receives a button press will be
the window that is fullzoomed/unfullzoomed.
.IP "\fBf.function\fP \fIstring\fP" 20
This function executes the user defined function stream specified by
\fIstring\fP.  A function stream is zero or more \fItwm\fP functions
that will be executed in order as if they were a single function.  To
define a function stream the syntax is:
.EX 0
\fBFunction\fP "\fIfunction name\fP"
{
   \fIfunction\fP
   \fIfunction\fP
	 .
	 .
   \fIfunction\fP
}
.EE
for example:
.EX 0
\fBFunction\fP "raise-n-focus"
{
   f.raise
   f.focus
}
.EE
.IP "\fBf.hideiconmgr\fP" 20
This function causes the icon manager window to become unmapped
(not visible).
.IP "\fBf.iconify\fP" 20
This function implements the same function as the iconify button in the
title bar.  If executed from a menu, the cursor is changed to a
dot and the next window to 
receive a button press will be iconified or de-iconified depending on
the current state of the window.
.IP "\fBf.lower\fP" 20
This function lowers the window to the bottom of the stacking
order.
If executed from a menu, the cursor is changed to
a dot and the next window that receives a button press will be
the window that is lowered.
.IP "\fBf.menu\fP \fIstring\fP" 20
This function assigns the pull-down menu named \fIstring\fP to a pointer
button.  If this function is used as an entry in a pull-down menu a 
pull-right menu will be assigned to the menu entry.
.IP "\fBf.move\fP" 20
This function allows you to move a window.
If executed from a menu, the cursor is changed to
a double arrow and the next window that receives a button press will be
the window that is moved.
Double clicking the pointer 
button tied to this function causes a constrained move function to be
executed.  The pointer will be warped to the center of the grid.
Moving the pointer to one of the grid lines will cause the window 
to begin moving in either an up-down motion or a left-right motion
depending on which grid line the pointer was moved across.
.IP "\fBf.nop\fP" 20
This function does nothing.
.IP "\fBf.quit\fP" 20
This function causes \fItwm\fP to exit.
There is no function to exit the X Window System from a window manager;
at present you must save the X Server's PID in a variable
and send it "kill -TERM".
This can easily be done in TWM by the ! function (see example below).
.IP "\fBf.raise\fP" 20
This function raises the window to the top of the stacking order.
If executed from a menu, the cursor is changed to
a dot and the next window that receives a button press will be
the window that is raised.
.IP "\fBf.raiselower\fP" 20
This function raises the window to the top of the stacking order if it is 
obscured in any way.  If the window is unobscured, the window is lowered
to the bottom of the stacking order.
If executed from a menu, the cursor is changed to
a dot and the next window that receives a button press will be
the window that is raised or lowered.
.IP "\fBf.refresh\fP" 20
This function causes all windows to be refreshed.
.IP "\fBf.resize\fP" 20
This function implements the window resize function of the resize button
in the title bar.
If executed from a menu,
the cursor is changed to
a double arrow and the next window that receives a button press will be
the window that is resized.
.IP "\fBf.showiconmgr\fP" 20
This function causes the icon manager window to become mapped (visible).
.IP "\fBf.source\fP \fIstring\fP" 20
This function assumes \fIstring\fP is a file name.  The file is read 
and parsed as a \fItwm\fP startup file.
This
function is intended to be used only to re-build pull-down menus.  None
of the \fItwm\fP variables are changed.
.IP "\fBf.title\fP" 20
This function is to be used as an entry in a pull-down menu.  It centers
the menu entry string in a menu entry and outlines
it with a border.  This function
may be used more than once in a pull-down menu.
.IP "\fBf.twmrc\fP" 20
This function causes the \fI$HOME/.twmrc\fP file to be re-read.  This
function is exactly like the \fBf.source\fP function without having to
specify the filename.
.IP "\fBf.unfocus\fP" 20
This function assigns input focus to the root window.
.IP "\fBf.version\fI" 20
This function causes the \fItwm\fP version window to be displayed.  This
window will be displayed until a pointer button is pressed or the
pointer is moved from one window to another.
.IP "\fBf.winrefresh\fP" 20
This function is similar to the \fBf.refresh\fP function, but 
allows you to refresh a single window.
If executed from a menu, the cursor is changed to
a dot and the next window that receives a button press will be
the window that is refreshed.
.IP "\fBf.zoom\fP" 20
This function is similar to the \fBf.fullzoom\fP function, but
resizes the height to the maximum height of your screen, not the width.
It is also a toggle function like \fBf.iconify\fP and \fBf.fullzoom\fP.
If executed from a menu, the cursor is changed to
a dot and the next window that receives a button press will be
the window that is zoomed/unzoomed.
.PP
.SH MENUS SECTION
.PP
The menus section is where pull-down menus are defined.  Entries in 
menus consist of functions as described in the Buttons Section.
The syntax to define a menu is:
.EX 0
\fBMenu\fP "\fImenu name\fP"
{
   \fIstring\fP    \fIfunction\fP
   \fIstring\fP    \fIfunction\fP
	 .
	 .
   \fIstring\fP    \fIfunction\fP
}
.EE
.PP
The \fImenu name\fP should be an identical string to one being
used with an \fBf.menu\fP function.  
Note that the \fImenu name\fP is case sensative. The \fIstring\fP portion
of each menu entry will be the text which will appear in the menu.
The \fIfunction\fP portion of the menu entry is one of the functions
described in the previous section.
.PP
There is a special menu called \fBTwmWindows\fP.  When this menu is pulled
down, a list of all window names is displayed in the menu.  Selecting
one of these window names will cause the \fBWindowFunction\fP to be 
executed.  If \fBWindowFunction\fP has not been set, the window
will be deiconified
(if it is an icon) and then raised to the top of the window stacking 
order.  
.PP
.SH ICON MANAGER
.PP
The icon manager is a window that contains names of selected or all
windows currently on the display.  In addition to the window name,
a small "window-pane" iconify button will be displayed to the left of the
name when the window is in an iconic state.
If the window is not currently an icon, a pointer button press
when the pointer is on the window name will 
cause the window to be iconified.
If the window is iconic, a pointer button press when the pointer is either
on the window name or on the iconify button will by default, cause
the window to be deiconified.  If however, a button function was
specified with a context of \fBiconmgr\fP, theat function will be
executed instead.
.PP
.SH WINDOW STARTUP
.PP
When a client is started, \fItwm\fP does one of twm things.  If the
\fBRandomPlacement\fP variable has been set and the window has not
specified an intial geometry, the window will be placed in a random
(kind of) position the display.  If the \fBRandomPlacement\fP 
variable has not been set and the client
has not specified both \fBUser Specified Size\fP hints
and \fBUser Specified Position\fP hints, \fItwm\fP will put up
a rubberband box indicating the initial window size.  If pointer
button one is pressed, the client window is created with the window
position equal to the current pointer position.  If pointer button two
is pressed, \fItwm\fP allows the window to be resized.  The resizing
operation takes place until button two is released.  While the initial
positioning of the window is taking place, \fItwm\fP will place a window
in the upper-left corner of the display showing the window's name.  If
resizing is taking place, \fItwm\fP will also place a window in the
upper-left corner, indicating the current window size.
.PP
.SH EXAMPLES
.PP
The following is an example \fItwm\fP startup file:
.EX 0

#**********************************************************************
#
#    .twmrc
#
#**********************************************************************

WarpCursor
BorderWidth	2
TitleFont	"8x13"
MenuFont	"8x13"
IconFont	"8x13"

Color
{
    BorderColor "red"
    BorderTileForeground "blue"
    BorderTileBackground "yellow"
    TitleForeground "white"
    TitleBackground "blue"
    MenuForeground "yellow"
    MenuBackground "darkgreen"
    MenuTitleForeground "red"
    MenuTitleBackground "blue"
    IconForeground "darkgreen"
    IconBackground "cadetblue"
    IconBorderColor "green"
}

#Button = KEYS : CONTEXT : FUNCTION
#----------------------------------
Button1 =      : root    : f.menu "button1"
Button2 =      : root    : f.menu "button2"
Button3 =      : root    : f.menu "button3"
Button1 =  m   : window  : f.menu "button1"
Button2 =  m   : window  : f.menu "button2"
Button3 =  m   : window  : f.menu "button3"
Button1 =  m   : title   : f.menu "button1"
Button2 =  m   : title   : f.menu "button2"
Button3 =  m   : title   : f.menu "button3"
Button1 =      : title   : f.raise
Button2 =      : title   : f.move
Button3 =      : title   : t.lower

ForceIcons
IconDirectory	"~/icons"
Icons
{
  "xterm"	"xterm.icon"    # obtained from IconDirectory
  "xfd"		"xfd_icon"	# obtained from /usr/include/X11/bitmaps
}
UnknownIcon	"default.icon"

NoTitle
{
  "xclock"	# don't need a title bar on this ...
  "xckmail"	# or this
}

menu "button1"
{
"Sun Systems"	f.title
"iguana" 	!"xterm -T iguana =80x24+100+100 -e rlogin iguana &"
"worm"		!"xterm -T worm =80x24+100+100 &"
"shiva"		!"xterm -T shiva =80x24+200+200 -e rlogin shiva &"
"tegus"		!"xterm -T tegus =80x24+200+200 -e rlogin tegus &"
"Vax Systems"	f.title
"shade"		!"xterm -T shade =80x24+200+200 -e rlogin shade &"
"bilbo"		!"xterm -T bilbo =80x24+250+250 -e rlogin bilbo &"
"frodo"		!"xterm -T frodo =80x24+300+300 -e rlogin frodo &"
"esunix" 	!"xterm -T esunix =80x24+350+350 -e rlogin esunix &"
"lynx8"		!"xterm -T lynx8 =80x24+390+390 -e rlogin lynx8 &"
}

menu "button2"
{
"Window Ops"		f.title
"Refresh"		f.refresh
"Focus on Root"		f.unfocus
"Re-read .twmrc"	f.twmrc
"Source something"	f.source "something"
"twm Version"		f.version
"(De)Iconify"           f.iconify
"Move Window"           f.move
"Resize Window"         f.resize
"Raise Window"          f.raise
"Lower Window"          f.lower
"Focus on Window"       f.focus
"Destroy Window"        f.destroy
"Exit TWM (only)"	f.quit
"Exit X Windows"	!"kill -TERM $XTOOLSPID"
}

menu "button3"
{
"Cut Buffer"		f.title
"Procedure Header"	f.file "/usr/ias_soft/tlastrange/src/proc.twm"
"File Header"		f.file "/usr/ias_soft/tlastrange/src/file.twm"
"pull right"		f.menu "blob"
}

menu "blob"
{
"pull right"		f.menu "final"
"another"		^"some text"
}

menu "final"
{
"entry 1"		f.nop
"entry 2"		f.nop
"entry 3"		f.nop
"entry 4"		f.nop
}
.EE
.PP
.SH BUGS
.PP
Pull-right menus may still have some problems.  They may sometimes
stay around when all pointer buttons have been released.
.PP
Double clicking very fast to get the constrained move function will sometimes
cause the window to move, even though the pointer is not moved.
.PP
The window auto-raise feature does not work consistently when the mouse
is moved very fast over auto-raise windows.
.PP
.SH FILES
.PP
 $HOME/.twmrc
.PP 
.SH SEE ALSO
.PP
X(1), Xserver(1)
.SH COPYRIGHT
.ce 4
COPYRIGHT 1988
Evans & Sutherland Computer Corporation
Salt Lake City, Utah
All Rights Reserved.
.PP
THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
SHOULD NOT BE CONSTRUED AS A COMMITMENT BY EVANS & SUTHERLAND.
EVANS & SUTHERLAND  MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY
OF THIS SOFTWARE FOR
ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
.PP
IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT RIGHTS,
APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN ADDITION TO THAT
SET FORTH ABOVE.
.PP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both the
copyright notice and this permission notice appear in supporting documentation,
and that the name of Evans & Sutherland not be used in advertising
or publicity pertaining to distribution of the software without specific, 
written prior permission.
.SH AUTHOR
Thomas E. LaStrange
.PP
Hewlett Packard Company
.br
Graphics Technology Division
.br
Fort Collins, Colorado
.PP
ARPA: toml%hpfcla@hplabs.hp.com
.br
UUCP: hplabs!hpfcla!toml
