.TH XDITVIEW 1 "Release 4" "X Version 11"
.SH NAME
xditview \(em display ditroff DVI files
.SH SYNOPSIS
.B xditview
[-\fItoolkitoption\fP ...] [-option ...]
.SH DESCRIPTION
The
.I xditview 
program displays ditroff output on an X display.  It uses special
font metrics which match the font set distributed with X11vR3, so
it does not require access to the server machine for font loading.
.SH OPTIONS
.I Xditview
accepts all of the standard X Toolkit command line options along with the 
additional options listed below:
.TP 8
.B \-help
This option indicates that a brief summary of the allowed options should be
printed.
.TP 8
.B \-page
This option specifies the page number of the document to be displayed.
.TP 8
.B \-backingStore \fIbacking-store-type\fP
Redisplay of the DVI window can take upto a second or so, this option causes
the server to save the window contents so that when it is scrolled around the
viewport, the window is painted from contents saved in backing store. 
\fIbacking-store-type\fP can be one of \fBAlways\fP, \fPWhenMapped\fP or
\fPNotUseful\fP.
.PP
The following standard X Toolkit command line arguments are commonly used with 
.I xditview:
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.  
The default is \fIwhite\fP.
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border of the window.
The default is \fIblack\fP.
.TP 8
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding the window.
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for displaying text.  The default is 
\fIblack\fP.
.TP 8
.B \-fn \fIfont\fP
This option specifies the font to be used for displaying widget text.  The
default is \fIfixed\fP.
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the preferred size and position of the window.
.TP 8
.B \-display \fIhost\fP:\fIdisplay\fP
This option specifies the X server to contact.
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.
.SH X DEFAULTS
This program uses the 
.I Dvi
widget in the X Toolkit.  It understands all of the core resource names and
classes as well as:
.PP
.TP 8
.B width (\fPclass\fB Width)
Specifies the width of the window.
.TP 8
.B height (\fPclass\fB Height)
Specifies the height of the window.
.TP 8
.B foreground (\fPclass\fB Foreground)
Specifies the default foreground color.
.TP 8
.B font (\fPclass\fB Font)
Specifies the font to be used for error messages.
.SH "USING XDITVIEW WITH DITROFF"
.PP
To build a DVI file suitable for use with xditview, use the device
description in devX75:
.br
.nf
	$ cd devX75
	$ makedev DESC
	$ mkdir /usr/lib/font/devX75
	$ cp *.out /usr/lib/font/devX75
	$ ditroff -TX75 \fIditroff-input\fP | xditview
.fi
.br
.SH "SEE ALSO"
X(1), xrdb(1), ditroff(1)
.SH BUGS
.I Xditview
can be easily confused by attempting to display a DVI file constructed
for the wrong device.  Support for pic is not yet implemented.
.SH ORIGIN
Portions of this program originated in xtroff which was derived
from suntroff.  
.SH COPYRIGHT
Copyright 1989, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Keith Packard (MIT X Consortium)
.br
Richard L. Hyde (Purdue)
.br
David Slattengren (Berkeley)
.br
Malcom Slaney (Schlumberger Palo Alto Research)
.br
Mark Moraes (University of Toronto)
