/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcBlit.c,v 6.3 89/05/07 15:14:40 paul Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcBlit.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcBlit.c,v 6.3 89/05/07 15:14:40 paul Exp $" ;
#endif

#include "x8514.h"

#include "ibmTrace.h"

extern int mergexlate[] ;
extern int ibm8514cursorSemaphore ;

void
ibm8514Bitblt( merge, rpm, wpm, x0, y0, x1, y1, lx, ly )
int merge ;
unsigned long int rpm, wpm ;
int x0, y0, x1, y1, lx, ly ;
{
	unsigned short command = 0xc0f3 ;
	int CursorIsSaved ;

	TRACE( ( "ibm8514Bitblt:merge=%d,rpm=%02x,wpm=%02x,x0=%d,y0=%d,x1=%d,y1=%d,lx=%d,ly=%d\n",
	  merge, rpm, wpm, x0, y0, x1, y1, lx, ly ) ) ;

	if ( lx <= 0 || ly <= 0 )
		return ;

	CursorIsSaved = !ibm8514cursorSemaphore
		     && ( ibm8514CheckCursor( x0, y0, lx, ly )
		       || ibm8514CheckCursor( x1, y1, lx, ly ) ) ;

	--lx ;
	--ly ;
	if ( x1 > x0 ) {
		x0 += lx ; /* start at right and go left */
		x1 += lx ;
		command &= 0xFFDF ;/* turn off X cd bit */
	}
	if ( y1 > y0 ) {
		y0 += ly ; /* start at bottom and go up */
		y1 += ly ;
		command &= 0xFF7F ;/* turn off Y cd bit */
	}

	ibm8514ATRNotBusy ;
	ibm8514CheckQueue( 5 ) ;
	PLNRENBL( rpm ) ;
	PLNWENBL( wpm ) ;
	SETFN1( FNCPYRCT, mergexlate[merge] ) ;
	SETX0( x0 ) ;
	SETY0( y0 ) ;
	ibm8514CheckQueue( 5 ) ;
	SETX1( x1 ) ;
	SETY1( y1 ) ;
	SETLX( lx ) ;
	SETLY( ly ) ;
	COMMAND( command ) ;

	ibm8514CheckQueue( 3 ) ;
	PLNRENBL( ibm8514ALLPLANES ) ;
	PLNWENBL( ibm8514ALLPLANES ) ;
	SETFN1( FNCOLOR1, FNREPLACE ) ; /* as expected elsewhere */

	if ( CursorIsSaved )
		ibm8514ReplaceCursor() ;

	return ;
}

void
ibm8514BlitFG( rpm, wpm, fg, merge, x0, y0, x1, y1, lx, ly )
unsigned long int rpm ;
unsigned long int wpm ;
unsigned long int fg ;
int merge, x0, y0, x1, y1, lx, ly ;
{
	unsigned short command = 0xC0F3 ;
	int CursorIsSaved ;

	TRACE( ( "ibm8514BlitFG:rpm,wpm,fg,mrg,x0,y0,x1,y1,lx,ly = %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",
	  rpm, wpm, fg, merge, x0, y0, x1, y1, lx, ly ) ) ;

	if ( lx <= 0 || ly <= 0 )
		return ;

	CursorIsSaved = !ibm8514cursorSemaphore
		     && ( ibm8514CheckCursor( x0, y0, lx, ly )
		       || ibm8514CheckCursor( x1, y1, lx, ly ) ) ;

	lx-- ;
	ly-- ;
	if ( x1 > x0 ) {
		x0 += lx ; /* start at right and go left */
		x1 += lx ;
		command &= 0xFFDF ; /* turn off X cd bit */
	}
	if ( y1 > y0 ) {
		y0 += ly ; /* start at bottom and go up */
		y1 += ly ;
		command &= 0xFF7F ;/* turn off Y cd bit */
	}

	ibm8514ATRNotBusy ;
	ibm8514CheckQueue( 4 ) ;
	SETFN0( FNCOLOR0, FNNOP ) ;
	SETFN1( FNCOLOR1, mergexlate[merge] ) ;
	PLNRENBL( rpm ) ;
	PLNWENBL( wpm ) ;

	ibm8514CheckQueue( 4 ) ;
	SETMODE( M_CPYRCT ) ;
	SETCOL1( fg ) ;
	SETX0( x0 ) ;
	SETY0( y0 ) ;

	ibm8514CheckQueue( 5 ) ;
	SETX1( x1 ) ;
	SETY1( y1 ) ;
	SETLX( lx ) ;
	SETLY( ly ) ;
	COMMAND( command ) ;

	ibm8514CheckQueue( 5 ) ;
	PLNRENBL( RPLANES ) ;
	PLNWENBL( WPLANES ) ;
	SETFN0( FNCOLOR0, FNREPLACE ) ;
	SETFN1( FNCOLOR1, FNREPLACE ) ;
	SETMODE( M_ONES ) ;

	if ( CursorIsSaved )
		ibm8514ReplaceCursor() ;

	return ;
}

void
ibm8514BlitFGBG( rpm, wpm, fg, bg, merge, x0, y0, x1, y1, lx, ly )
unsigned long int rpm ;
unsigned long int wpm ;
unsigned long int fg ;
unsigned long int bg ;
int merge, x0, y0, x1, y1, lx, ly ;
{
	unsigned short command = 0xC0F3 ;
	int CursorIsSaved ;

TRACE( ( "ibm8514BlitFGBG:plns,fg,bg,mrg,x0,y0,x1,y1,lx,ly = %d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",
	  rpm, wpm, fg, bg, merge, x0, y0, x1, y1, lx, ly ) ) ;

	if ( lx <= 0 || ly <= 0 )
		return ;
	CursorIsSaved = !ibm8514cursorSemaphore
		     && ( ibm8514CheckCursor( x0, y0, lx, ly )
		       || ibm8514CheckCursor( x1, y1, lx, ly ) ) ;

	ly-- ;
	lx-- ;
	if ( x1 > x0 ) {
		x0 += lx ; /* start at right and go left */
		x1 += lx ;
		command &= 0xFFDF ;/* turn off X cd bit */
	}
	if ( y1 > y0 ) {
		y0 += ly ; /* start at bottom and go up */
		y1 += ly ;
		command &= 0xFF7F ;/* turn off Y cd bit */
	}

	ibm8514ATRNotBusy ;
	ibm8514CheckQueue( 4 ) ;
	SETFN0( FNCOLOR0, mergexlate[merge] ) ;
	SETFN1( FNCOLOR1, mergexlate[merge] ) ;
	SETCOL0( bg ) ;
	SETCOL1( fg ) ;

	ibm8514CheckQueue( 5 ) ;
	PLNRENBL( rpm ) ;
	PLNWENBL( wpm ) ;
	SETMODE( M_CPYRCT ) ;
	SETX0( x0 ) ;
	SETY0( y0 ) ;

	ibm8514CheckQueue( 5 ) ;
	SETX1( x1 ) ;
	SETY1( y1 ) ;
	SETLX( lx ) ;
	SETLY( ly ) ;
	COMMAND( command ) ;

	ibm8514CheckQueue( 5 ) ;
	PLNRENBL( RPLANES ) ;
	PLNWENBL( WPLANES ) ;
	SETFN0( FNCOLOR0, FNREPLACE ) ;
	SETFN1( FNCOLOR1, FNREPLACE ) ;
	SETMODE( M_ONES ) ;

	if ( CursorIsSaved )
		ibm8514ReplaceCursor() ;

	return ;
}
