/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcCurs.c,v 6.8 89/07/27 17:48:58 jeff Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcCurs.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcCurs.c,v 6.8 89/07/27 17:48:58 jeff Exp $" ;
#endif

/*
 * Software Cursor implementation for 8514/A
 *
 * Depends on owning some off-screen memory in SAVELOC, etc #defined areas
 */

#include "X.h"
#include "Xmd.h"
#include "miscstruct.h"
#include "scrnintstr.h"
#include "cursorstr.h"
#include "pixmapstr.h"
#include "colormapst.h"

#include "ibmScreen.h"
#include "ibmColor.h"

#include "ppc.h"

#include "x8514.h"

#include "OScompiler.h"
#include "ibmTrace.h"
#include "../../mfb/maskbits.h"

void ibm8514ReplaceCursor();

extern ibmPerScreenInfo ibm8514ScreenInfoStruct ; /* From brcScrInfo.c */

#define CURBLIT( COL, X0, Y0, X1, Y1, LX, LY )	\
	{				\
   	ibm8514CheckQueue( 8 ) ;	\
	SETCOL1( COL ) ;		\
	SETX0( X0 ) ;			\
	SETY0( Y0 ) ;			\
	SETX1( X1 ) ;			\
	SETY1( Y1 ) ;			\
	SETLX( LX - 1 ) ;		\
	SETLY( LY - 1 ) ;		\
	COMMAND( 0xC0F3 ) ;		\
	}

/* Global Cursor State Semaphore */
int ibm8514cursorSemaphore = 0 ;

static short int c_x = 0 ;
static short int c_y = 0 ;
static unsigned long int c_fg = 255 ;
static unsigned long int c_bg = 0 ;
static int active = FALSE ;
static int cursor_not_displayed = FALSE ;
static int curs_fore_r, curs_fore_g, curs_fore_b,
	   curs_back_r, curs_back_g, curs_back_b ;
static int current_w = 32 ;
static int current_h = 32 ;

static void
ibm8514CBitblt( x0, y0, x1, y1 )
register int x0, y0, x1, y1 ;
{
/* TRACE( ( "ibm8514CBitblt:x0=%d,y0=%d,x1=%d,y1=%d\n",
	  x0, y0, x1, y1 ) ) ; */

   ibm8514ATRNotBusy ;
   ibm8514CheckQueue( 4 ) ;
   SETFN1( FNCPYRCT, FNREPLACE ) ;
   SETX0( x0 ) ;
   SETY0( y0 ) ;
   SETX1( x1 ) ;

   ibm8514CheckQueue( 4 ) ;
   SETY1( y1 ) ;
   SETLX( current_w - 1 ) ;
   SETLY( current_h - 1 ) ;
   COMMAND( 0xC0F3 ) ;

   ibm8514CheckQueue( 1 ) ;
   SETFN1( FNCOLOR1, FNREPLACE ) ;

   return ;
}

void
ibm8514RemoveCursor()
{
/* TRACE(("ibm8514RemoveCursor()\n")) ; */
   active = FALSE ;
   ibm8514CBitblt( SAVELOCX, SAVELOCY,
		   c_x - ibm8514ScreenInfoStruct.ibm_CursorHotX,
		   c_y - ibm8514ScreenInfoStruct.ibm_CursorHotY ) ;
   return ;
}

static void
ibm8514Overlay( x, y )
register short x, y ;
{
/*   TRACE(("ibm8514Overlay(%d,%d)\n",x,y)) ; */

   ibm8514ATRNotBusy ;
   ibm8514CheckQueue( 5 ) ;
   SETFN0( FNCOLOR0, FNNOP ) ;
   SETFN1( FNCOLOR1, FNREPLACE ) ;
   PLNRENBL( RPLANE0 ) ;
   SETMODE( M_CPYRCT ) ;
   SETYMAX( _8514_SCREENHEIGHT - 1 ) ;

   ibm8514ATRNotBusy ;
   CURBLIT( c_fg, CUR1LOCX, CUR1LOCY, x, y, current_w, current_h ) ;
   ibm8514ATRNotBusy ;
   CURBLIT( c_bg, CUR0LOCX, CUR0LOCY, x, y, current_w, current_h ) ;

   ibm8514CheckQueue( 4 ) ;
   SETYMAX( 1023 ) ;
   PLNRENBL( RPLANES ) ;
   SETFN0( FNCOLOR0, FNREPLACE ) ;
   SETMODE( M_ONES ) ;

   return ;
}

/***============================================================***/

void
ibm8514CursorInit( index )
register int index ;
{
    TRACE( ( "ibm8514CursorInit(%d)\n", index ) ) ;

    c_x = 0 ;
    c_y = 0 ;
    active = FALSE ;
    ibm8514cursorSemaphore = 0 ;
    cursor_not_displayed = FALSE ;
    return ;
}

/***============================================================***/

Bool
ibm8514RealizeCursor( pScr, pCurs )
    ScreenPtr	pScr ;
    CursorPtr	pCurs ;
{
    register unsigned long int tmpMask ;
    register unsigned long int endbits ;
    unsigned long int *pFG, *pBG ;
    unsigned long int *psrcImage, *psrcMask ;
    int srcWidth ;
    int srcHeight ;
    int srcRealWidth ;

    TRACE( ( "ibm8514RealizeCursor(pScr=0x%x,pCurs=0x%x)\n", pScr, pCurs ) ) ;
    if ( !( ( pCurs->devPriv[ pScr->myNum ] = (pointer) Xalloc( 256 ) ) ) ) {
	ErrorF( "ibm8514RealizeCursor: can't malloc\n" ) ;
	return FALSE ;
    }
    pFG = (unsigned long int *) pCurs->devPriv[pScr->myNum] ;
    pBG = pFG + 32 ; /* words */
    bzero( (char *) pFG, 256 ) ;
    psrcImage = (unsigned long int *) pCurs->bits->source ;
    psrcMask = (unsigned long int *) pCurs->bits->mask ;
    srcRealWidth = ( pCurs->bits->width + 31 ) / 32 ;

    srcWidth  = MIN( pCurs->bits->width, 32 ) ;
    srcHeight = MIN( pCurs->bits->height, 32 ) ;

    endbits = ( srcWidth == 32 ) ? 0xFFFFFFFF : SCRLEFT( -1, (32-srcWidth) );

    while ( srcHeight-- ) {
	tmpMask = *psrcMask &= endbits ;
	*pFG++ = (*psrcImage) & tmpMask ;
	*pBG++ = (~(*psrcImage)) & tmpMask ;
	psrcImage += srcRealWidth ;
	psrcMask  += srcRealWidth ;
    }

    return TRUE ;
}

/***============================================================***/

Bool
ibm8514UnrealizeCursor( pScr, pCurs )
    register ScreenPtr pScr ;
    register CursorPtr pCurs ;
{
    TRACE( ( "ibm8514UnrealizeCursor(pScr=0x%x,pCurs=0x%x)\n",
	   pScr, pCurs ) ) ;

    Xfree( pCurs->devPriv[ pScr->myNum ] ) ;
    pCurs->devPriv[ pScr->myNum ] = 0 ;
    return TRUE ;
}

void
ibm8514ColorCursor( fg, bg )
register unsigned long int fg, bg ;
{
TRACE( ( "ibm8514ColorCursor(%d,%d)\n", fg, bg ) ) ;
if ( ( fg > 255 ) || ( bg > 255 ) ) {
	ErrorF( "ibm8514ColorCursor: bad color value(s)(fg/bg)=(%d,%d)",
		fg, bg ) ;
	return ;
}
c_fg = fg ;
c_bg = bg ;

return ;
}

void
ibm8514RecolorCursor( cmap )
register ColormapPtr cmap ;
{
c_fg = ibmFindColor( cmap, curs_fore_r, curs_fore_g, curs_fore_b ) ;
c_bg = ibmFindColor( cmap, curs_back_r, curs_back_g, curs_back_b ) ;
if ( active && ( !cursor_not_displayed ) )
	{
	ibm8514RemoveCursor();
	cursor_not_displayed = TRUE;
	ibm8514ReplaceCursor();
	}
return ;
}

/***============================================================***/

void
ibm8514ShowCursor( x, y )
int x, y ;
{
register int xloc, yloc ;

/* TRACE(("ibm8514ShowCursor(x=%d, y=%d)\n",x, y)) ; */
   if ( active )
	ibm8514RemoveCursor() ;

   xloc = ( c_x = x ) - ibm8514ScreenInfoStruct.ibm_CursorHotX ;
   yloc = ( c_y = y ) - ibm8514ScreenInfoStruct.ibm_CursorHotY ;
   ibm8514CBitblt( xloc, yloc, SAVELOCX, SAVELOCY ) ;
   ibm8514Overlay( xloc, yloc ) ;
   active = TRUE ;
   return ;
}

int
ibm8514DisplayCursor( pScr, pCurs )
    register ScreenPtr pScr ;
    register CursorPtr pCurs ;
{
    int *curdef ;

    TRACE( ( "ibm8514DisplayCursor(pScr=0x%x,pCurs=0x%x)\n", pScr, pCurs ) ) ;

    if ( active )
	ibm8514RemoveCursor() ;
    curdef = (int *) pCurs->devPriv[ pScr->myNum] ;

    ibm8514ScreenInfoStruct.ibm_CursorHotX = pCurs->bits->xhot ;
    ibm8514ScreenInfoStruct.ibm_CursorHotY = pCurs->bits->yhot ;
    ibm8514ScreenInfoStruct.ibm_CurrentCursor = pCurs ;

    curs_fore_r = pCurs->foreRed ;
    curs_fore_g = pCurs->foreGreen ;
    curs_fore_b = pCurs->foreBlue ;
    curs_back_r = pCurs->backRed ;
    curs_back_g = pCurs->backGreen ;
    curs_back_b = pCurs->backBlue ;

    ibm8514RecolorCursor(
		( (ppcScrnPrivPtr) pScr->devPrivate )->InstalledColormap ) ;

    ibm8514AlignMonoImage( ibm8514ALLPLANES, GXcopy, C1X, C1Y,
			   CURD_X, CURD_Y, curdef ) ;
    ibm8514AlignMonoImage( ibm8514ALLPLANES, GXcopy, C0X, C0Y,
			   CURD_X, CURD_Y, curdef + 32 ) ;

    current_w = MIN( pCurs->bits->width, CURD_X ) ;
    current_h = MIN( pCurs->bits->height, CURD_Y ) ;

    ibm8514ShowCursor( c_x, c_y ) ;
    return TRUE ;
}

int
ibm8514CheckCursor( x, y, lx, ly )
register const int x, y, lx, ly ;
{
/* check if the cursor is in this rectangle.  if so, remove and return TRUE
    else return FALSE */

if ( !ibm8514cursorSemaphore && active
  && ( cursor_not_displayed == FALSE )
  && !( ( x > ( c_x + current_w ) )
     || ( y > ( c_y + current_h ) )
     || ( ( x + lx ) < ( c_x - current_w ) )
     || ( ( y + ly ) < ( c_y - current_h ) ) ) ) {
	ibm8514RemoveCursor() ;
	return cursor_not_displayed = TRUE ;
}
else
	return FALSE ;
/*NOTREACHED*/
}

void
ibm8514ReplaceCursor()
{
if ( cursor_not_displayed && !ibm8514cursorSemaphore ) {
	ibm8514ShowCursor( c_x, c_y ) ;
	cursor_not_displayed = FALSE ;
	return ;
}

return ;
}
