/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */

 SYNTAX ERROR THIS LINE because I haven't finished cleaning this file for
   timing errors.  11/16/88  paquin

/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $Header: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcDash.c,v 6.4 88/11/16 18:45:01 paquin Exp $ */
/* $Source: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcDash.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcDash.c,v 6.4 88/11/16 18:45:01 paquin Exp $";
#endif


#include "X.h"

#include "misc.h"
#include "gcstruct.h"
#include "gc.h"
#include "pixmap.h"
#include "window.h"
#include "windowstr.h"
#include "pixmapstr.h"
#include "regionstr.h"
#include "scrnintstr.h"
#include "mistruct.h"

#include "OScompiler.h"

#include "mfb.h"
#include "ppc.h"

#include "x8514.h"

#define ACCESS_PIXEL (1 << 4)

#define barrel_shift8(v, s) \
	(v = (v >> s) | (v << (8 - s)))

#define HARDWARE_PATTERN 0x01

typedef struct {
	unsigned char	Flags;
	unsigned short	Pattern;
} ibm8514PrivGC;

typedef ibm8514PrivGC *ibm8514PrivGCPtr;

/* 
 * ibm8514 dashed line
 */

extern void ibm8514BresDash();
extern void ibm8514HorzDash();
extern void ibm8514VertDash();

#define X_AXIS 0

extern int mergexlate[];
extern int ibm8514cursorSemaphore ;

/* NOTE
   maybe OUTCODES should take box (the one that includes all
edges) instead of pbox (the standard no-right-or-lower-edge one)?
*/
#define OUTCODES(result, x, y, pbox) \
    if (x < pbox->x1) \
	result |= OUT_LEFT; \
    else if (x >= pbox->x2) \
	result |= OUT_RIGHT; \
    if (y < pbox->y1) \
	result |= OUT_ABOVE; \
    else if (y >= pbox->y2) \
	result |= OUT_BELOW;

void
ibm8514ZeroDash(pDrawable, pGC, mode, npt, pptInit)
    DrawablePtr pDrawable;
    GCPtr pGC;
    int mode;		/* Origin or Previous */
    int npt;		/* number of points */
    DDXPointPtr pptInit;
{
    int nboxInit;
    register int nbox;
    BoxPtr pboxInit;
    register BoxPtr pbox;
    int nptTmp;
    DDXPointPtr ppt;		/* pointer to list of translated points */

    DDXPointRec pt1;
    DDXPointRec pt2;

    unsigned int oc1;		/* outcode of point 1 */
    unsigned int oc2;		/* outcode of point 2 */

    int xorg, yorg;		/* origin of window */

    int adx;		/* abs values of dx and dy */
    int ady;
    int signdx;		/* sign of dx and dy */
    int signdy;
    int e, e1, e2;		/* bresenham error and increments */
    int len;			/* length of segment */

    int clipDone;		/* flag for clipping loop */
    DDXPointRec pt1Orig;	/* unclipped start point */
    DDXPointRec pt2Orig;	/* unclipped end point */
    int err;			/* modified bresenham error term */
    int clip1, clip2;		/* clippedness of the endpoints */

    int alu ;			/* Screen Raster-Op value */
    long fg ;			/* foreground Pixel value */
    long bg ;			/* background Pixel value */
    unsigned long pm ;			/* plane mask */
    register int tmp;
    int x1, x2, y1, y2;
				/* a bunch of temporaries */
    void (* scrnFunc)();

    if ( pDrawable->type != DRAWABLE_WINDOW )
    {
	ErrorF("ibm8514ZeroDash: not a window\n");
	return;
    }

    switch ( ( (ppcPrivGC *) pGC->devPriv )->colorRrop.fillStyle ) {
	case FillStippled :
	case FillSolid : /* Can Use Optimized Color Raster-Op */
	    alu = ( (ppcPrivGC *) pGC->devPriv )->colorRrop.alu ;
	    pm = ( (ppcPrivGC *) pGC->devPriv )->colorRrop.planemask ;
	    if(pGC->lineStyle == LineOnOffDash){
		ibm8514ClearQueue(1);
		SETCOL1( ( (ppcPrivGC *) pGC->devPriv )->colorRrop.fgPixel) ;
	    } else {
	    	fg = ( (ppcPrivGC *) pGC->devPriv )->colorRrop.fgPixel ;
	    	bg = ( (ppcPrivGC *) pGC->devPriv )->colorRrop.bgPixel ;
	    }
	    break ;
	case FillOpaqueStippled :
	case FillTiled : /* Can't Use Optimized Color Raster-Op */
	    alu = pGC->alu ;
	    pm = pGC->planemask ;
	    if(pGC->lineStyle == LineOnOffDash){
		ibm8514ClearQueue(1);
		SETCOL1(pGC->fgPixel);
	    } else {
	    	fg = pGC->fgPixel ;
	    	bg = pGC->bgPixel ;
	    }
	    break ;
    }
    if ( alu == GXnoop )
	return ;

    pboxInit = ((mfbPrivGC *)(pGC->devPriv))->pCompositeClip->rects;
    nboxInit = ((mfbPrivGC *)(pGC->devPriv))->pCompositeClip->numRects;

    xorg = ((WindowPtr)pDrawable)->absCorner.x;
    yorg = ((WindowPtr)pDrawable)->absCorner.y;

    /* translate the point list */
    ppt = pptInit;
    nptTmp = npt;
    if (mode == CoordModeOrigin)
    {
	while(nptTmp--)
	{
	    ppt->x += xorg;
	    ppt++->y += yorg;
	}
    }
    else
    {
	ppt->x += xorg;
	ppt->y += yorg;
	nptTmp--;
	while ( nptTmp-- )
	{
	    ppt++;
	    ppt->x += (ppt-1)->x;
	    ppt->y += (ppt-1)->y;
	}
    }

    ppt = pptInit;
    while ( --npt )
    {
	nbox = nboxInit;
	pbox = pboxInit;

	pt1 = *ppt++;
	pt2 = *ppt;

	if ( !( adx = ( pt2.x - pt1.x ) ) )
	{
	    /* make the line go top to bottom of screen, keeping
	       endpoint semantics
	    */
	    if ( pt1.y > pt2.y )
	    {
		tmp = pt2.y;
		pt2.y = pt1.y + 1;
		pt1.y = tmp + 1;
	    }

	    /* get to first band that might contain part of line */
	    while ((nbox) && (pbox->y2 <= pt1.y))
	    {
		pbox++;
		nbox--;
	    }

	    if ( nbox )
	    {
		/* stop when lower edge of box is beyond end of line */
		while ( ( nbox ) && ( pt2.y >= pbox->y1 ) ) {
		    if ( ( pt1.x >= pbox->x1 ) && ( pt1.x < pbox->x2 ) ) {
			/* this box has part of the line in it */
			if ( ( y1 = MAX( pt1.y, pbox->y1 ) )
			  != ( y2 = MIN( pt2.y, pbox->y2 ) ) ) {
			    ibm8514VertDash( pGC, fg, bg,
				alu, pm, pt1.x, y1, y2 - y1 ) ;
			}
		    }
		    nbox--;
		    pbox++;
		}
	    }

	}
	else if ( !( ady = ( pt2.y - pt1.y ) ) )
	{
	    /* force line from left to right, keeping
	       endpoint semantics
	    */
	    if (pt1.x > pt2.x)
	    {
		tmp = pt2.x;
		pt2.x = pt1.x + 1;
		pt1.x = tmp + 1;
	    }

	    /* find the correct band */
	    while( nbox && (pbox->y2 <= pt1.y))
	    {
		pbox++;
		nbox--;
	    }

	    /* try to draw the line, if we haven't gone beyond it */
	    if ((nbox) && (pbox->y1 <= pt1.y))
	    {
		/* when we leave this band, we're done */
		tmp = pbox->y1;
		while((nbox) && (pbox->y1 == tmp))
		{
		    if (pbox->x2 <= pt1.x)
		    {
			/* skip boxes until one might contain start point */
			nbox--;
			pbox++;
			continue;
		    }

		    /* stop if left of box is beyond right of line */
		    if (pbox->x1 >= pt2.x)
		    {
			nbox = 0;
			continue;
		    }
		    if ( ( x1 = MAX( pt1.x, pbox->x1 ) )
		      != ( x2 = MIN( pt2.x, pbox->x2 ) ) ) {
			    	ibm8514HorzDash( pGC, fg, bg,
					alu, pm, x1, pt1.y, x2 - x1 ) ;
		    }
		    nbox--;
		    pbox++;
		}
	    }
	}
	else	/* sloped line */
	{
	    signdx = sign(adx);
	    signdy = sign(ady);
	    adx = ABS(adx);
	    ady = ABS(ady);

	    if (adx > ady)
	    {
		e1 = ady*2;
		e2 = e1 - 2*adx;
		e = e1 - adx;

	    }
	    else
	    {
		e1 = adx*2;
		e2 = e1 - 2*ady;
		e = e1 - ady;
	    }

	    /* we have bresenham parameters and two points.
	       all we have to do now is clip and draw.
	    */

	    pt1Orig = pt1;
	    pt2Orig = pt2;

	    while(nbox--)
	    {

		BoxRec box;

		pt1 = pt1Orig;
		pt2 = pt2Orig;
		clipDone = 0;
		box.x1 = pbox->x1;
		box.y1 = pbox->y1;
		box.x2 = pbox->x2-1;
		box.y2 = pbox->y2-1;
		clip1 = 0;
		clip2 = 0;

		oc1 = 0;
		oc2 = 0;
		OUTCODES(oc1, pt1.x, pt1.y, pbox);
		OUTCODES(oc2, pt2.x, pt2.y, pbox);

		if (oc1 & oc2)
		    clipDone = -1;
		else if ((oc1 | oc2) == 0)
		    clipDone = 1;
		else /* have to clip */
		    clipDone = mfbClipLine(pbox, box,
					   &pt1Orig, &pt1, &pt2, 
					   adx, ady, signdx, signdy,
					   ( ( adx > ady ) ? X_AXIS : Y_AXIS ),
					   &clip1, &clip2);

		if (clipDone == -1)
		{
		    pbox++;
		}
		else
		{
		    if ( adx > ady )
			len = ABS(pt2.x - pt1.x);
		    else
			len = ABS(pt2.y - pt1.y);

		    len += (clip2 != 0);
		    if (len)
		    {
			/* unwind bresenham error term to first point */
			if (clip1)
			{
			    if ( adx > ady )
			        err = e
				    + ( ABS( pt1.y - pt1Orig.y ) * ( e2 - e1 ) )
				    + ( ABS( pt1.x - pt1Orig.x ) * e1 ) ;
			    else
			        err = e
				    + ( ABS( pt1.x - pt1Orig.x ) * ( e2 - e1 ) )
				    + ( ABS( pt1.y - pt1Orig.y ) * e1 ) ;
			}
			else
			    err = e;
			ibm8514BresDash( pGC, fg, bg, alu, pm,
				      signdx, signdy,
				      ( ( adx > ady ) ? X_AXIS : Y_AXIS ),
				      pt1.x, pt1.y, err, e1, e2, len ) ;
		    }

		    /* if segment is unclipped, skip remaining rectangles */
		    if (!(clip1 || clip2))
			break;
		    else
			pbox++;
		}
	    } /* while (nbox--) */
	} /* sloped line */
    } /* while (nline--) */

    /* paint the last point if the end style isn't CapNotLast.
       (Assume that a projecting, butt, or round cap that is one
        pixel wide is the same as the single pixel of the endpoint.)
    */

    if ((pGC->capStyle != CapNotLast) &&
	((ppt->x != pptInit->x) ||
	 (ppt->y != pptInit->y)))
    {
	nbox = nboxInit;
	pbox = pboxInit;
	scrnFunc =
	 ( (ppcScrnPriv *)(pDrawable->pScreen->devPrivate))->solidFill ;
	while (nbox--)
	{
	    if ((ppt->x >= pbox->x1) &&
		(ppt->y >= pbox->y1) &&
		(ppt->x <  pbox->x2) &&
		(ppt->y <  pbox->y2))
	    {
		(* scrnFunc)( fg, alu, pm, ppt->x, ppt->y, 1, 1 ) ;
		break;
	    }
	    else
		pbox++;
	}
    }
    return ;
}

void
ibm8514VertDash(pGC, fg, bg, alu, pm, x, y, len)
GCPtr pGC;
long fg;
long bg;
int alu;
int pm;
int x;
int y;
int len;
{
	int saved;
	int l = pGC->dash[0];
	int n = 0;
	int togo = len;
	int ndash = 0;
	int command = 0x20df | ACCESS_PIXEL;

	y += pGC->dashOffset;

	saved =
		!ibm8514cursorSemaphore && ibm8514CheckCursor( x,y,1,len ) ;


	ibm8514ATRNotBusy();
	ibm8514CheckQueue(5);
	PLNWENBL(pm);
	SETCOL1(fg);
	SETFN1(FNCOLOR1,mergexlate[alu]);
	SETX0(x);
	SETY0(y);

	while(togo){
		/* handle odd dash lists later */
		if(n > pGC->numInDashList){
			n = 0;
		}
		l = MIN(pGC->dash[n++], togo);
		togo -= l;
		if(pGC->lineStyle == LineOnOffDash){
			if(ndash & 0x01)
				command = 0x20df | ACCESS_PIXEL;
			else
				command = 0x20df  & ~ACCESS_PIXEL;
			ibm8514ClearQueue(2);
		} else {
			ibm8514ClearQueue(4);
			if(ndash & 0x01)
				SETCOL1(bg);
			else
				SETCOL1(fg);

			/* this appears to be a stupid line.  tfp 11/16/88 */
			SETFN1(FNCOLOR1,mergexlate[alu]);
		}
		ndash++;

		SETLX(l);
		COMMAND(command);
	}

	ibm8514ClearQueue(2);
	SETFN1(FNCOLOR1,FNREPLACE);
	PLNWENBL(WPLANES);
	if (saved)
    		ibm8514ReplaceCursor();
}

void
ibm8514HorzDash(pGC, fg, bg, alu, pm, x, y, len)
GCPtr pGC;
long fg;
long bg;
int alu;
unsigned long pm;
int x;
int y;
int len;
{
	int l = pGC->dash[0];
	int n = 0;
	int ndash = 0;
	int  command = 0x201f | ACCESS_PIXEL;
	ppcPrivGCPtr ppcPriv = (ppcPrivGCPtr)pGC->devPriv;
	ibm8514PrivGCPtr ibm8514Priv = (ibm8514PrivGCPtr)ppcPriv->devPriv;
	int togo = len;
	int saved;

	unsigned char flags = ibm8514Priv->Flags;
	unsigned short pattern = ibm8514Priv->Pattern;

	x += pGC->dashOffset;

	saved =
		!ibm8514cursorSemaphore && ibm8514CheckCursor( x,y,len,1 ) ;

	ibm8514ATRNotBusy();
	ibm8514CheckQueue(5);
	PLNWENBL(pm);
	SETCOL1(fg);
	SETFN1(FNCOLOR1,mergexlate[alu]);
	SETX0(x);
	SETY0(y);
	if(flags & HARDWARE_PATTERN){
		ibm8514CheckQueue(5);
		barrel_shift8(pattern, x % 8);
		SETMODE(M_PATTS);
		SETPAT0(pattern >> 3);
		SETPAT1(pattern << 1);
		SETCOL0(bg);
		if(pGC->lineStyle == LineOnOffDash){
			SETFN0(FNCOLOR0,mergexlate[GXnoop]);
		} else {
			SETFN0(FNCOLOR0,mergexlate[alu]);
		}
	}
	while(togo){
		/* handle odd dash lists later */
		if(n > pGC->numInDashList){
			n = 0;
		}
		l = MIN(pGC->dash[n++], togo);
		togo -= l;
		if(!(flags & HARDWARE_PATTERN)){
			if(pGC->lineStyle == LineOnOffDash){
				if(ndash & 0x01){
					command = 0x201f | ACCESS_PIXEL;
				} else {
					command = 0x201f & ~ACCESS_PIXEL;
				}
			} else {
				ibm8514ClearQueue(5);
				PLNWENBL(pm);
				if(ndash & 0x01){
					SETCOL1(bg);
				} else {
					SETCOL1(fg);
				}

				/* why reset the fn1? tfp 11/16/88 */
				SETFN1(FNCOLOR1,mergexlate[alu]);
				SETX0(x);
				SETY0(y);
			}
		}
		ndash++;
		ibm8514ClearQueue(2);
		SETLX(l);
		COMMAND(command);
	}
	ibm8514ClearQueue(6);
	SETMODE(M_ONES);
	SETPAT0(0);
	SETPAT1(0);
	SETFN0(FNCOLOR0,FNREPLACE);
	SETFN1(FNCOLOR1,FNREPLACE);
	PLNWENBL(WPLANES);
	if (saved)
    		ibm8514ReplaceCursor();
}

void
ibm8514BresDash( pGC, fg, bg, alu, pm, sdx, sdy, axis, x, y, et, e1, e2, len )
GCPtr pGC;
unsigned long int fg, bg;
int alu ;
unsigned long int pm ;
int sdx, sdy, axis, x, y, et, e1, e2, len;
{
	int saved;
	int togo = len;
	int l = pGC->dash[0];
	int n = 0;
	int ndash = 0;
	int  command;
	ppcPrivGCPtr ppcPriv = (ppcPrivGCPtr)pGC->devPriv;
	ibm8514PrivGCPtr ibm8514Priv = (ibm8514PrivGCPtr)ppcPriv->devPriv;
	unsigned char flags = ibm8514Priv->Flags;
	unsigned short pattern = ibm8514Priv->Pattern;

	saved =
		!ibm8514cursorSemaphore && ibm8514CheckCursor( x,y,len,len ) ;

	if (axis==X_AXIS){
		y += pGC->dashOffset;
		command = 0x2017; /* draw bres. line on X, W, LPN, */
	} else {
		x += pGC->dashOffset;
		command = 0x2057; /* same, on Y */
	}

	if (sdx > 0)
		command |= 0x0020;
	if (sdy > 0)
		command |= 0x0080;

	ibm8514ClearQueue(2);
	SETCOL1(fg);
	SETFN1(FNCOLOR1,mergexlate[alu]);
	if(axis == X_AXIS && flags & HARDWARE_PATTERN){
		ibm8514ClearQueue(6);
		barrel_shift8(pattern, x % 8);
		SETMODE(M_PATTS);
		SETPAT0(pattern >> 3);
		SETPAT1(pattern << 1);
		if(pGC->lineStyle == LineOnOffDash){
			SETFN0(FNCOLOR0,mergexlate[GXnoop]);
		} else {
			SETCOL0(bg);
			SETFN0(FNCOLOR0,mergexlate[alu]);
		}
	}
	ibm8514ClearQueue(6);
	PLNWENBL(pm);
	SETET(et); 
	SETK1(e1); 
	SETK2(e2); 

	SETX0(x);
	SETY0(y);

	while(togo){
		/* handle odd dash lists later */
		if(n > pGC->numInDashList){
			n = 0;
		}
		l = MIN(pGC->dash[n++], togo);
		togo -= l;
		if(!(axis == X_AXIS && flags & HARDWARE_PATTERN)){
			if(pGC->lineStyle == LineOnOffDash){
				if(ndash & 0x01)
					command |= ACCESS_PIXEL;
				else 
					command &= ~ACCESS_PIXEL;
			} else {
				ibm8514ClearQueue(1);
				if(ndash & 0x01)
					SETCOL1(bg);
				else
					SETCOL1(fg);
				SETFN1(FNCOLOR1,mergexlate[alu]);
			}
		}

		ndash++;

		ibm8514ClearQueue(2);
		/* going to use LAST PEL NULL in Line command to brecon */
		SETLX(l);

		COMMAND(command);
	}
	ibm8514ClearQueue(6);
	SETMODE(M_ONES);
	SETPAT0(0);
	SETPAT1(0);
	SETFN0(FNCOLOR0,FNREPLACE);
	SETFN1(FNCOLOR1,FNREPLACE);
	PLNWENBL(WPLANES);
	if (saved)
    		ibm8514ReplaceCursor();
}

#define barrel_shift8(v, s) \
	(v = (v >> s) | (v << (8 - s)))

void
ibm8514_do_dashline_gc(pGC)
register GCPtr pGC;
{
	register unsigned int len = 0;
	register unsigned int n;
       	register ibm8514PrivGCPtr ibm8514Priv =
		(ibm8514PrivGCPtr) ( (ppcPrivGCPtr) pGC->devPriv )->devPriv;

	/* check for dash pattern useable to ibm8514 */
	for ( n = 0 ; n < pGC->numInDashList ; n++ )
		len += pGC->dash[n];

	if (	len == 2 ||
		len == 4 ||
		(len == 8 && ((pGC->numInDashList & 1) == 0)))
	{
		register int bit;
		register int offset = 0;
		register unsigned char *dp = &pGC->dash[0];
		unsigned short pattern;

		pattern = 0;
		/* encode dash pattern into bitmask */
		while (n-- > 0 && *dp != 0){
			pattern |= ( ( ( 1 << *dp ) - 1 ) << offset ) ;
			offset += *dp++;
			if (n-- > 0)
				offset += *dp++;
		}
		/* replicate pattern over full 8 bits */
		for (bit = offset; bit < 8; bit++){
			pattern |=
				(pattern & (1 << bit - offset))
					<< offset;
		}
		/* shift pattern to implement offset - mod 8 */
		/* is it legal for offset > length ?? */
		if (pGC->dashOffset != 0)
			barrel_shift8(pattern, pGC->dashOffset % 8);
		ibm8514Priv->Pattern = pattern;
		ibm8514Priv->Flags |= HARDWARE_PATTERN;
	} else {
		ibm8514Priv->Flags &= ~HARDWARE_PATTERN;
	}
	pGC->Polylines = ibm8514ZeroDash;
	return ;
}
