/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#include "X.h"
#include "Xproto.h"
#include "miscstruct.h"
#include "scrnintstr.h"
#include "font.h"
#include "pixmapstr.h"
#include "window.h"
#include "gcstruct.h"
#include "colormapst.h"
#include "cursorstr.h"

#include "mistruct.h"
#include "mfb.h"

#include "OScursor.h"
#include "OSio.h"
#include "ibmScreen.h"

#include "ppc.h"
#include "ppcProcs.h"

#include "x8514.h"

#include "brcProcs.h"

extern void miRecolorCursor() ;
extern void NoopDDA() ;
extern void ibmAbort() ;

extern ScreenRec ibm8514ScreenRec ; /* Forward Declaration */

PixmapFormatRec	ibm8514Formats[]= { { IBM8514MAXPLANES, 8, 32 } } ;

VisualRec ibm8514Visuals[] = {
	{
	0,			/* unsigned long	vid */
	PseudoColor,		/* short       class */
	6,			/* short       bitsPerRGBValue */
	1 << IBM8514MAXPLANES,	/* short	ColormapEntries */
	IBM8514MAXPLANES,	/* short	nplanes */
	0,			/* unsigned long	redMask */
	0,			/* unsigned long	greenMask */
	0,			/* unsigned long	blueMask */
	0,			/* int		offsetRed */
	0,			/* int		offsetGreen */
	0			/* int		offsetBlue */
	}
} ;

#define NUM_VISUALS	(sizeof ibm8514Visuals/sizeof (VisualRec))

unsigned long int ibm8514DepthVIDs[NUM_VISUALS];

DepthRec ibm8514Depths[] = {
/*	depth			numVid		vids */
    {	1,			0,		NULL		 },
    {	IBM8514MAXPLANES,	NUM_VISUALS,	ibm8514DepthVIDs }
} ;

#define ibm8514GCInterestValidateMask \
( GCLineStyle | GCLineWidth | GCJoinStyle | GCBackground | GCForeground	\
| GCFunction | GCPlaneMask | GCFillStyle | GC_CALL_VALIDATE_BIT		\
| GCClipXOrigin | GCClipYOrigin | GCClipMask | GCSubwindowMode )

ppcPrivGC ibm8514PrototypeGCPriv = {
	GXcopy,	/* unsigned char	rop */
	0,	/* unsigned char	ropOpStip */
	0,	/* unsigned char	ropFillArea */
	TRUE,	/* short	fExpose */
	FALSE,	/* short	freeCompClip */
	NullPixmap,	/* PixmapPtr	pRotatedPixmap */
	0,	/* RegionPtr	pCompositeClip */
	ppcAreaFill,	/* void 	(* FillArea)() */
		{
		    ibm8514ALLPLANES,	/* unsigned long	planemask */
		    0,			/* unsigned long	fgPixel */
		    1,			/* unsigned long	bgPixel */
		    GXcopy,		/* int			alu */
		    FillSolid,		/* int			fillStyle */
		}, /* ppcReducedRrop	colorRrop  */
	-1,	/* short lastDrawableType */
	-1,	/* short lastDrawableDepth */
	ibmAbort, /* void (* cachedIGBlt)() */
	ibmAbort, /* void (* cachedPGBlt)() */
	0	/* pointer devPriv */
} ;

GCFuncs ibm8514GCFuncs = {
ppcValidateGC,			/* void (*ValidateGC)() */
NoopDDA,			/* void (*ChangeGC)() */
NoopDDA,			/* void (*CopyGC)() */
ppcDestroyGC,			/* void (*DestroyGC)() */
ppcChangeClip,			/* void (*ChangeClip)() */
ppcDestroyClip,			/* void (*DestroyClip)() */
ppcCopyClip			/* void (*CopyClip)() */
};

GCOps ibm8514GCOps = {
	ibm8514SolidFS,		/*  void (* FillSpans)() */
	ppcSetSpans,		/*  void (* SetSpans)()	 */
	miPutImage,		/*  void (* PutImage)()	 */
	ppcCopyArea,		/*  RegionPtr (* CopyArea)()	 */
	miCopyPlane,		/*  void (* CopyPlane)() */
	ppcPolyPoint,		/*  void (* PolyPoint)() */
	ppcScrnZeroLine,	/*  void (* Polylines)() */
	ppcScrnZeroSegs,	/*  void (* PolySegment)() */
	miPolyRectangle,	/*  void (* PolyRectangle)() */
	miPolyArc,		/*  void (* PolyArc)()	 */
	ibm8514FillPolygon,	/*  void (* FillPolygon)() */
	miPolyFillRect,		/*  void (* PolyFillRect)() */
	miPolyFillArc,		/*  void (* PolyFillArc)() */
	ibm8514PolyText8,	/*  int (* PolyText8)()	 */
	ibm8514PolyText16,	/*  int (* PolyText16)() */
	ibm8514ImageText8,	/*  void (* ImageText8)() */
	ibm8514ImageText16,	/*  void (* ImageText16)() */
	(void (*)()) ibm8514ImageGlyphBlt,	/*  void (* ImageGlyphBlt)() */
	(void (*)()) ppcPolyGlyphBlt,	/*  void (* PolyGlyphBlt)() */
	ibm8514PushPixels,	/*  void (* PushPixels)() */
	miMiter			/*  void (* LineHelper)() */
};

GC ibm8514PrototypeGC = {
	&ibm8514ScreenRec,	/*  ScreenPtr	pScreen	 */
	IBM8514MAXPLANES,	/*  int         depth	 */
	GXcopy,			/*  int		alu	 */
	0,			/*  int		lineWidth */
	0,			/*  int		dashOffset */
	0,			/*  int		numInDashList */
	0,			/*  unsigned char *dash	 */
	LineSolid,		/*  int		lineStyle */
	CapButt,		/*  int		capStyle */
	JoinMiter,		/*  int		joinStyle */
	FillSolid,		/*  int		fillStyle */
	EvenOddRule,		/*  int		fillRule */
	ArcPieSlice,		/*  int		arcMode	 */
	ClipByChildren,		/*  int		subWindowMode */
	TRUE,			/*  Bool	graphicsExposures */
	CT_NONE,		/*  int		clientClipType */
	1,			/*  int		miTranslate:1 */
	1,			/* unsigned int tileIsPixel:1 */
	0,			/* unused:16 */
	ibm8514ALLPLANES,	/*  unsigned long	planemask */
	0,			/*  unsigned long	fgPixel */
	1,			/*  unsigned long	bgPixel */
	0,			/*  PixmapPtr	tile	 */
	0,			/*  PixmapPtr	stipple	 */
	{ 0, 0 },		/*  DDXPointRec	patOrg	 */
	0,			/*  FontPtr	font	 */
	{ 0, 0 },		/*  DDXPointRec	clipOrg	 */
	{ 0, 0 },		/*  DDXPointRec	lastWinOrg */
	NULL,			/*  pointer	clientClip */
	/*(1<<(GCLastBit+1))-1,*/	/*  unsigned long	stateChanges */
	0,			/*  unsigned long	stateChanges */
	0,			/*  unsigned long        serialNumber */
	(GCFuncs *) &ibm8514GCFuncs,	/*  pointer	funcs	 */
	(GCOps *) &ibm8514GCOps,	/*  pointer	ops	 */
	NULL /*  devUnion devPrivates	 */
} ;

ppcScrnPriv ibm8514ScrnPriv = {
	{
		{
			(unsigned char)DRAWABLE_PIXMAP,/* unsigned char  type */
			(unsigned char)0,		/*unsigned char class */
			(unsigned char)IBM8514MAXPLANES, /*unsignedchar depth */
			(unsigned char)1,     /* unsigned char   bitsPerPixel */
			0,		/* unsigned long   id */
			0,		/* short   	   x */
			0,		/* short           y */
			_8514_SCREEN_WIDTH, /* unsigned short  width */
			_8514_SCREEN_HEIGHT, /* unsigned short  height */
			0,		/* ScreenPtr       pScreen */
			0,		/* unsigned long   serialNumber */
		},		/* DrawableRec drawable */
		1,		/* int refcnt */
		_8514_SCREEN_WIDTH / 8,	/* int devKind */
		0		/* pointer devPrivate */
	},			/* PixmapRec	pixmap */
	0,			/* void	(* devHardwareInitBB)() */
	0,			/* void	(* devHardwareInitAB)() */
	&ibm8514PrototypeGC,	/* GCPtr	devPrototypeGC */
	&ibm8514PrototypeGCPriv,/* ppcPrivGC 	*devPrototypeGCPriv */
	ibm8514ChangeGCtype,	/* Mask		(* changeGCtype)() */
	ibm8514ChangeWindowGC,	/* Mask		(* changeWindowGC)() */
	0,			/* Colormap	InstalledColormap */
	ibm8514Bitblt,		/* void	(* blit)() */
	(void (*)()) ibm8514DrawRectangle, /* void	(* solidFill)() */
	ibm8514TileRect,	/* void	(* tileFill)() */
	ibm8514Stipple,		/* void	(* stipFill)() */
	ibm8514OpStipple,	/* void	(* opstipFill)() */
	ibm8514DrawColorImage,	/* void	(* imageFill)() */
	ibm8514ReadColorImage,	/* void	(* imageRead)() */
	ibm8514BresLine,	/* void	(* lineBres)() */
	ibm8514HorzLine,	/* void	(* lineHorz)() */
	ibm8514VertLine,	/* void	(* lineVert)() */
	(void (*)())ibm8514SetColor,	/* void	(* setColor)() */
	ibm8514RecolorCursor,	/* void	(* RecolorCursor)() */
	ibm8514FillMonoImage,	/* void	(* monoFill)() */
	ibm8514DrawMonoByteImage,	/* void	(* glyphFill)() */
	(unsigned long *((*)())) ibmAbort,/* unsigned long *((* planeRead)()) */
	ppcReplicateArea,	/* void	(* replicateArea)() */
	NoopDDA,		/* void	(* DestroyGCPriv)() */
/* High Level Software Cursor Support !! */
	&ibm8514cursorSemaphore,/* int	* CursorSemaphore */
	ibm8514CheckCursor,	/* int	(* CheckCursor)() */
	ibm8514ReplaceCursor,	/* void	(* ReplaceCursor)() */
	0			/* ppcCacheInfoPtr cacheInfo */
} ;

ScreenRec ibm8514ScreenRec = {
	0,			        /* int			myNum */
	0,				/* ATOM         	id */
	_8514_SCREEN_WIDTH,		/* short		width */
	_8514_SCREEN_HEIGHT,		/* short		height */
	(_8514_SCREEN_WIDTH * 254)/800,	/* short		mmWidth */
	(_8514_SCREEN_HEIGHT*254)/800,	/* short		mmHeight */
	sizeof ibm8514Depths/sizeof (DepthRec),	/* short	numDepths */
	IBM8514MAXPLANES,		/* short       		rootDepth */
	ibm8514Depths,			/* DepthPtr       	allowedDepths */
	0,				/* unsigned long      	rootVisual */
	0,				/* unsigned long	defColormap */
	0,				/* short		minInstalledCmaps */
	1,				/* short		maxInstalledCmaps */
	Always,				/* char                backingStoreSupport */
	NotUseful,			/* char                saveUnderSupport */
	IBM8514_WHITE_PIXEL,		/* unsigned long	whitePixel */
	IBM8514_BLACK_PIXEL,		/* unsigned long	blackPixel */
	0,				/* unsigned long	rgf */
	{ 0 },			/* GCPtr	GCperDepth[MAXFORMATS+1] */
	{ 0 },			/* PixmapPtr		PixmapPerDepth[1] */
	(pointer) &ibm8514ScrnPriv,	/* pointer		devPrivate */
	NUM_VISUALS, /* short     	numVisuals */
	&ibm8514Visuals[0],	/* VisualPtr		visuals */
	0,				/* int 		WindowPrivateLen; */
	0,				/* unsigned 	WindowPrivateSizes; */
	0,				/* unsigned 	totalWindowSize; */
	0,				/* int 		GCPrivateLen; */
	0,				/* unsigned 	GCPrivateSizes; */
	0,				/* unsigned 	totalGCSize; */
/* Random screen procedures */
	ibm8514ScreenClose,	/* Bool (* CloseScreen)() */
	ppcQueryBestSize,	/* void (* QueryBestSize)() */
	ibmSaveScreen,		/* Bool (* SaveScreen)() */
	miGetImage,		/* void (* GetImage)() */
	(void (*)()) ibm8514GetSpans, /* void (*GetSpans)() */
	ibmAbort,		/* void (* PointerNonInterestBox)() */
	(void (*)())NULL,			/* void (* SourceValidate)() */
/* Window Procedures */
	ppcCreateWindow,	/* Bool (* CreateWindow)() */
	ppcDestroyWindow,	/* Bool (* DestroyWindow)() */
	ppcPositionWindow,	/* Bool (* PositionWindow)() */
	mfbChangeWindowAttributes,	/* Bool (* ChangeWindowAttributes)() */
	mfbMapWindow,		/* Bool (* RealizeWindow)() */
	mfbUnmapWindow,		/* Bool (* UnrealizeWindow)() */
	miValidateTree,		/* int  (* ValidateTree)() */
	miWindowExposures,	/* void (* WindowExposures)() */
	ppcPaintWindow,		/* void PaintWindowBackground */
	ppcPaintWindow,		/* void PaintWindowBorder */
	ppcCopyWindow,		/* void CopyWindow */
	miClearToBackground,	/* void ClearToBackground */
/* Pixmap procedures */
	ppcCreatePixmap,	/* PixmapPtr (* CreatePixmap)() */
	mfbDestroyPixmap,	/* Bool (* DestroyPixmap)() */
/* Backing store Procedures */
	NoopDDA,	/* void SaveDoomedAreas */
	(RegionPtr (*)())ppcRestoreAreas,	/* RegionPtr RestoreAreas */
	NoopDDA,	/* void ExposeCopy */
	(RegionPtr (*)())NoopDDA,	/* RegionPtr TranslateBackingStore */
	(RegionPtr (*)())NoopDDA,	/* RegionPtr ClearBackingStore */
	NoopDDA,	/* void DrawGuarantee */
/* Font procedures */
	ibm8514RealizeFont,	/* Bool (* RealizeFont)() */
	ibm8514UnrealizeFont,	/* Bool (* UnrealizeFont)() */
/* Cursor Procedures */
	OS_ConstrainCursor,	/* void (* ConstrainCursor)() */
	OS_CursorLimits,	/* void (* CursorLimits)() */
	ibm8514DisplayCursor,	/* Bool (* DisplayCursor)() */
	ibm8514RealizeCursor,	/* Bool (* RealizeCursor)() */
	ibm8514UnrealizeCursor,	/* Bool (* UnrealizeCursor)() */
	miRecolorCursor,	/* void (* RecolorCursor)() */
	OS_SetCursorPosition,	/* Bool (* SetCursorPosition)() */
/* GC procedures */
	ppcCreateGC,		/* Bool (* CreateGC)() */
/* Colormap procedures */
	ppcCreateColormapNoop,	/* void (* CreateColormap)() */
	NoopDDA,		/* void (* DestroyColormap)() */
	ppcInstallColormap,	/* void (* InstallColormap)() */
	ppcUninstallColormap,	/* void (* UninstallColormap)() */
	ppcListInstalledColormaps,	/* int (* ListInstalledColormaps) () */
	ppcStoreColors,		/* void (* StoreColors)() */
	ppcResolveColor,	/* void (* ResolveColor)() */
/* Region procedures */
	miRegionCreate,		/* RegionPtr (* RegionCreate)() */
	miRegionInit,		/* void (* RegionInit)() */
	miRegionCopy,		/* Bool (* RegionCopy)() */
	miRegionDestroy,	/* void (* RegionDestroy)() */
	miRegionUninit,		/* void (* RegionUninit)() */
	miIntersect,		/* int (* Intersect)() */
	miUnion,		/* int (* Union)() */
	miSubtract,		/* int (* Subtract)() */
	miInverse,		/* int (* Inverse)() */
	miRegionReset,		/* void (* RegionReset)() */
	miTranslateRegion,	/* void (* TranslateRegion)() */
	miRectIn,		/* int (* RectIn)() */
	miPointInRegion,	/* Bool (* PointInRegion)() */
	miRegionNotEmpty,	/* Bool (* RegionNotEmpty)() */
	miRegionEmpty,		/* void (* RegionEmpty)() */
	miRegionExtents,	/* BoxPtr (*RegionExtents)() */
	miRegionAppend,		/* BoxPtr (*RegionAppend)() */
	miRegionValidate,	/* BoxPtr (*RegionValidate)() */
	mfbPixmapToRegion,	/* BoxPtr (*BitmapToRegion)() */
	miRectsToRegion,	/* BoxPtr (*RectsToRegion)() */
	miSendGraphicsExpose,	/* void	(*SendGraphicsExpose)() */
/* os layer procedures */
	OS_BlockHandler,	/* void (* BlockHandler)() */
	OS_WakeupHandler,	/* void (* WakeupHandler)() */
	(pointer) 0,		/* pointer blockData */
	(pointer) 0,		/* pointer wakeupData */
	0			/* DevUnion */
} ;
