/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */

/* $Header: brcIO.c,v 1.1 89/11/14 13:25:53 keith Exp $ */
/* $Source: /users/keith/X/ibm8514/RCS/brcIO.c,v $ */

#ifndef lint
static char *rcsid = "$Header: brcIO.c,v 1.1 89/11/14 13:25:53 keith Exp $" ;
#endif

#include "X.h"
#include "servermd.h"
#include "screenint.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "miscstruct.h"
#include "window.h"
#include "windowstr.h"
#include "colormap.h"
#include "colormapst.h"
#include "resource.h"

#include "ibmScreen.h"

#include "ppc.h"

#include "x8514.h"

#include "ibmTrace.h"

int ibm8514HeadInstalled = HEAD_NONE ;
int ibm8514NumberOfPlanes = IBM8514MAXPLANES ;

/******************************************************************************/

static int ibm8514Generation = 0 ;

/* Declared in "ibm8514Data.c" */
extern GC ibm8514PrototypeGC ;
extern ScreenRec ibm8514ScreenRec ;
extern ppcScrnPriv ibm8514ScrnPriv ;
extern VisualRec ibm8514Visuals[] ;
extern DepthRec ibm8514Depths[] ;
extern unsigned long ibm8514DepthVIDs[];
extern PixmapFormatRec ibm8514Formats[] ;

Bool
ibm8514ScreenInit( index, pScreen, argc, argv )
register const int index ;
register ScreenPtr const pScreen ;
register int const argc ;		/* these two may NOT be changed */
register char * const * const argv ;
{
	int	i;
	TRACE( ( "ibm8514ScreenInit(index=%d,pScreen=0x%x,argc=%d,argv=0x%x)\n",
		 index, pScreen, argc, argv ) ) ;

	if ( ibm8514Generation != serverGeneration ) {
		for (i = 0; i < ibm8514ScreenRec.numVisuals; i++)
		{
		    ibm8514DepthVIDs[i] =
			ibm8514Visuals[i].vid = FakeClientID(0);
		}
		ibm8514ScreenRec.rootVisual = ibm8514Visuals[0].vid;
		if ( ( ibm8514NumberOfPlanes = ibm8514ScreenInitHW( index ) )
		     != 8 ) {
			ibm8514PrototypeGC.planemask =
				( ibm8514Visuals[0].ColormapEntries =
					1 << ( ibm8514Visuals[0].nplanes =
					       ibm8514Formats[0].depth = 
					       ibm8514Depths[1].depth =
					       ibm8514ScreenRec.rootDepth =
				       ibm8514ScrnPriv.pixmap.drawable.depth =
					       ibm8514PrototypeGC.depth =
					       ibm8514NumberOfPlanes ) ) - 1 ;
		}
		ibm8514ScrnPriv.pixmap.devKind =
			PixmapBytePad( _8514_SCREEN_WIDTH,
				       ibm8514NumberOfPlanes ) ;
		ibm8514Visuals[0].class = ibm8514QueryHead() ;
		ibm8514Generation = serverGeneration;
	}
	/* Magic Hardware Initialization */
	ibm8514outw( ibm8514_MiscIO, 0x0005 ) ;

	ppcCommonScreenInit( pScreen, index, &ibm8514ScreenRec ) ;

	ibm8514CursorInit( index ) ;
	ibm8514InitFontCache() ;

	/* we MIGHT return 0 if we had been keeping track of potential
	   allocation failures.  one day someone will clean this up.
	*/
	return 1 ;
}

/*ARGSUSED*/
Bool
ibm8514ScreenClose( index, pScreen )
register const int index ;
register ScreenPtr const pScreen ;
{
TRACE( ( "ibm8514ScreenClose(index=%d,pScreen=0x%x)\n", index, pScreen ) ) ;
ppcCommonScreenClose( pScreen, index, &ibm8514ScreenRec ) ;
if ( ibm8514Generation == serverGeneration ) {
	ibm8514outw( ibm8514_MiscIO, 0 ) ;  /* reset 'miscio' */
}

return TRUE ;
}
