/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */

/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcLine.c,v 6.4 89/05/07 15:13:06 paul Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcLine.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcLine.c,v 6.4 89/05/07 15:13:06 paul Exp $" ;
#endif

#include "X.h"
#include "misc.h"
#include "colormapst.h"
#include "pixmapstr.h"

#include "ppc.h"

#include "x8514.h"

#include "ibmTrace.h"

#define X_AXIS 0

extern int mergexlate[] ;
extern int ibm8514cursorSemaphore ;

void
ibm8514HorzLine( color, alu, mask,x,y,w)
unsigned long int color ;
int alu ;
unsigned long int mask ;
int x,y,w ;
{
int saved ;

if (w<=0)
	return ;
saved = !ibm8514cursorSemaphore && ibm8514CheckCursor( x, y, w, 1) ;

ibm8514ClearQueue(7) ;
PLNWENBL(mask) ;
SETCOL1(color) ;
SETFN1(FNCOLOR1,mergexlate[alu]) ;
SETLX(w) ;
SETX0(x) ;
SETY0(y) ;
COMMAND(0x201f) ;


ibm8514CheckQueue(2) ;
SETFN1(FNCOLOR1,FNREPLACE) ;
PLNWENBL( ibm8514ALLPLANES ) ;

if (saved)
    ibm8514ReplaceCursor() ;
return ;
}

void
ibm8514VertLine( color, alu, mask,x,y,h)
unsigned long int color ;
int alu ;
unsigned long int mask ;
int x,y,h ;
{
int saved ;

if ( h <= 0 )
	return ;
saved = !ibm8514cursorSemaphore && ibm8514CheckCursor(x, y, 1, h) ;

ibm8514ClearQueue(7) ;
PLNWENBL(mask) ;
SETCOL1(color) ;
SETFN1(FNCOLOR1,mergexlate[alu]) ;
SETLX(h) ;
SETX0(x) ;
SETY0(y) ;
COMMAND(0x20df) ;

ibm8514ClearQueue(2) ;
SETFN1(FNCOLOR1,FNREPLACE) ;
PLNWENBL( ibm8514ALLPLANES ) ;

if (saved)
    ibm8514ReplaceCursor() ;
return ;
}

void
ibm8514BresLine( color, alu, mask, signdx, signdy, axis, x, y, et, e1, e2, len)
unsigned long int color ;
int alu ;
unsigned long int mask ;
int signdx, signdy, axis, x, y, et, e1, e2, len ;
{
unsigned short command ;
int saved ;
int cx, cy ;

if ( len <= 0 )
	return ;
if (signdx == -1)
    cx = x - len ;
else
    cx = x ;
if (signdy == -1)
    cy = y - len ;
else
    cy = y ;
saved = !ibm8514cursorSemaphore && ibm8514CheckCursor( cx,cy,len,len ) ;

if (axis==X_AXIS)
	command = 0x2017 ; /* draw bres. line on X, W, LPN, */
else
	command = 0x2057 ; /* same, on Y */
if (signdx > 0)
	command |= 0x0020 ;
if (signdy > 0)
	command |= 0x0080 ;

ibm8514ATRNotBusy ;
ibm8514CheckQueue( 5 ) ;
PLNWENBL(mask) ;
SETET(et) ; 
SETK1(e1) ; 
SETK2(e2) ; 
SETFN1(FNCOLOR1,mergexlate[alu]) ;

ibm8514CheckQueue( 5 ) ;
SETCOL1(color) ;
SETLX(len) ; /* going to use LAST PEL NULL in Line command to brecon */
SETX0(x) ;
SETY0(y) ;
COMMAND(command) ;

ibm8514ClearQueue(2) ;
SETFN1( FNCOLOR1, FNREPLACE ) ;
PLNWENBL( ibm8514ALLPLANES ) ;

if (saved)
    ibm8514ReplaceCursor() ;
return ;
}
