/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server( s ) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcMono.c,v 30.0 89/01/23 19:23:54 paul Exp $ */
/* $Source: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcMono.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcMono.c,v 30.0 89/01/23 19:23:54 paul Exp $" ;
#endif

/* MONO-
   This file is here to do the sundry Monochrome ops on the 8514.  You
   may wish to read or write a plane or take a depth - 1 image and use
   it to fill Foreground and Background.

   Monochrome ops to the 8514 are a bear ( in terms of cycles ) when the
   target is not a 4-ple, so these routines plan on you drawing to a 4-ple
   target ( off-screen if necessary ) and blitting to the final destination
   if necessary.
*/

#include "X.h"
#include "Xmd.h"
#include "os.h"

#include "OScompiler.h"

#include "x8514.h"

#include "ibmTrace.h"

extern int mergexlate[] ;
extern int ibm8514cursorSemaphore ;

/* I/O port type is 4 bytes for 6152 but only 2 for i386 !! */
#if defined(ATRIO)
/*
 * Transmogrify: To change or alter greatly and often with
 *	grotesque or humorous effect.
 * ( Websters Ninth New Collegiate Dictionary )
 */
#define transmogrify( byte ) \
( ( ( byte | ( ( ( unsigned short int ) byte ) << 4 ) ) & ~ 0xF0 ) << 1 )

static void
blockouttransmogrifiedw( values, n )
register unsigned char *values ;
register int n ;
{
register unsigned char tmp ;
register volatile unsigned long int * const ptr =
	(volatile unsigned long int *) ( VARDATA | WORDADD ) ;

while ( n-- ) {
	tmp = *values++ ;
	*ptr = (unsigned long int) transmogrify( tmp ) ;
}
return ;
}
#else /* Not "ATRIO" */
#if defined(PCIO )
#if !defined(USE_PORTABLE_BLOCKOUTTRANSMOGRIFIEDW)
extern void blockouttransmogrifiedw() ;
#else /* Not "PCIO" either */
#define transmogrify( byte ) \
( ( ( byte >> 3 ) | ( ( (unsigned short int) byte ) << 9 ) ) & 0x1E1E )

static void
blockouttransmogrifiedw( values, n )
register unsigned char *values ;
register int n ;
{
register unsigned char tmp ;

while ( n-- ) {
	tmp = *values++ ;
	/* XXX make this smarter if we can */
	ibm8514CheckQueue( 1 ) ;
	outw( VARDATA, transmogrify( tmp ) ) ;
}
return ;
}
#endif /* USE_PORTABLE_BLOCKOUTTRANSMOGRIFIEDW */
#else /* Not "PCIO" */
	******** ERROR ********
#endif /* Not "PCIO" */
#endif /* Not "ATRIO" */

/* Used by cursor & FillSpans */
void
ibm8514AlignMonoImage( planes, merge, x, y, lx, ly, data )
unsigned long int planes ;
int merge ;
register int x, y, lx, ly ;
register unsigned char *data ;
{
/*WARNING WARNING WARNING this routine merges 1's to requested planes and 0's
* ro requested planes, BUT ALIGNS X TO BE A MULTIPLE OF FOUR!!!
*
* Use ibm8514StageMono and Blit to get monochrome images elsewhere
*/
    register int width ;
    int CursorIsSaved ;

TRACE(("ibm8514AlignMonoImage(planes=x%x,merge=x%x,x=x%x,y=x%x,lx=x%x,ly=x%x,data=x%x)\n",
	planes, merge, x, y, lx, ly, data ) ) ;

    if ( ( lx <= 0 ) || ( ly <= 0 ) )
	return ;

    CursorIsSaved = !ibm8514cursorSemaphore
		 && ibm8514CheckCursor( x, y, lx, ly ) ;

    ibm8514ATRNotBusy ;
    ibm8514CheckQueue( 4 ) ;
    PLNWENBL( planes ) ;
    SETMODE( M_VAR ) ;
    SETFN0( FNCOLOR0, mergexlate[merge] ) ;
    SETFN1( FNCOLOR1, mergexlate[merge] ) ;
    x &= ~ 03 ; /* alignment happens here */
    ibm8514CheckQueue( 4 ) ;
    SETX0( x ) ;
    SETY0( y ) ;
    /* measured in BITS - clip will discard excess */
    width = ( lx + 0x1F ) >> 5 ;
    SETLX( ( width << 5 ) - 1 ) ;
    SETLY( ly - 1 ) ;

    ibm8514CheckQueue( 4 ) ;
    SETCOL1( 255 ) ;
    SETCOL0( 0 ) ;
    SETXMAX( x + lx - 1 ) ;
    COMMAND( ibm8514WriteXYData ) ;
    blockouttransmogrifiedw( data, width * ly * 4 ) ;

    ibm8514ClearQueue( 5 ) ;
    SETMODE( M_ONES ) ;
    SETFN1( FNCOLOR1, FNREPLACE ) ;
    SETFN0( FNCOLOR0, FNREPLACE ) ;
    PLNWENBL( ibm8514ALLPLANES ) ;
    SETXMAX( _8514_SCREEN_WIDTH - 1 ) ;

    if ( CursorIsSaved )
	ibm8514ReplaceCursor() ;
    return ;
}

/* Used By Stipple */
void
ibm8514StageMono( lx, ly, data )
register int lx, ly ;
register unsigned char *data ;
{
TRACE(("ibm8514StageMono(lx=x%x,ly=x%x,data=x%x)\n",lx,ly,data));

if ( ( lx <= 0 ) || ( ly <= 0 ) )
	return ;
ibm8514AlignMonoImage( MONO_STAGE_WPLANE, GXcopy, MONO_STAGE_X, MONO_STAGE_Y, 
		       lx, ly, data ) ;
return ;
}

/* Not Used ??? */
void
ibm8514FillMonoImage( planes, fg, bg, merge, x, y, lx, ly, data )
unsigned long int planes, fg, bg ;
int merge, x ;
register int y ;
int lx ;
register int ly ;
register unsigned char *data ;
{
register int count ;
int blocksize, CursorIsSaved ;

TRACE(("ibm8514FillMonoImage(planes=x%x,fg=x%x,bg=x%x,merge=x%x,x=x%x,y=x%x,lx=x%x,ly=x%x,data=x%x)\n",
	planes, fg, bg, merge, x, y, lx, ly, data ) ) ;

if ( ( lx <= 0 ) || ( ly <= 0 ) )
	return ;

CursorIsSaved = !ibm8514cursorSemaphore && ibm8514CheckCursor( x, y, lx, ly ) ;
ibm8514cursorSemaphore++ ;

blocksize = ( lx + 3 ) * MONO_STAGE_SIZE ;
count = ( ( ly + MONO_STAGE_SIZE - 1 ) / MONO_STAGE_SIZE ) - 1 ;
while ( count-- ) {
	ibm8514StageMono( lx, MONO_STAGE_SIZE, data ) ;
	ibm8514BlitFGBG( MONO_STAGE_RPLANE, planes, fg, bg, merge, 
			 MONO_STAGE_X, MONO_STAGE_Y, 
			 x, y, lx, MONO_STAGE_SIZE ) ;
	data += blocksize ;
	y += MONO_STAGE_SIZE ;
	ly -= MONO_STAGE_SIZE ;
}
if ( ly ) {
	ibm8514StageMono( lx, ly, data ) ;
	ibm8514BlitFGBG( MONO_STAGE_RPLANE, planes, fg, bg, merge, 
			 MONO_STAGE_X, MONO_STAGE_Y, 
			 x, y, lx, ly ) ;
}
if ( !--ibm8514cursorSemaphore && CursorIsSaved )
	ibm8514ReplaceCursor() ;
return ;
}

/* Not Used ?? */
void
ibm8514DrawMonoByteImage( data, x, y, lx, ly, fg, merge, planes )
register unsigned char *data ;
unsigned long int fg ;
int x, y, lx, ly ;
int merge ;
unsigned long int planes ;
{
/*WARNING WARNING WARNING this routine merges 1's to requested planes and 0's
* ro requested planes, BUT ALIGNS X TO BE A MULTIPLE OF FOUR!!!
*
* Use ibm8514StageMono and Blit to get monochrome images elsewhere
*/
    register int width ;
    int CursorIsSaved ;

TRACE(("ibm8514DrawMonoImage(planes=x%x,merge=x%x,x=x%x,y=x%x,lx=x%x,ly=x%x,data=x%x)\n",
	planes, merge, x, y, lx, ly, data ) ) ;

    if ( ( lx <= 0 ) || ( ly <= 0 ) )
	return ;
    CursorIsSaved = !ibm8514cursorSemaphore
		 && ibm8514CheckCursor( x, y, lx, ly ) ;
    ibm8514ATRNotBusy ;
    ibm8514CheckQueue( 5 ) ;
    PLNWENBL( planes ) ;
    SETMODE( M_VAR ) ;
    SETCOL1( fg ) ;
    SETFN0( FNCOLOR0, FNNOP ) ;
    SETFN1( FNCOLOR1, mergexlate[merge] ) ;
    x &= ~ 03 ; /* alignment happens here */

    ibm8514CheckQueue( 6 ) ;
    SETX0( x ) ;
    SETY0( y ) ;
    width = ( lx + 7 ) >> 3 ;
    SETLX( ( width << 3 ) - 1 ) ;
    /* measured in BITS - clip will discard excess */
    SETLY( ly - 1 ) ;
    SETXMAX( x + lx - 1 ) ;
    COMMAND( ibm8514WriteXYData ) ;

    blockouttransmogrifiedw( data, width * ly * 4 ) ;

    ibm8514ClearQueue( 5 ) ;
    SETMODE( M_ONES ) ;
    SETFN1( FNCOLOR1, FNREPLACE ) ;
    SETFN0( FNCOLOR0, FNREPLACE ) ;
    PLNWENBL( ibm8514ALLPLANES ) ;
    SETXMAX( _8514_SCREEN_WIDTH - 1 ) ;

    if ( CursorIsSaved )
	ibm8514ReplaceCursor() ;
    return ;
}

/* Used For Stipples */
void
ibm8514DrawMonoImage( data, x, y, lx, ly, fg, merge, planes )
register unsigned char *data ;
int x, y, lx, ly ;
unsigned long int fg ;
int merge ;
unsigned long int planes ;
{
/*WARNING WARNING WARNING this routine
* ALIGNS X TO BE A MULTIPLE OF FOUR!!!
*
* Use ibm8514StageMono and Blit to get monochrome images elsewhere
*/
    register int width ;
    int CursorIsSaved ;

TRACE( ( "ibm8514DrawMonoImage( planes=x%x, merge=x%x, x=x%x, y=x%x, lx=x%x, ly=x%x, data=x%x )\n", 
	planes, merge, x, y, lx, ly, data ) ) ;

    if ( ( lx <= 0 ) || ( ly <= 0 ) )
	return ;

    CursorIsSaved = !ibm8514cursorSemaphore && ibm8514CheckCursor( x, y, lx, ly ) ;

    ibm8514ATRNotBusy ;
    ibm8514CheckQueue( 8 ) ;
    PLNWENBL( planes ) ;
    SETMODE( M_VAR ) ;
    SETCOL1( fg ) ;
    SETFN0( FNCOLOR0, FNNOP ) ;
    SETFN1( FNCOLOR1, mergexlate[merge] ) ;
    x &= ~ 03 ; /* alignment happens here */

    SETX0( x ) ;
    SETY0( y ) ;

    width = ( lx + 31 ) >> 5 ;
    SETLX( ( 32*width ) - 1 ) ;  /* measured in BITS - clip will discard excess */

    ibm8514CheckQueue( 3 ) ;
    SETLY( ly - 1 ) ;
    SETXMAX( x + lx - 1 ) ;
    COMMAND( ibm8514WriteXYData ) ;
    blockouttransmogrifiedw( data, width*ly*4 ) ;

    ibm8514ClearQueue( 5 ) ;
    SETMODE( M_ONES ) ;
    SETFN1( FNCOLOR1, FNREPLACE ) ;
    SETFN0( FNCOLOR0, FNREPLACE ) ;
    PLNWENBL( ibm8514ALLPLANES ) ;
    SETXMAX( _8514_SCREEN_WIDTH - 1 ) ;

    if ( CursorIsSaved )
	ibm8514ReplaceCursor() ;

    return ;
}

/* Used By "Glyph-Blit" */
void
ibm8514ByteAlignMonoImage( planes, merge, x, y, lx, ly, data )
unsigned long int planes ;
int merge, x, y, lx, ly ;
register unsigned char *data ;
{
/*WARNING WARNING WARNING this routine merges 1's to requested planes and 0's
* ro requested planes, BUT ALIGNS X TO BE A MULTIPLE OF FOUR!!!
*
* Use ibm8514StageMono and Blit to get monochrome images elsewhere
*/
    register int width ;
    int CursorIsSaved ;

TRACE( ( "ibm8514ByteAlignMonoImage( planes=x%x, merge=x%x, x=x%x, y=x%x, lx=x%x, ly=x%x, data=x%x )\n", 
	planes, merge, x, y, lx, ly, data ) ) ;

    if ( ( lx <= 0 ) || ( ly <= 0 ) )
	return ;

    CursorIsSaved = !ibm8514cursorSemaphore && ibm8514CheckCursor( x, y, lx, ly ) ;

    ibm8514ATRNotBusy ;
    ibm8514CheckQueue( 8 ) ;
    PLNWENBL( planes ) ;
    SETMODE( M_VAR ) ;
    SETFN0( FNCOLOR0, mergexlate[merge] ) ;
    SETFN1( FNCOLOR1, mergexlate[merge] ) ;
    x &= ~ 03 ; /* alignment happens here */

    SETX0( x ) ;
    SETY0( y ) ;
    width =  ( lx + 7 ) >> 3 ;
    SETLX( ( 8*width ) - 1 ) ; /* measured in BITS */
    SETLY( ly - 1 ) ;

    ibm8514CheckQueue( 4 ) ;
    SETCOL1( 255 ) ;
    SETCOL0( 0 ) ;
    SETXMAX( x + lx - 1 ) ;
    COMMAND( ibm8514WriteXYData ) ;
    blockouttransmogrifiedw( data, width * ly ) ;

    ibm8514ClearQueue( 5 ) ;
    SETMODE( M_ONES ) ;
    SETFN1( FNCOLOR1, FNREPLACE ) ;
    SETFN0( FNCOLOR0, FNREPLACE ) ;
    PLNWENBL( ibm8514ALLPLANES ) ;
    SETXMAX( _8514_SCREEN_WIDTH - 1 ) ;

    if ( CursorIsSaved )
	ibm8514ReplaceCursor() ;

    return ;
}
