/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcPgon.c,v 6.3 88/11/16 18:46:44 paquin Exp $ */
/* $Source: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcPgon.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcPgon.c,v 6.3 88/11/16 18:46:44 paquin Exp $";
#endif

/* POLYGON FILL
 *
 */
#include 	"X.h"
#include 	"pixmapstr.h"
#include        "gcstruct.h"
#include        "windowstr.h"
#include        "colormapst.h"

#include	"ppc.h"
#include        "ibmTrace.h"

#include 	"x8514.h"
extern int mfbGCPrivateIndex;

void
ibm8514FillPolygon( dst, pgc, shape, mode, count, pPts )
DrawablePtr	dst;
register GCPtr	pgc;
int		shape, mode;
register int	count;
DDXPointPtr	pPts;
{
register DDXPointPtr ppt;
int i ;

if ( !( i = count ) )
	return ;

if (((ppcPrivGCPtr)pgc->devPrivates[mfbGCPrivateIndex].ptr)->colorRrop.fillStyle != FillSolid)
	{
	miFillPolygon(dst, pgc, shape, mode, count, pPts);
	return;
	}

if (dst->type != DRAWABLE_WINDOW)
	{
	ErrorF("ibm8514FillPolygon: not a window\n");
	miFillPolygon(dst, pgc, shape, mode, count, pPts);
	return;
    	}

ppt = pPts ;
if ( pgc->miTranslate ) {
    	if ( mode != CoordModeOrigin)
	    	for ( ppt++ ; count-- ; ppt++ ) {
	        	ppt->x += (ppt-1)->x;
	        	ppt->y += (ppt-1)->y;
    		}
}
else
	if ( mode == CoordModePrevious )
	    	for ( ppt++ ; count-- ; ppt++ ) {
	        	ppt->x += (ppt-1)->x ;
	        	ppt->y += (ppt-1)->y ;
		}

ibm8514SolidFillPoly( dst, pgc, i, pPts ) ;

return ;
}
