/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcPoly.c,v 6.4 89/05/07 15:18:46 jeff Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcPoly.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcPoly.c,v 6.4 89/05/07 15:18:46 jeff Exp $";
#endif

/* FILL A POLYGON
 *
 */
#include "X.h"
#include "misc.h"
#include "gcstruct.h"
#include "windowstr.h"
#include "colormapst.h"
#include "regionstr.h"

#include "OScompiler.h"

#include "ppc.h"
#include "ibmTrace.h"

#include "x8514.h"

extern int ibm8514Disabled ;

extern int ibm8514cursorSemaphore ;
extern int mfbGCPrivateIndex ;

#define CLEARSTAGE(W,H)	\
	ibm8514DrawRectangle(0,GXclear, MONO_STAGE_WPLANE | FILL_STAGE_WPLANE,\
	MONO_STAGE_X, MONO_STAGE_Y, W, H)

static void
ibm8514StageFill(w,h)
int w,h ;
{
ibm8514ATRNotBusy ;
ibm8514CheckQueue(5);
PLNRENBL(FILL_STAGE_RPLANE);
SETCOL1(255);
PLNWENBL(MONO_STAGE_WPLANE);
SETFN1(FNCOLOR1, FNREPLACE);
SETX0(MONO_STAGE_X);
ibm8514CheckQueue(5);
SETY0(MONO_STAGE_Y);
SETLX(w);
SETLY(h);
SETMODE(M_PLFILL);
COMMAND(0x42f7);

ibm8514ClearQueue(3);
PLNWENBL(RPLANES);
PLNRENBL(RPLANES);
SETMODE(M_ONES);
return;
}

ibm8514SolidFillPoly( pDraw, pGC, count, pts)
    DrawablePtr pDraw;
    GCPtr	pGC;
    int		count;
    DDXPointPtr	pts;
{
    RegionPtr		pCC;
    int			saved, alu ;
    unsigned long int	wPM ;
    int			nbox, x0, y0;
    int			i, j, miny, minx, maxx, maxy, bboxh, bboxw,
			thisboxh, x1, y1, destx, desty, ydelta;
    unsigned long int	fg ;
    BoxRec		*pbox;

if ( ibm8514Disabled )
	return ;

TRACE(("ibm8514SolidFillPoly: pDraw=x%x, pGC=x%x, count=%d, pts=x%x\n",
	pDraw, pGC, count, pts));
pCC = ((ppcPrivGC *)pGC->devPrivates[mfbGCPrivateIndex].ptr)->pCompositeClip;

if ( !( nbox = REGION_NUM_RECTS(pCC) ) || ( ( alu = pGC->alu ) == GXnoop ) )
	return;

wPM = pGC->planemask;
fg  = pGC->fgPixel;
  
minx = miny = _8514_SCREEN_WIDTH;
maxx = maxy = 0;
for (i=0; i<count; i++)
	{
	TRACE(("ibm8514SFPoly: pt[%d] = (%d,%d)\n",i,pts[i].x,pts[i].y));
	minx = MIN(minx,pts[i].x);
	miny = MIN(miny,pts[i].y);
	maxx = MAX(maxx,pts[i].x);
	maxy = MAX(maxy,pts[i].y);
	}

desty = miny + pDraw->y;
destx = minx + pDraw->x;
bboxw = maxx-minx+1;
bboxh = maxy-miny+1;
ydelta = 0;

saved = !ibm8514cursorSemaphore
     && ibm8514CheckCursor(destx, desty, bboxw, bboxh);
ibm8514cursorSemaphore++ ;

while (bboxh>0)
	{
	/* set up the staging area to do the fill*/
	ibm8514ClearQueue(4);
	SETXMIN(MONO_STAGE_X);
	SETYMIN(MONO_STAGE_Y);
	SETXMAX(1023);
	SETYMAX(1023);

	thisboxh = MIN(MONO_STAGE_SIZE,bboxh);
	CLEARSTAGE(bboxw, thisboxh);

	/* Draw the edges */
	for (j=0; j<count-1; j++)
		{
		x0 = pts[j].x + MONO_STAGE_X - minx;
		y0 = pts[j].y + MONO_STAGE_Y - miny - ydelta;
		x1 = pts[j+1].x + MONO_STAGE_X - minx;
		y1 = pts[j+1].y + MONO_STAGE_Y - miny - ydelta;
		ibm8514Outline(FILL_STAGE_WPLANE,x0,y0,x1,y1);
		}
	/* close the polygon */
	x0 = pts[count-1].x + MONO_STAGE_X - minx;
	y0 = pts[count-1].y + MONO_STAGE_Y - miny - ydelta;
	x1 = pts[0].x + MONO_STAGE_X - minx;
	y1 = pts[0].y + MONO_STAGE_Y - miny - ydelta;
	ibm8514Outline(FILL_STAGE_WPLANE,x0,y0,x1,y1);

	/* do the area fill */
	ibm8514StageFill(bboxw, thisboxh);

	/* Now get the stuff up to the real destination */
	pbox = REGION_RECTS(pCC);
	for (i=0; i<nbox; i++, pbox++)
		{
		ibm8514ClearQueue(4);
		SETXMIN(pbox->x1);
		SETYMIN(pbox->y1);
		SETXMAX(pbox->x2-1);
		SETYMAX(pbox->y2-1);
	
		ibm8514BlitFG(MONO_STAGE_RPLANE, wPM,
				fg, alu, 
				MONO_STAGE_X, MONO_STAGE_Y,
				destx, desty,
				bboxw,thisboxh);
		}

	desty += MONO_STAGE_SIZE;
	ydelta += MONO_STAGE_SIZE;
	bboxh -= MONO_STAGE_SIZE;
	}


ibm8514ClearQueue(6);
SETYMIN(0);
SETXMIN(0);
SETYMAX( 1023 ) ;
SETXMAX(_8514_SCREEN_WIDTH-1);
PLNRENBL(RPLANES);
PLNWENBL(WPLANES);

if ( !--ibm8514cursorSemaphore && saved )
	ibm8514ReplaceCursor();
return;
}
