/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcStip.c,v 30.0 89/01/23 19:24:03 paul Exp $ */
/* $Source: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcStip.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcStip.c,v 30.0 89/01/23 19:24:03 paul Exp $" ;
#endif


/* DO STIPPLES!!!
 */

#include "X.h"
#include "servermd.h"
#include "pixmap.h"
#include "pixmapstr.h"
#include "gcstruct.h"

#include "OScompiler.h"

#include "x8514.h"

#include "ibmTrace.h"

extern int ibm8514cursorSemaphore ;
extern PixmapPtr ppcCopyPixmap() ;

void
ibm8514UnnaturalOpStipple( pStipple, fg, bg, merge, planes,
			   x, y, w, h, xSrc, ySrc )
PixmapPtr pStipple ;
unsigned long int fg, bg ;
int merge ;
unsigned long int planes ;
int x ;
int y ;
int w ;
int h ;
int xSrc ;
int ySrc ;
{
int hcount, vcount, vtarget, htarget, savehcount, savehtarget, tlx, tly ;
int maxwid, heightleft, tmp, CursorIsSaved, yoffset, this_height ;
unsigned char *data ;

if ( x < 0 ) {
	w += x ;
	x = 0 ;
}
if ( y < 0 ) {
	h += y ;
	y = 0 ;
}
w = MIN(_8514_SCREENWIDTH-x, w) ;
h = MIN(_8514_SCREENHEIGHT-y, h) ;

if ( ( w <= 0 ) || ( h <= 0 )  )
	return ;

tlx = pStipple->drawable.width ;
tly = pStipple->drawable.height ;

CursorIsSaved = !ibm8514cursorSemaphore
		&& ibm8514CheckCursor( x, y, x + w, y + h ) ;
ibm8514cursorSemaphore++ ;

heightleft = h ;
yoffset = 0 ;

data = pStipple->devPrivate.ptr ;
while ( heightleft > 0 ) {
	this_height = MIN( heightleft, MAXSTIPPLEHEIGHT ) ;
	ibm8514StageMono( tlx, this_height, data ) ;
	/*expand the tile to largest available size */
	maxwid = MIN( MAXSTIPPLEWIDTH, w ) ;
	while ( tlx * 2 <= maxwid ) {
		ibm8514Bitblt( GXcopy, MONO_STAGE_RPLANE, MONO_STAGE_WPLANE,
			       MONO_STAGE_X, MONO_STAGE_Y,
			       tlx + MONO_STAGE_X, MONO_STAGE_Y,
			       tlx, this_height ) ;
		tlx *= 2 ;
	}
	tmp = ( x - xSrc ) % tlx ;
	if ( tmp < 0  )
		tmp += tlx ;
	savehtarget = htarget = x - tmp ;

	tmp = ( y - ySrc ) % tly ;
	if ( tmp < 0  )
		tmp += tly ;
	vtarget = y - tmp + yoffset ;

	/*tiles to fill horiz */
	savehcount = hcount = ( ( x + w - htarget ) + tlx - 1 ) / tlx ;

	/* tiles it will take to fill vert */
	vcount = ( ( y + h - vtarget ) + tly - 1 ) / tly ;

	ibm8514ClearQueue( 4 ) ;
	SETXMAX( x + w - 1 ) ;
	SETYMAX( y + h - 1 ) ;
	SETXMIN( x ) ;
	SETYMIN( y ) ;

	while ( vcount-- ) {
		while ( hcount-- ) {
			ibm8514BlitFGBG( MONO_STAGE_RPLANE, planes,
					 fg, bg, merge,
					 MONO_STAGE_X, MONO_STAGE_Y,
					 htarget, vtarget, tlx, this_height ) ;
			htarget += tlx ;
		}
		vtarget += tly ;
		htarget = savehtarget ;
		hcount = savehcount ;
	}
	yoffset += this_height ;
	heightleft -= this_height ;
	data += this_height * pStipple->devKind ;

	ibm8514ClearQueue( 4 ) ;
	SETXMAX( _8514_SCREENWIDTH - 1 ) ;
	SETYMAX( 1023 ) ;
	SETXMIN( 0 ) ;
	SETYMIN( 0 ) ;
}
if ( !--ibm8514cursorSemaphore && CursorIsSaved  )
	ibm8514ReplaceCursor() ;

return ;
}

void
ibm8514UnnaturalStipple(pStipple, fg, merge, planes, x, y, w, h, xSrc, ySrc )
PixmapPtr pStipple ;
unsigned long int fg ;
int merge ;
unsigned long int planes ;
int x ;
int y ;
int w ;
int h ;
int xSrc ;
int ySrc ;
{
int hcount, vcount, vtarget, htarget, savehcount, savehtarget, tlx, tly ;
int maxwid, heightleft, tmp, CursorIsSaved, yoffset, this_height ;
unsigned char *data ;

if ( x < 0 ) {
	w += x ;
	x = 0 ;
}
if ( y < 0 ) {
	h += y ;
	y = 0 ;
}
w = MIN( _8514_SCREENWIDTH - x, w ) ;
h = MIN( _8514_SCREENHEIGHT - y, h ) ;

if ( w <= 0 || h <= 0 )
	return ;

tlx = pStipple->drawable.width ;
tly = pStipple->drawable.height ;

CursorIsSaved = !ibm8514cursorSemaphore
		&& ibm8514CheckCursor( x, y, x + w, y + h ) ;
ibm8514cursorSemaphore++ ;

heightleft = h ;
yoffset = 0 ;

data = pStipple->devPrivate.ptr ;
while ( heightleft > 0 ) {
	this_height = MIN( heightleft, MAXSTIPPLEHEIGHT ) ;

	ibm8514StageMono( tlx, this_height, data ) ;

	/*expand the tile to largest available size */
	maxwid = MIN( MAXSTIPPLEWIDTH, w ) ;
	while ( tlx*2 <= maxwid ) {
		ibm8514Bitblt( GXcopy, MONO_STAGE_RPLANE, MONO_STAGE_WPLANE,
			       MONO_STAGE_X, MONO_STAGE_Y,
			       tlx + MONO_STAGE_X, MONO_STAGE_Y,
			       tlx, this_height ) ;
		tlx *= 2 ;
	}
	tmp = ( x - xSrc ) % tlx ;
	if ( tmp < 0  )
		tmp += tlx ;
	savehtarget = htarget = x - tmp ;

	tmp = ( y - ySrc ) % tly ;
	if ( tmp < 0  )
		tmp += tly ;
	vtarget =  y - tmp + yoffset ;

	/* tiles to fill horiz */
	savehcount = hcount = ( ( x + w - htarget ) + tlx - 1 ) / tlx ;

	/* tiles it will take to fill vert */
	vcount = ( ( y + h - vtarget ) + tly - 1 ) / tly ;

	ibm8514ClearQueue( 4 ) ;
	SETXMAX( x + w - 1 ) ;
	SETYMAX( y + h - 1 ) ;
	SETXMIN( x ) ;
	SETYMIN( y ) ;

	while ( vcount-- ) {
		while ( hcount-- ) {
			ibm8514BlitFG( MONO_STAGE_RPLANE, planes, fg, merge,
				       MONO_STAGE_X, MONO_STAGE_Y,
				       htarget, vtarget, tlx, this_height ) ;
			htarget += tlx ;
		}
		vtarget += tly ;
		htarget = savehtarget ;
		hcount = savehcount ;
	}
	yoffset += this_height ;
	heightleft -= this_height ;
	data += this_height * pStipple->devKind ;

	ibm8514ClearQueue( 4 ) ;
	SETXMAX( _8514_SCREENWIDTH - 1 ) ;
	SETYMAX( 1023 ) ;
	SETXMIN( 0 ) ;
	SETYMIN( 0 ) ;
}

if ( !--ibm8514cursorSemaphore && CursorIsSaved  )
	ibm8514ReplaceCursor() ;
return ;
}

void
ibm8514Stipple(pStipple, fg, merge, planes, x, y, w, h, xSrc, ySrc )
PixmapPtr pStipple ;
unsigned long int fg ;
int merge ;
unsigned long int planes ;
int x, y, w, h, xSrc, ySrc ;
{
int hcount, vcount, vtarget, htarget, savehcount, savehtarget, tlx, tly ;
int maxhite, maxwid ;
int tmp, CursorIsSaved ;
int xrot, yshift ;

TRACE(("ibm8514Stipple(pStipple = x%x, fg=%d, merge= x%x, planes=x%02x, x=%d, y=%d, w=%d, h=%d, xSrc=%d, ySrc=%d\n)",
		pStipple, fg, merge, planes, x, y, w, h, xSrc, ySrc)) ;
tlx = pStipple->drawable.width ;
tly = pStipple->drawable.height ;

{

if ((x%4 == 0) && (w<=tlx) && (h<=tly) )
	{
	PixmapPtr pTmpStipple ;
	int destroy=FALSE ;

	if (xrot = ((x-xSrc)%tlx) )
		{
		if (!(pTmpStipple = ppcCopyPixmap(pStipple)) )
			{
			ErrorF("Fail ppcCopyPixmap \"pTmpStipple\" \n") ;
			return ;
			}
		destroy = TRUE ;
		ppcRotBitmapRight(pTmpStipple, tlx-xrot) ;
		}
	  if (
	      (
		((w+BITMAP_SCANLINE_PAD-1) >> LOG2_BITMAP_PAD)
		<< LOG2_BYTES_PER_SCANLINE_PAD
	       )
		   <      pStipple->devKind
	     ) {
		PixmapPtr ppcClipBitmap() ;
		if (!destroy )
			{
			if (!(pTmpStipple = ppcClipBitmap(pStipple, w, h)) )
				{
				ErrorF("Fail ppcClipBitxmap\n") ;
				return ;
				}
			destroy = TRUE ;
			}
		else {
			PixmapPtr pNew ;
			if (!(pNew = ppcClipBitmap(pTmpStipple, w, h)) )
				{
				ErrorF("Fail ppcClipBitxmap\n") ;
				mfbDestroyPixmap(pTmpStipple) ;
				return ;
				}
			mfbDestroyPixmap(pTmpStipple) ;
			pTmpStipple = pNew ;
			}
		}
	if (!destroy )
		pTmpStipple = pStipple ;

	yshift = ((y-ySrc)%tly) ;

	if ( yshift > h )
		{
		ibm8514DrawMonoImage( pTmpStipple->devPrivate.ptr
				      + (yshift*pTmpStipple->devKind),
				      x, y, w, h, fg, merge, planes ) ;
		}
	else
		{
		ibm8514DrawMonoImage( pTmpStipple->devPrivate.ptr, x, y+yshift,
					w, h-yshift, fg, merge, planes) ;
		ibm8514DrawMonoImage( pTmpStipple->devPrivate.ptr
			      + (yshift*pTmpStipple->devKind),
			      x, y, w, yshift, fg, merge, planes ) ;
		/*
		WHATS WRONG WITH ALIGNMONOIMAGE HERE????
		ALIGNMONOIMAGE DOESN'T TAKE A FG COLOR
		*/
		}
	if (destroy )
		mfbDestroyPixmap(pTmpStipple) ;

	return ;
	}
}

if ( ( tlx > MAXSTIPPLEWIDTH ) || ( tly > MAXSTIPPLEHEIGHT ) ) {
	ibm8514UnnaturalStipple( pStipple, fg, merge, planes,
				 x, y, w, h, xSrc, ySrc) ;
	return ;
}

if ( x < 0 ) {
	w += x ;
	x = 0 ;
}
if ( y < 0 ) {
	h += y ;
	y = 0 ;
}
w = MIN(_8514_SCREENWIDTH-x, w) ;
h = MIN(_8514_SCREENHEIGHT-y, h) ;

if ( ( w <= 0) || (h <= 0)  )
	return ;

ibm8514StageMono(tlx, tly, pStipple->devPrivate.ptr) ;

/*expand the tile to largest available size */
maxwid = MIN(MAXSTIPPLEWIDTH, w) ;
while ( tlx * 2 <= maxwid ) {
	ibm8514Bitblt( GXcopy, MONO_STAGE_RPLANE, MONO_STAGE_WPLANE,
		MONO_STAGE_X, MONO_STAGE_Y,
		tlx + MONO_STAGE_X, MONO_STAGE_Y,
		tlx, tly ) ;
	tlx *= 2 ;
}
maxhite = MIN(MAXSTIPPLEHEIGHT, h) ;
while ( tly*2 <= maxhite ) {
	ibm8514Bitblt( GXcopy, MONO_STAGE_RPLANE, MONO_STAGE_WPLANE,
		MONO_STAGE_X, MONO_STAGE_Y,
		MONO_STAGE_X, tly+MONO_STAGE_Y,
		tlx, tly) ;
	tly *= 2 ;
}

tmp = ( x - xSrc ) % tlx ;
if ( tmp < 0  )
	tmp += tlx ;
savehtarget = htarget = x - tmp ;
tmp = ( y - ySrc ) % tly ;
if ( tmp < 0  )
	tmp += tly ;
vtarget = y - tmp ;

savehcount = hcount = ((x+w-htarget)+tlx-1)/tlx ; /*tiles to fill horiz */
vcount = ((y+h-vtarget)+tly-1)/tly ; /*tiles it will take to fill vert */

CursorIsSaved = !ibm8514cursorSemaphore
     && ibm8514CheckCursor(htarget, vtarget, hcount*tlx, vcount*tly) ;
ibm8514cursorSemaphore++ ;

ibm8514ClearQueue(4) ;
SETXMAX(x+w-1) ;
SETYMAX(y+h-1) ;
SETXMIN(x) ;
SETYMIN(y) ;

while ( vcount-- ) {
	while ( hcount-- ) {
		ibm8514BlitFG( MONO_STAGE_RPLANE, planes, fg, merge,
				MONO_STAGE_X, MONO_STAGE_Y,
				htarget, vtarget, tlx, tly) ;
		htarget += tlx ;
	}
	vtarget += tly ;
	htarget = savehtarget ;
	hcount = savehcount ;
}

ibm8514ClearQueue(4) ;
SETXMAX(_8514_SCREENWIDTH-1) ;
SETYMAX( 1023 ) ;
SETXMIN(0) ;
SETYMIN(0) ;
if ( !(--ibm8514cursorSemaphore) && CursorIsSaved  )
	ibm8514ReplaceCursor() ;
return ;
}

void
ibm8514OpStipple(pStipple, fg, bg, merge, planes, x, y, w, h, xSrc, ySrc )
PixmapPtr pStipple ;
unsigned long int fg, bg ;
int merge ;
unsigned long int planes ;
int x, y, w, h, xSrc, ySrc ;
{
int hcount, vcount, vtarget, htarget, savehcount, savehtarget, tlx, tly ;
int maxhite, maxwid ;
int tmp, CursorIsSaved ;

TRACE(("ibm8514Stipple(pStipple = x%x, fg=%d, merge= x%x, planes=x%02x, x=%d, y=%d, w=%d, h=%d, xSrc=%d, ySrc=%d\n",
		pStipple, fg, merge, planes, x, y, w, h, xSrc, ySrc)) ;

tlx = pStipple->drawable.width ;
tly = pStipple->drawable.height ;

if ( ( tlx > MAXSTIPPLEWIDTH ) || ( tly > MAXSTIPPLEHEIGHT ) ) {
       ibm8514UnnaturalOpStipple( pStipple, fg, bg, merge, planes,
				  x, y, w, h, xSrc, ySrc ) ;
	return ;
}

if ( x < 0 ) {
	w += x ;
	x = 0 ;
}
if ( y < 0 ) {
	h += y ;
	y = 0 ;
}
w = MIN(_8514_SCREENWIDTH-x, w) ;
h = MIN(_8514_SCREENHEIGHT-y, h) ;

if ( (w <= 0) || (h <= 0 )  )
	return ;

ibm8514StageMono(tlx, tly, pStipple->devPrivate.ptr) ;

/*expand the tile to largest available size */
maxwid = MIN(MAXSTIPPLEWIDTH, w) ;
while ( tlx*2 <= maxwid )
	{
	ibm8514Bitblt(GXcopy, MONO_STAGE_RPLANE, MONO_STAGE_WPLANE,
		MONO_STAGE_X, MONO_STAGE_Y,
		tlx+MONO_STAGE_X, MONO_STAGE_Y,
		tlx, tly) ;
	tlx *= 2 ;
	}
maxhite = MIN(MAXSTIPPLEHEIGHT, h) ;
while ( tly*2 <= maxhite )
	{
	ibm8514Bitblt(GXcopy, MONO_STAGE_RPLANE, MONO_STAGE_WPLANE,
		MONO_STAGE_X, MONO_STAGE_Y,
		MONO_STAGE_X, tly+MONO_STAGE_Y,
		tlx, tly) ;
	tly *= 2 ;
	}

tmp = ( x - xSrc ) % tlx ;
if ( tmp < 0  )
	tmp += tlx ;
savehtarget = htarget =  x - tmp ;
tmp = ((y-ySrc)%tly) ;
if ( tmp < 0  )
	tmp += tly ;
vtarget =  y - tmp ;

savehcount = hcount = ((x+w-htarget)+tlx-1)/tlx ; /*tiles to fill horiz */
vcount = ((y+h-vtarget)+tly-1)/tly ; /*tiles it will take to fill vert */

CursorIsSaved = !ibm8514cursorSemaphore
     && ibm8514CheckCursor(htarget, vtarget, hcount*tlx, vcount*tly) ;
ibm8514cursorSemaphore++ ;

ibm8514ClearQueue(4) ;
SETXMAX(x+w-1) ;
SETYMAX(y+h-1) ;
SETXMIN(x) ;
SETYMIN(y) ;

while ( vcount-- ) {
	while ( hcount-- ) {
		ibm8514BlitFGBG(MONO_STAGE_RPLANE, planes, fg, bg, merge,
				MONO_STAGE_X, MONO_STAGE_Y,
				htarget, vtarget, tlx, tly) ;
		htarget += tlx ;
	}
	vtarget += tly ;
	htarget = savehtarget ;
	hcount = savehcount ;
}

ibm8514ClearQueue(4) ;
SETXMAX(_8514_SCREENWIDTH-1) ;
SETYMAX( 1023 ) ;
SETXMIN(0) ;
SETYMIN(0) ;
if ( !(--ibm8514cursorSemaphore) && CursorIsSaved  )
	ibm8514ReplaceCursor() ;
return ;
}
