/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */

#include "X.h"
#include "windowstr.h"
#include "window.h"
#include "pixmapstr.h"
#include "scrnintstr.h"
#include "gcstruct.h"
#include "cursorstr.h"

#include "OScompiler.h"

#include "ibmIOArch.h"
#include "ibmScreen.h"

#include "ppcGCstr.h"
#include "ppcScrn.h"

#include "x8514.h"

#define CURSOR_ONLY
#include "brcProcs.h"

#if defined(ibm032) && defined(BSDrt)
#define ATR
#include <sys/ioctl.h>
#include <machinecons/buf_emul.h>
#else
#ifdef i386
        /* Nothing Yet */
#else
        ******** ERROR ********
#endif
#endif

#if defined(IBM_OS_HAS_HFT) && !defined(IBM_OS_HAS_X_QUEUE)
#define HFT_HACKS "Oh no. The hack is here!"
#endif

#if !defined(HFT_HACKS)
extern WindowPtr ObscureEntireScreen() ;
#else
extern void ibmSaveScreenData() ;
extern void ibmRestoreScreenData() ;
extern void ppcSaveAreas() ;
extern void ppcRestoreAreas() ;
#endif

/* Data from brcScrInfo.c */
extern ibmPerScreenInfo ibm8514ScreenInfoStruct ;

/* Data from brcData.c */
extern ppcScrnPriv ibm8514ScrnPriv ;

/* Procedures from brcCurs.c */
extern void ibm8514RemoveCursor() ;
extern void ibm8514ShowCursor() ;

/* Procedures from brcutils.c */
extern void ibm8514InitializeHardwareState() ;
extern int ibm8514FD ;

/* ************************************************************************** */

int ibm8514Disabled = 0 ;

/* Private State Variables */
static int CursorWasActive = 0 ;
static ppcScrnPriv savedibm8514ScrnPriv ;
static WindowPtr coveringWindow = (WindowPtr) 0 ;

static int
DoNaught()
{
return 0 ;
}

#if !defined(HFT_HACKS)
void
ibm8514SuspendScreenAndSave( index )
int index ;
#else /* erik's hft hack */
void
ibm8514SuspendScreenAndSave( pScreen, saveBits )
ScreenPtr pScreen ;
int saveBits ;
#endif
{
if ( ibm8514ScreenInfoStruct.ibm_ScreenState == SCREEN_ACTIVE ) {
	/* Now Disable any further screen writes
	 * by preventing call though the screen-priv
	 */
	savedibm8514ScrnPriv = ibm8514ScrnPriv ;
	CursorWasActive = !ibm8514cursorSemaphore
			&& ibm8514CheckCursor( 0, 0, _8514_SCREENWIDTH,
					       _8514_SCREENHEIGHT ) ;
	ibm8514cursorSemaphore++ ;

	/* Fields in the ibmPerScreenInfo Structure */
	ibm8514ScreenInfoStruct.ibm_HideCursor = (void (*)()) DoNaught ;
	ibm8514ScreenInfoStruct.ibm_CursorShow = (void (*)()) DoNaught ;

#if !defined(HFT_HACKS)
	coveringWindow =
		ObscureEntireScreen( ibm8514ScreenInfoStruct.ibm_Screen ) ;
#else /* erik's hft hack */
	if ( saveBits )
		ibmSaveScreenData( pScreen, ppcSaveAreas ) ;
#endif

	/* Fields in the ppcScrnPriv Structure */
	ibm8514ScrnPriv.blit = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.solidFill = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.tileFill = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.stipFill = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.opstipFill = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.imageFill = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.imageRead = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.lineBres = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.lineHorz = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.lineVert = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.setColor = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.RecolorCursor = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.monoFill = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.glyphFill = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.planeRead = (unsigned long int *(*)()) DoNaught ;
	ibm8514ScrnPriv.replicateArea = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.DestroyGCPriv = (void (*)()) DoNaught ;
	ibm8514ScrnPriv.CheckCursor = (int (*)()) DoNaught ;
	ibm8514ScrnPriv.ReplaceCursor = (void (*)()) DoNaught ;

	/* Make the list of cached fonts */
	ibm8514CreateSavedFontList() ;

	ibm8514ScreenInfoStruct.ibm_ScreenState = SCREEN_INACTIVE ;
	ibm8514Disabled = 1 ;
}
else if ( ibm8514ScreenInfoStruct.ibm_ScreenState == SCREEN_INACTIVE ) {
	ErrorF(
	  "ibm8514SuspendScreenAndSave: ibm8514 State Is Already Inactive!" ) ;
}
else if ( ibm8514ScreenInfoStruct.ibm_ScreenState == SCREEN_UNINITIALIZED ) {
	ErrorF( "ibm8514SuspendScreenAndSave: ibm8514 Still uninitialized!" ) ;
}

return ;
}

#if !defined(HFT_HACKS)
void
ibm8514RestoreScreenAndActivate( index )
int index ;
#else /* erik's hft hack */
ibm8514RestoreScreenAndActivate( pScreen, restoreBits )
ScreenPtr pScreen ;
int restoreBits ;
#endif
{
ColormapPtr currentColormap ;

if ( ibm8514ScreenInfoStruct.ibm_ScreenState == SCREEN_INACTIVE ) {

#if defined(ibm032) && defined(BSDrt)
	(void) ioctl( ibm8514FD, BUFINIT8514, 0 ) ;
#else
#ifdef i386
        /* Nothing Yet */
#else
	********* ERROR ********
#endif
#endif
	ibm8514InitializeHardwareState() ;
	/* Magic Hardware Initialization */
	ibm8514outw( ibm8514_MiscIO, 0x0005 ) ;

	/* Re-enable Cursor Fields in the ibmPerScreenInfo Structure */
	ibm8514ScreenInfoStruct.ibm_HideCursor = ibm8514RemoveCursor ;
	ibm8514ScreenInfoStruct.ibm_CursorShow = ibm8514ShowCursor ;

	/* Now Re-Enable any screen writes by restoring the screen-priv */
	currentColormap = ibm8514ScrnPriv.InstalledColormap ;
	ibm8514ScrnPriv = savedibm8514ScrnPriv ;

	/* Now Re-Realize any Cache-able Fonts !! */

	/* Now We Are Free to Draw Again !! */
	ibm8514Disabled = 0 ;
#if !defined(HFT_HACKS)
	FreeResource( coveringWindow->drawable.id, RT_NONE ) ;
	coveringWindow = (WindowPtr) 0 ;
#else /* erik's hft hack */
	if ( restoreBits )
		ibmRestoreScreenData( pScreen, ppcRestoreAreas ) ;
#endif

	/* Now Reinstall the current Colormap !! */
	ppcInstallColormap( currentColormap ) ;

	if ( !--ibm8514cursorSemaphore && CursorWasActive )
		ibm8514ReplaceCursor() ;

	ibm8514ScreenInfoStruct.ibm_ScreenState = SCREEN_ACTIVE ;
#if !defined(HFT_HACKS)
	ibm8514RestoreOffScreenFonts( ibmScreen( index ) ) ;
#else /* erik's hft hack */
	ibm8514RestoreOffScreenFonts( pScreen ) ;
#endif
}
else if ( ibm8514ScreenInfoStruct.ibm_ScreenState == SCREEN_ACTIVE ) {
	ErrorF(
	  "ibm8514SuspendScreenAndSave: ibm8514 State Is Still Active!" ) ;
}
else if ( ibm8514ScreenInfoStruct.ibm_ScreenState == SCREEN_UNINITIALIZED ) {
	ErrorF( "ibm8514SuspendScreenAndSave: ibm8514 Still uninitialized!" ) ;
}

return ;
}
