/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcTile.c,v 6.3 89/05/07 15:09:49 paul Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcTile.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcTile.c,v 6.3 89/05/07 15:09:49 paul Exp $" ;
#endif

/* Tile an area with a pixmap image.
 *
 */
#include "X.h"
#include "misc.h"
#include "gcstruct.h"
#include "pixmapstr.h"

#include "OScompiler.h"

#include "x8514.h"

#include "ibmTrace.h"

extern int ibm8514cursorSemaphore ;

void
ibm8514RotateTile( w, h, dx, dy )
int w, h, dx, dy ;
{
	register int rx, ry ;

	/*THIS IS COMPLETELY OFFSCREEN, SO DISABLE CURSORCHECKING */
	ibm8514cursorSemaphore++ ;

	rx = w - dx ;
	ry = h - dy ;

	/* DO BOTTOM RIGHT */
	/* You definitely want to do this, even if dx==dy==0.
	   This is to force *something* into the RotatedTile location */
	ibm8514Bitblt( GXcopy, ibm8514ALLPLANES, ibm8514ALLPLANES,
			TILE_X + dx, TILE_Y + dy,
			ROTTILE_X, ROTTILE_Y,
			rx, ry ) ;

	/* DO TOP RIGHT */
	if (dy)
		ibm8514Bitblt( GXcopy, ibm8514ALLPLANES, ibm8514ALLPLANES,
			TILE_X + dx, TILE_Y,
			ROTTILE_X, ROTTILE_Y + ry,
			rx, dy ) ;

	/* DO BOTTOM LEFT */
	if (dx)
		{
		ibm8514Bitblt( GXcopy, ibm8514ALLPLANES, ibm8514ALLPLANES,
			TILE_X , TILE_Y+dy,
			ROTTILE_X+rx, ROTTILE_Y,
			dx, ry ) ;

	/* DO TOP LEFT */
		if (dy)
		ibm8514Bitblt( GXcopy,  ibm8514ALLPLANES, ibm8514ALLPLANES,
			TILE_X , TILE_Y,
			ROTTILE_X+rx, ROTTILE_Y+ry,
			dx, dy ) ;
		}

	/* set things back the way you found them */
	ibm8514cursorSemaphore-- ;

	return ;
}

void
ibm8514TileRect( pTile, merge, planes, x, y, w, h, xSrc, ySrc )
PixmapPtr pTile ;
int merge ;
unsigned long int planes ;
int x ;
int y ;
int w ;
int h ;
int xSrc ;
int ySrc ;
{
int htarget, tlx, tly ;
int maxhite, maxwid ;
int CursorIsSaved ;
int tmp_w, tw, th, hoffset, voffset ;

TRACE( ( "ibm8514TileRect(pTile=x%x,merge=x%x,planes=x%02x,x=%d,y=%d,w=%d,h=%d,xSrc=%d,ySrc=%d\n",
	pTile, merge, planes, x, y, w, h, xSrc, ySrc ) ) ;

x = MAX(0,x) ;
y = MAX(0,y) ;
w = MIN(_8514_SCREENWIDTH-x,w) ;
h = MIN(_8514_SCREENHEIGHT-y,h) ;

if ( (w <= 0) || (h <= 0) )
	return ;

/* trap the trivial cases.  Use ppcrep if you can.  Fall thru to do the hard
   cases if you have to. */

switch ( merge ) {
	case GXset :
	case GXclear :
	case GXinvert :
		ibm8514DrawRectangle( ibm8514ALLPLANES, merge, planes,
				      x, y, w, h ) ;
	case GXnoop:
		return ;
	case GXcopy :
	case GXcopyInverted :
		ppcTileRect( pTile, merge, planes, x, y, w, h, xSrc, ySrc ) ;
		return ;
	default :
		tlx = pTile->drawable.width ;
		tly = pTile->drawable.height ;
		if ( ( tlx > MAXTILESIZE ) || ( tly > MAXTILESIZE ) ) {
			ppcTileRect( pTile, merge, planes,
				     x, y, w, h, xSrc, ySrc ) ;
			return ;
		}
		break ;
}

CursorIsSaved = !ibm8514cursorSemaphore && ibm8514CheckCursor( x, y, w, h ) ;
ibm8514cursorSemaphore++ ;

/* ALAS, ALACK, we are going to have to actually draw the silly thing N
   times.  I won't bother rotating it, I'll just draw to the origin points
   clipped to the desired box.  It's not clear when this is a win.
*/
ibm8514DrawColorImage( TILE_X, TILE_Y, tlx, tly,
		       pTile->devPrivate.ptr,
		       pTile->devKind,
		       GXcopy, ibm8514ALLPLANES ) ;

/*expand the tile to largest available size */
maxwid = MIN( MAXTILESIZE, w ) ;
while ( tlx << 1 <= maxwid ) {
	ibm8514Bitblt( GXcopy, ibm8514ALLPLANES, ibm8514ALLPLANES,
		       TILE_X, TILE_Y, tlx + TILE_X, TILE_Y, tlx, tly ) ;
	tlx <<= 1 ;
}
maxhite = MIN( MAXTILESIZE, h ) ;
while ( tly << 1 <= maxhite ) {
	ibm8514Bitblt( GXcopy, ibm8514ALLPLANES, ibm8514ALLPLANES,
		       TILE_X, TILE_Y, TILE_X, TILE_Y + tly, tlx, tly ) ;
	tly <<= 1 ;
}

if ( ( hoffset = ( x - xSrc ) % tlx ) < 0 )
	hoffset += tlx ;
if ( ( voffset = ( y - ySrc ) % tly ) < 0 )
	voffset += tly ;

ibm8514RotateTile( tlx, tly, hoffset, voffset ) ;

for ( ; h ; h -= th, y += th ) {
	th = MIN( h, tly ) ;
	for ( htarget = x, tmp_w = w ; tmp_w ; tmp_w -= tw, htarget += tlx )
		ibm8514Bitblt( merge, ibm8514ALLPLANES, planes,
			       ROTTILE_X, ROTTILE_Y,
			       htarget, y,
			       tw = MIN( tmp_w, tlx ), th ) ;
}

if ( !--ibm8514cursorSemaphore && CursorIsSaved )
	ibm8514ReplaceCursor() ;

return ;
}
