/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcUtils.c,v 6.4 89/05/07 15:18:57 jeff Exp $ */
/* $Source: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcUtils.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/r3plus/server/ddx/ibm/ibm8514/RCS/brcUtils.c,v 6.4 89/05/07 15:18:57 jeff Exp $" ;
#endif

#include "X.h"
#include "cursorstr.h"
#include "scrnintstr.h"
#include "miscstruct.h"

#include "OScompiler.h"

#include "x8514.h"
#include "ibmTrace.h"

extern int ibm8514HeadInstalled ;

int mergexlate[16] ;

/******************************************************************************/

short
ibm8514QueryHead()
{

switch ( ibm8514HeadInstalled = ( QCTRL & 0x0070 ) >> 4 )
	{
	case HEAD_COLOR1024:
	case HEAD_COLOR640:
		return PseudoColor ;
	case HEAD_GRAY1024:
	case HEAD_GRAY640:
		return GrayScale ;
	case 0 : /* Temporarily 0 for the 19-inch grayscale tube */
		return GrayScale ;
	default:
		ErrorF("ibm8514QueryHead: No known head attached. value = %d\n",
			ibm8514HeadInstalled ) ;
		return -1 ; /* Ramdom Error Value */
	}
/*NOTREACHED*/
}

/******************************************************************************/

int
ibm8514QueryPlanes()
{
return ( QCTRL & 0x0080 ) ? 8 : 4 ;
}

/******************************************************************************/

void
ibm8514InitializeHardwareState()
{

TRACE( ( "ibm8514InitializeHardwareState()\n" ) ) ;

    ibm8514outw( ibm8514_MiscIO, 0 ) ; /* reset 'miscio' */
    CRTCMODE( 0x0053 ) ; /* reset on */
    ibm8514SetVideoRegisters() ;
    CRTCMODE( 0x0033 ) ; /* reset off */

    ibm8514outw( ibm8514_MiscIO,    0x0005 ) ;   /* set 'miscio' */
    ibm8514outw( ibm8514_Control,   0x9000 ) ;    /* reset brecon */
    ibm8514outw( ibm8514_SecDecode, 0x5006 ) ;   /* set config */
    ibm8514outw( ibm8514_Control,   0x400F ) ;    /* set constat */

    ibm8514ATRNotBusy ;
    ibm8514CheckQueue( 7 ) ;
    SETCOL0( 0 ) ;
    SETCOL1( ibm8514ALLPLANES ) ;
    PLNWENBL( ibm8514ALLPLANES ) ; /* enable all planes for write */
    PLNRENBL( ibm8514ALLPLANES ) ; /* enable all planes for read */
    SETFN0( FNCOLOR0, FNREPLACE ) ; /* my routines assume this is true */
    SETFN1( FNCOLOR1, FNREPLACE ) ; /* my routines assume this is true */
    SETMODE( M_ONES ) ; /* assumed by this set of routines */

    ibm8514CheckQueue( 6 ) ;
    SETPAT0( 0 ) ; /* currently, I am not using the Pattern registers */
    SETPAT1( 0 ) ;
    SETXMIN( 0 ) ; /* clip */
    SETYMIN( 0 ) ; /* clip */
    SETXMAX( _8514_SCREEN_WIDTH - 1 ) ; /* clip */
    SETYMAX( 1023 ) ; /* clip */

    return ;
}

int
ibm8514ScreenInitHW( index )	/* returns number of planes */
register int index ;
{
register int planes ;
extern void ibm8514osdInit() ; /* defined in ibm8514osd.c */

TRACE( ( "ibm8514ScreenInitHW(index=%d)\n", index ) ) ;

    mergexlate[GXclear]	 	= 0x01 ;
    mergexlate[GXand] 		= 0x0C ;
    mergexlate[GXandReverse] 	= 0x0D ;
    mergexlate[GXcopy] 		= 0x07 ;
    mergexlate[GXandInverted] 	= 0x0E ;
    mergexlate[GXnoop] 		= 0x03 ;
    mergexlate[GXxor] 		= 0x05 ;
    mergexlate[GXor] 		= 0x0B ;
    mergexlate[GXnor] 		= 0x0F ;
    mergexlate[GXequiv] 	= 0x06 ;
    mergexlate[GXinvert] 	= 0x00 ;
    mergexlate[GXorReverse] 	= 0x0A ;
    mergexlate[GXcopyInverted] 	= 0x04 ;
    mergexlate[GXorInverted] 	= 0x09 ;
    mergexlate[GXnand] 		= 0x08 ;
    mergexlate[GXset]	 	= 0x02 ;

    /* ******************** OS-DEPENDANT CALL ******************** */
    ibm8514osdInit( index ) ; /* defined in ibm8514osd.c */
    /* Now is the first time the device registers may be referenced legally */
    if ( !( planes = ibm8514QueryPlanes() ) || ( ibm8514QueryHead() < 0 ) )
	return 0 ;

    ibm8514InitializeHardwareState() ;

    return planes ;
}

#if defined(ATR) && defined(BSDrt)

/******************************************************************************/
/*
 *			WARNING!!!!!!!!!!!
 *
 * This routine does byte swapping!!  If you've never encountered this
 * delightful consumer of your time, be careful!  And be glad you're dealing
 * with Intel processors!!!
 *
 * Need to Byte-Swap for RT processor
 */
unsigned short
ibm8514inw(addr)
register unsigned int addr ;
{
register unsigned long int retval ;

retval = *( (volatile unsigned long int *) ( addr | WORDADD ) ) ;
return (unsigned short) ( ((retval&0x0000ff00)>>8) | ((retval&0x000000ff)<<8) ) ;
}
#endif

/******************************************************************************/

#if defined(DEBUG) && !defined(NDEBUG)

#include <fcntl.h>

int
ibm8514LoadPalette(fn)
char *fn ;
{ int fh,i ;
  unsigned char block[1024],c,r,g,b,*p ;
  unsigned int red,green,blue ;

  fh = open(fn,O_RDONLY) ;
  if (fh<0) { ErrorF("ibm8514LoadPalette: Error opening %s\n",fn) ; return(-1) ; }

  i = read(fh,block,1024) ;
  if (i!=1024) {ErrorF("ibm8514LoadPalette: Error reading %s\n",fn) ;return(-1) ;}

  p = block ;
  for (i=0 ; i<256 ; i++)
         {
         c = i ;
         r = *p++ ;
         b = *p++ ;  /* note that its RBG, unlike hardware, which is RGB */
         g = *p++ ;
         p++ ; /* dummy */
	red   = ((int)r) ;
	green = ((int)g) ;
	blue  = ((int)b) ;
	red   <<=8 ;
	green <<=8 ; /* file contents are 8 bits per color */
	blue  <<=8 ;
         ibm8514SetColor(c,red,green,blue) ;
         }
  (void) close(fh) ;
return 0 ;
}
#endif
