/* flog.c - edit 1

	flog.c - a program to view FlashICE log
	(C) 1996 Grammar Engine, Inc.
*/

#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#ifdef MSDOS
#include <io.h>
#endif
#include "pidriver.h"

int log;
unsigned char buf[1024];

#ifdef ANSI
void main(int argc, char **argv)
#else
void main(argc, argv)
int argc;
char **argv;
#endif
	{
	char *logfile,r[6];
	int getlog();
	int len,i,j;

	if (argc > 1)
		logfile = *++argv;
	else
		logfile = "flashice.log";

#ifdef MSDOS
	if ((log = open(logfile,O_BINARY|O_RDONLY)) < 0)
#else
	if ((log = open(logfile,O_RDONLY)) < 0)
#endif
		perror("Logfile"),exit(1);
	while(len=getlog())
		{
		for (i=0; i<len; i+=6)
			{
			for (j=0; j<6; j++)
				r[j] = buf[i+j];

			printf("\n%02X%02X %02X%02X%02X %02X",
				r[0]&0xff,r[1]&0xff,r[2]&0xff,r[3]&0xff,r[4]&0xff,r[5]&0xff);

			if (r[0] & FIA_BPS)
				printf("\n Byte Program Seen");
			if (r[0] & FIA_BPN)
				printf("\n Byte Program Cycle");
			if (r[0] & FIA_ICS)
				printf("\n Illegal Command Seen");
			if (r[1] & FIB_ERS)
				printf("\n Erase Seen");
			if (r[0] & FIA_SUS)
				printf("\n Suspend Erase Seen");
			if (r[0] & FIA_SES)
				printf("\n Sector Erase Seen");
			if (r[0] & FIA_CES)
				printf("\n Chip Erase Seen");
			if (r[1] & FIB_ASS)
				printf("\n Auto Select Entered");
			if (r[1] & FIB_RRS)
				printf("\n Read Reset Seen");
			if (r[1] & FIB_SMA)
				printf("\n Unlock Sequence Entered");
			if (r[1] & FIB_SMB)
				printf("\n Unlock Sequence Complete");
			}
		}
	}

int getlog()
		{
		return(read(log,buf,1020));
		}
